/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.DoubleCheck;
import dagger.internal.MemoizedSentinel;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.FrameworkField;
import dagger.internal.codegen.binding.KeyVariableNamer;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.BindingExpression;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ProducerEntryPointView;
import dagger.model.RequestKind;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

abstract class MethodBindingExpression
extends BindingExpression {
    private final BindingRequest request;
    private final ContributionBinding binding;
    private final BindingMethodImplementation bindingMethodImplementation;
    private final ComponentImplementation componentImplementation;
    private final ProducerEntryPointView producerEntryPointView;
    private final BindingExpression wrappedBindingExpression;
    private final DaggerTypes types;

    protected MethodBindingExpression(BindingRequest request, ContributionBinding binding, MethodImplementationStrategy methodImplementationStrategy, BindingExpression wrappedBindingExpression, ComponentImplementation componentImplementation, DaggerTypes types) {
        this.request = (BindingRequest)Preconditions.checkNotNull((Object)request);
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.bindingMethodImplementation = this.bindingMethodImplementation(methodImplementationStrategy);
        this.wrappedBindingExpression = (BindingExpression)Preconditions.checkNotNull((Object)wrappedBindingExpression);
        this.componentImplementation = (ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation);
        this.producerEntryPointView = new ProducerEntryPointView(types);
        this.types = (DaggerTypes)Preconditions.checkNotNull((Object)types);
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        if (this.request.frameworkType().isPresent()) {
            CodeBlock codeBlock = this.methodBody();
        }
        this.addMethod();
        return Expression.create(this.returnType(), requestingClass.equals((Object)this.componentImplementation.name()) ? CodeBlock.of((String)"$N()", (Object[])new Object[]{this.methodName()}) : CodeBlock.of((String)"$L.$N()", (Object[])new Object[]{this.componentImplementation.externalReferenceBlock(), this.methodName()}));
    }

    @Override
    Expression getDependencyExpressionForComponentMethod(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation component) {
        return this.producerEntryPointView.getProducerEntryPointField(this, componentMethod, component).orElseGet(() -> super.getDependencyExpressionForComponentMethod(componentMethod, component));
    }

    protected abstract void addMethod();

    protected abstract String methodName();

    protected final CodeBlock methodBody() {
        return this.implementation((Supplier<CodeBlock>)((Supplier)this.wrappedBindingExpression.getDependencyExpression(this.componentImplementation.name())::codeBlock));
    }

    protected final CodeBlock methodBodyForComponentMethod(ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
        return this.implementation((Supplier<CodeBlock>)((Supplier)this.wrappedBindingExpression.getDependencyExpressionForComponentMethod(componentMethod, this.componentImplementation)::codeBlock));
    }

    private CodeBlock implementation(Supplier<CodeBlock> simpleBindingExpression) {
        return this.bindingMethodImplementation.implementation(simpleBindingExpression);
    }

    private BindingMethodImplementation bindingMethodImplementation(MethodImplementationStrategy methodImplementationStrategy) {
        switch (methodImplementationStrategy) {
            case SIMPLE: {
                return new SimpleMethodImplementation();
            }
            case SINGLE_CHECK: {
                return new SingleCheckedMethodImplementation();
            }
            case DOUBLE_CHECK: {
                return new DoubleCheckedMethodImplementation();
            }
        }
        throw new AssertionError((Object)methodImplementationStrategy);
    }

    protected TypeMirror returnType() {
        if (this.request.isRequestKind(RequestKind.INSTANCE) && this.binding.contributedPrimitiveType().isPresent()) {
            return this.binding.contributedPrimitiveType().get();
        }
        if (this.matchingComponentMethod().isPresent()) {
            return this.matchingComponentMethod().get().resolvedReturnType(this.types);
        }
        TypeMirror requestedType = this.request.requestedType(this.binding.contributedType(), this.types);
        return this.types.accessibleType(requestedType, this.componentImplementation.name());
    }

    private Optional<ComponentDescriptor.ComponentMethodDescriptor> matchingComponentMethod() {
        return this.componentImplementation.componentDescriptor().firstMatchingComponentMethod(this.request);
    }

    private final class DoubleCheckedMethodImplementation
    extends BindingMethodImplementation {
        private final Supplier<String> fieldName;

        private DoubleCheckedMethodImplementation() {
            this.fieldName = Suppliers.memoize(this::createField);
        }

        @Override
        CodeBlock implementation(Supplier<CodeBlock> simpleBindingExpression) {
            String fieldExpression = ((String)this.fieldName.get()).equals("local") ? "this.local" : (String)this.fieldName.get();
            return CodeBlock.builder().addStatement("$T local = $L", new Object[]{TypeName.OBJECT, fieldExpression}).beginControlFlow("if (local instanceof $T)", new Object[]{MemoizedSentinel.class}).beginControlFlow("synchronized (local)", new Object[0]).addStatement("local = $L", new Object[]{fieldExpression}).beginControlFlow("if (local instanceof $T)", new Object[]{MemoizedSentinel.class}).addStatement("local = $L", new Object[]{simpleBindingExpression.get()}).addStatement("$1L = $2T.reentrantCheck($1L, local)", new Object[]{fieldExpression, DoubleCheck.class}).endControlFlow().endControlFlow().endControlFlow().addStatement("return ($T) local", new Object[]{MethodBindingExpression.this.returnType()}).build();
        }

        private String createField() {
            String name = MethodBindingExpression.this.componentImplementation.getUniqueFieldName(KeyVariableNamer.name(MethodBindingExpression.this.binding.key()));
            MethodBindingExpression.this.componentImplementation.addField(ComponentImplementation.FieldSpecKind.PRIVATE_METHOD_SCOPED_FIELD, FieldSpec.builder((TypeName)TypeName.OBJECT, (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.VOLATILE}).initializer("new $T()", new Object[]{MemoizedSentinel.class}).build());
            return name;
        }
    }

    private final class SingleCheckedMethodImplementation
    extends BindingMethodImplementation {
        private final Supplier<FieldSpec> field;

        private SingleCheckedMethodImplementation() {
            this.field = Suppliers.memoize(this::createField);
        }

        @Override
        CodeBlock implementation(Supplier<CodeBlock> simpleBindingExpression) {
            String fieldExpression = ((FieldSpec)this.field.get()).name.equals("local") ? "this.local" : ((FieldSpec)this.field.get()).name;
            CodeBlock.Builder builder = CodeBlock.builder().addStatement("Object local = $N", new Object[]{fieldExpression});
            if (this.isNullable()) {
                builder.beginControlFlow("if (local instanceof $T)", new Object[]{MemoizedSentinel.class});
            } else {
                builder.beginControlFlow("if (local == null)", new Object[0]);
            }
            return builder.addStatement("local = $L", new Object[]{simpleBindingExpression.get()}).addStatement("$N = ($T) local", new Object[]{fieldExpression, MethodBindingExpression.this.returnType()}).endControlFlow().addStatement("return ($T) local", new Object[]{MethodBindingExpression.this.returnType()}).build();
        }

        FieldSpec createField() {
            String name = MethodBindingExpression.this.componentImplementation.getUniqueFieldName(MethodBindingExpression.this.request.isRequestKind(RequestKind.INSTANCE) ? KeyVariableNamer.name(MethodBindingExpression.this.binding.key()) : FrameworkField.forBinding(MethodBindingExpression.this.binding, Optional.empty()).name());
            FieldSpec.Builder builder = FieldSpec.builder((TypeName)this.fieldType(), (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.VOLATILE});
            if (this.isNullable()) {
                builder.initializer("new $T()", new Object[]{MemoizedSentinel.class});
            }
            FieldSpec field = builder.build();
            MethodBindingExpression.this.componentImplementation.addField(ComponentImplementation.FieldSpecKind.PRIVATE_METHOD_SCOPED_FIELD, field);
            return field;
        }

        TypeName fieldType() {
            if (this.isNullable()) {
                return TypeName.OBJECT;
            }
            TypeName returnType = TypeName.get((TypeMirror)MethodBindingExpression.this.returnType());
            return returnType.isPrimitive() ? returnType.box() : returnType;
        }

        private boolean isNullable() {
            return MethodBindingExpression.this.request.isRequestKind(RequestKind.INSTANCE) && MethodBindingExpression.this.binding.isNullable();
        }
    }

    private static final class SimpleMethodImplementation
    extends BindingMethodImplementation {
        private SimpleMethodImplementation() {
        }

        @Override
        CodeBlock implementation(Supplier<CodeBlock> simpleBindingExpression) {
            return CodeBlock.of((String)"return $L;", (Object[])new Object[]{simpleBindingExpression.get()});
        }
    }

    private static abstract class BindingMethodImplementation {
        private BindingMethodImplementation() {
        }

        abstract CodeBlock implementation(Supplier<CodeBlock> var1);
    }

    static enum MethodImplementationStrategy {
        SIMPLE,
        SINGLE_CHECK,
        DOUBLE_CHECK;

    }
}

