/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.internal.codegen.base.SourceFileGenerationException;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.BindingFactory;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

final class AssistedFactoryProcessingStep
extends TypeCheckingProcessingStep<TypeElement> {
    private final Messager messager;
    private final Filer filer;
    private final SourceVersion sourceVersion;
    private final DaggerElements elements;
    private final DaggerTypes types;
    private final BindingFactory bindingFactory;

    @Inject
    AssistedFactoryProcessingStep(Messager messager, Filer filer, SourceVersion sourceVersion, DaggerElements elements, DaggerTypes types, BindingFactory bindingFactory) {
        super(MoreElements::asType);
        this.messager = messager;
        this.filer = filer;
        this.sourceVersion = sourceVersion;
        this.elements = elements;
        this.types = types;
        this.bindingFactory = bindingFactory;
    }

    public ImmutableSet<Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(AssistedFactory.class);
    }

    @Override
    protected void process(TypeElement factory, ImmutableSet<Class<? extends Annotation>> annotations) {
        ValidationReport<TypeElement> report = new AssistedFactoryValidator().validate(factory);
        report.printMessagesTo(this.messager);
        if (report.isClean()) {
            try {
                ProvisionBinding binding = this.bindingFactory.assistedFactoryBinding(factory, Optional.empty());
                new AssistedFactoryImplGenerator().generate(binding);
            }
            catch (SourceFileGenerationException e) {
                e.printMessageTo(this.messager);
            }
        }
    }

    private final class AssistedFactoryImplGenerator
    extends SourceFileGenerator<ProvisionBinding> {
        AssistedFactoryImplGenerator() {
            super(AssistedFactoryProcessingStep.this.filer, AssistedFactoryProcessingStep.this.elements, AssistedFactoryProcessingStep.this.sourceVersion);
        }

        @Override
        public ClassName nameGeneratedType(ProvisionBinding binding) {
            return SourceFiles.generatedClassNameForBinding(binding);
        }

        @Override
        public Element originatingElement(ProvisionBinding binding) {
            return binding.bindingElement().get();
        }

        @Override
        public Optional<TypeSpec.Builder> write(ProvisionBinding binding) {
            TypeElement factory = MoreElements.asType(binding.bindingElement().get());
            ExecutableElement factoryMethod = AssistedInjectionAnnotations.assistedFactoryMethod(factory, AssistedFactoryProcessingStep.this.elements, AssistedFactoryProcessingStep.this.types);
            ExecutableType factoryMethodType = MoreTypes.asExecutable(AssistedFactoryProcessingStep.this.types.asMemberOf(MoreTypes.asDeclared(binding.key().type()), factoryMethod));
            TypeElement returnElement = MoreTypes.asTypeElement(factoryMethodType.getReturnType());
            ParameterSpec delegateFactoryParam = ParameterSpec.builder((TypeName)this.delegateFactoryTypeName(returnElement), (String)"delegateFactory", (Modifier[])new Modifier[0]).build();
            TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.nameGeneratedType(binding)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addTypeVariables((Iterable)factory.getTypeParameters().stream().map(TypeVariableName::get).collect(DaggerStreams.toImmutableList()));
            if (factory.getKind() == ElementKind.INTERFACE) {
                builder.addSuperinterface(factory.asType());
            } else {
                builder.superclass(factory.asType());
            }
            builder.addField(FieldSpec.builder((TypeName)delegateFactoryParam.type, (String)delegateFactoryParam.name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build()).addMethod(MethodSpec.constructorBuilder().addParameter(delegateFactoryParam).addStatement("this.$1N = $1N", new Object[]{delegateFactoryParam}).build()).addMethod(MethodSpec.overriding((ExecutableElement)factoryMethod, (DeclaredType)MoreTypes.asDeclared(factory.asType()), (Types)AssistedFactoryProcessingStep.this.types).addStatement("return $N.get($L)", new Object[]{delegateFactoryParam, factoryMethod.getParameters().stream().map(param -> CodeBlock.of((String)"$L", (Object[])new Object[]{param.getSimpleName()})).collect(CodeBlocks.toParametersCodeBlock())}).build()).addMethod(MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(delegateFactoryParam).addTypeVariables((Iterable)returnElement.getTypeParameters().stream().map(TypeVariableName::get).collect(DaggerStreams.toImmutableList())).returns((TypeName)TypeNames.providerOf(TypeName.get((TypeMirror)factory.asType()))).addStatement("return $T.create(new $T($N))", new Object[]{TypeNames.INSTANCE_FACTORY, this.nameGeneratedType(binding), delegateFactoryParam}).build());
            return Optional.of(builder);
        }

        private TypeName delegateFactoryTypeName(TypeElement returnElement) {
            ProvisionBinding delegateBinding = AssistedFactoryProcessingStep.this.bindingFactory.injectionBinding((ExecutableElement)Iterables.getOnlyElement(AssistedInjectionAnnotations.assistedInjectedConstructors(returnElement)), Optional.empty());
            ImmutableList typeParameters = (ImmutableList)returnElement.getTypeParameters().stream().map(TypeVariableName::get).collect(DaggerStreams.toImmutableList());
            return typeParameters.isEmpty() ? SourceFiles.generatedClassNameForBinding(delegateBinding) : ParameterizedTypeName.get((ClassName)SourceFiles.generatedClassNameForBinding(delegateBinding), (TypeName[])((TypeName[])typeParameters.toArray((Object[])new TypeName[0])));
        }
    }

    private final class AssistedFactoryValidator {
        private AssistedFactoryValidator() {
        }

        ValidationReport<TypeElement> validate(TypeElement factory) {
            ImmutableSet<ExecutableElement> abstractFactoryMethods;
            ValidationReport.Builder<TypeElement> report = ValidationReport.about(factory);
            if (!factory.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                return report.addError("The @AssistedFactory-annotated type must be either an abstract class or interface.", factory).build();
            }
            if (factory.getNestingKind().isNested() && !factory.getModifiers().contains((Object)Modifier.STATIC)) {
                report.addError("Nested @AssistedFactory-annotated types must be static. ", factory);
            }
            if ((abstractFactoryMethods = AssistedInjectionAnnotations.assistedFactoryMethods(factory, AssistedFactoryProcessingStep.this.elements, AssistedFactoryProcessingStep.this.types)).isEmpty()) {
                report.addError("The @AssistedFactory-annotated type is missing an abstract, non-default method whose return type matches the assisted injection type.", factory);
            }
            for (ExecutableElement method : abstractFactoryMethods) {
                ExecutableType methodType = AssistedFactoryProcessingStep.this.types.resolveExecutableType(method, factory.asType());
                if (this.isAssistedInjectionType(methodType.getReturnType())) continue;
                report.addError(String.format("Invalid return type: %s. An assisted factory's abstract method must return a type with an @AssistedInject-annotated constructor.", methodType.getReturnType()), method);
            }
            if (abstractFactoryMethods.size() > 1) {
                report.addError("The @AssistedFactory-annotated type should contain a single abstract, non-default method but found multiple: " + abstractFactoryMethods, factory);
            }
            if (!report.build().isClean()) {
                return report.build();
            }
            ExecutableElement factoryMethod = (ExecutableElement)Iterables.getOnlyElement(abstractFactoryMethods);
            ExecutableType factoryMethodType = AssistedFactoryProcessingStep.this.types.resolveExecutableType(factoryMethod, factory.asType());
            DeclaredType returnType = MoreTypes.asDeclared(factoryMethodType.getReturnType());
            ImmutableList assistedParameterTypes = (ImmutableList)this.assistedInjectConstructorParameterMap(returnType).entrySet().stream().filter(e -> MoreElements.isAnnotationPresent((Element)e.getKey(), Assisted.class)).map(Map.Entry::getValue).collect(DaggerStreams.toImmutableList());
            ImmutableList factoryMethodParameterTypes = ImmutableList.copyOf(factoryMethodType.getParameterTypes());
            if (!this.typesAssignableTo((ImmutableList<TypeMirror>)factoryMethodParameterTypes, (ImmutableList<TypeMirror>)assistedParameterTypes)) {
                report.addError(String.format("The parameters of the factory method must be assignable to the list of @Assisted parameters in %s.\n      Actual: %s#%s\n    Expected: %s#%s(%s)", returnType, factory.getQualifiedName(), factoryMethod, factory.getQualifiedName(), factoryMethod.getSimpleName(), assistedParameterTypes.stream().map(Object::toString).collect(Collectors.joining(", "))), factoryMethod);
            }
            return report.build();
        }

        private boolean isAssistedInjectionType(TypeMirror type) {
            return type.getKind() == TypeKind.DECLARED && AssistedInjectionAnnotations.isAssistedInjectionType(MoreTypes.asTypeElement(type));
        }

        private boolean typesAssignableTo(ImmutableList<TypeMirror> types1, ImmutableList<TypeMirror> types2) {
            if (types1.size() != types2.size()) {
                return false;
            }
            for (int i = 0; i < types1.size(); ++i) {
                if (AssistedFactoryProcessingStep.this.types.isAssignable((TypeMirror)types1.get(i), (TypeMirror)types2.get(i))) continue;
                return false;
            }
            return true;
        }

        private ImmutableMap<VariableElement, TypeMirror> assistedInjectConstructorParameterMap(DeclaredType assistedType) {
            ExecutableElement assistedConstructor = (ExecutableElement)Iterables.getOnlyElement(AssistedInjectionAnnotations.assistedInjectedConstructors(MoreTypes.asTypeElement(assistedType)));
            ExecutableType assistedConstructorType = MoreTypes.asExecutable(AssistedFactoryProcessingStep.this.types.asMemberOf(assistedType, assistedConstructor));
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < assistedConstructor.getParameters().size(); ++i) {
                builder.put((Object)assistedConstructor.getParameters().get(i), (Object)assistedConstructorType.getParameterTypes().get(i));
            }
            return builder.build();
        }
    }
}

