/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;

final class AssistedProcessingStep
extends TypeCheckingProcessingStep<VariableElement> {
    private final InjectionAnnotations injectionAnnotations;
    private final Messager messager;

    @Inject
    AssistedProcessingStep(InjectionAnnotations injectionAnnotations, Messager messager) {
        super(MoreElements::asVariable);
        this.injectionAnnotations = injectionAnnotations;
        this.messager = messager;
    }

    public ImmutableSet<Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(Assisted.class);
    }

    @Override
    protected void process(VariableElement assisted, ImmutableSet<Class<? extends Annotation>> annotations) {
        new AssistedValidator().validate(assisted).printMessagesTo(this.messager);
    }

    private final class AssistedValidator {
        private AssistedValidator() {
        }

        ValidationReport<VariableElement> validate(VariableElement assisted) {
            ValidationReport.Builder<VariableElement> report = ValidationReport.about(assisted);
            Element assistedConstructor = assisted.getEnclosingElement();
            if (!MoreElements.isAnnotationPresent(assistedConstructor, AssistedInject.class) || assistedConstructor.getKind() != ElementKind.CONSTRUCTOR) {
                report.addError("@Assisted parameters can only be used within an @AssistedInject-annotated constructor.", assisted);
            }
            AssistedProcessingStep.this.injectionAnnotations.getQualifiers(assisted).forEach(qualifier -> report.addError("Qualifiers cannot be used with @Assisted parameters.", assisted, (AnnotationMirror)qualifier));
            return report.build();
        }
    }
}

