/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CheckReturnValue;
import dagger.BindsInstance;
import dagger.Component;
import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.AssistedFactoryProcessingStep;
import dagger.internal.codegen.AssistedProcessingStep;
import dagger.internal.codegen.ComponentHjarProcessingStep;
import dagger.internal.codegen.ComponentProcessingStep;
import dagger.internal.codegen.DaggerComponentProcessor_ProcessorComponent;
import dagger.internal.codegen.InjectProcessingStep;
import dagger.internal.codegen.MapKeyProcessingStep;
import dagger.internal.codegen.ModuleProcessingStep;
import dagger.internal.codegen.ProcessingEnvironmentModule;
import dagger.internal.codegen.ProcessingRoundCacheModule;
import dagger.internal.codegen.SourceFileGeneratorsModule;
import dagger.internal.codegen.SpiModule;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.SourceFileGenerationException;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.InjectBindingRegistry;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.bindinggraphvalidation.BindingGraphValidationModule;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.compileroption.ProcessingEnvironmentCompilerOptions;
import dagger.internal.codegen.componentgenerator.ComponentGeneratorModule;
import dagger.internal.codegen.validation.BindingGraphPlugins;
import dagger.internal.codegen.validation.BindingMethodProcessingStep;
import dagger.internal.codegen.validation.BindingMethodValidatorsModule;
import dagger.internal.codegen.validation.BindsInstanceProcessingStep;
import dagger.internal.codegen.validation.InjectBindingRegistryModule;
import dagger.internal.codegen.validation.MonitoringModuleProcessingStep;
import dagger.internal.codegen.validation.MultibindingAnnotationsProcessingStep;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.spi.BindingGraphPlugin;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.SourceVersion;

public class ComponentProcessor
extends BasicAnnotationProcessor {
    private final Optional<ImmutableSet<BindingGraphPlugin>> testingPlugins;
    @Inject
    InjectBindingRegistry injectBindingRegistry;
    @Inject
    SourceFileGenerator<ProvisionBinding> factoryGenerator;
    @Inject
    SourceFileGenerator<MembersInjectionBinding> membersInjectorGenerator;
    @Inject
    ImmutableList<BasicAnnotationProcessor.ProcessingStep> processingSteps;
    @Inject
    BindingGraphPlugins bindingGraphPlugins;
    @Inject
    Set<ClearableCache> clearableCaches;

    public ComponentProcessor() {
        this.testingPlugins = Optional.empty();
    }

    private ComponentProcessor(Iterable<BindingGraphPlugin> testingPlugins) {
        this.testingPlugins = Optional.of(ImmutableSet.copyOf(testingPlugins));
    }

    @VisibleForTesting
    public static ComponentProcessor forTesting(BindingGraphPlugin ... testingPlugins) {
        return ComponentProcessor.forTesting(Arrays.asList(testingPlugins));
    }

    @VisibleForTesting
    public static ComponentProcessor forTesting(Iterable<BindingGraphPlugin> testingPlugins) {
        return new ComponentProcessor(testingPlugins);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Sets.union(ProcessingEnvironmentCompilerOptions.supportedOptions(), this.bindingGraphPlugins.allSupportedOptions()).immutableCopy();
    }

    @Override
    protected Iterable<? extends BasicAnnotationProcessor.ProcessingStep> initSteps() {
        ProcessorComponent.factory().create(this.processingEnv, this.testingPlugins).inject(this);
        this.bindingGraphPlugins.initializePlugins();
        return this.processingSteps;
    }

    @Override
    protected void postRound(RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            try {
                this.injectBindingRegistry.generateSourcesForRequiredBindings(this.factoryGenerator, this.membersInjectorGenerator);
            }
            catch (SourceFileGenerationException e) {
                e.printMessageTo(this.processingEnv.getMessager());
            }
        }
        this.clearableCaches.forEach(ClearableCache::clearCache);
    }

    @Module
    static interface ProcessingStepsModule {
        @Provides
        public static ImmutableList<BasicAnnotationProcessor.ProcessingStep> processingSteps(MapKeyProcessingStep mapKeyProcessingStep, InjectProcessingStep injectProcessingStep, AssistedProcessingStep assistedProcessingStep, AssistedFactoryProcessingStep assistedFactoryProcessingStep, MonitoringModuleProcessingStep monitoringModuleProcessingStep, MultibindingAnnotationsProcessingStep multibindingAnnotationsProcessingStep, BindsInstanceProcessingStep bindsInstanceProcessingStep, ModuleProcessingStep moduleProcessingStep, ComponentProcessingStep componentProcessingStep, ComponentHjarProcessingStep componentHjarProcessingStep, BindingMethodProcessingStep bindingMethodProcessingStep, CompilerOptions compilerOptions) {
            return ImmutableList.of((Object)mapKeyProcessingStep, (Object)injectProcessingStep, (Object)assistedProcessingStep, (Object)assistedFactoryProcessingStep, (Object)monitoringModuleProcessingStep, (Object)multibindingAnnotationsProcessingStep, (Object)bindsInstanceProcessingStep, (Object)moduleProcessingStep, (Object)(compilerOptions.headerCompilation() ? componentHjarProcessingStep : componentProcessingStep), (Object)bindingMethodProcessingStep);
        }
    }

    @Singleton
    @Component(modules={BindingGraphValidationModule.class, BindingMethodValidatorsModule.class, ComponentGeneratorModule.class, InjectBindingRegistryModule.class, ProcessingEnvironmentModule.class, ProcessingRoundCacheModule.class, ProcessingStepsModule.class, SourceFileGeneratorsModule.class, SpiModule.class})
    static interface ProcessorComponent {
        public void inject(ComponentProcessor var1);

        public static Factory factory() {
            return DaggerComponentProcessor_ProcessorComponent.factory();
        }

        @Component.Factory
        public static interface Factory {
            @CheckReturnValue
            public ProcessorComponent create(@BindsInstance ProcessingEnvironment var1, @BindsInstance @SpiModule.TestingPlugins Optional<ImmutableSet<BindingGraphPlugin>> var2);
        }
    }
}

