/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.model.BindingKind;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public final class AssistedInjectionAnnotations {
    public static ExecutableElement assistedFactoryMethod(TypeElement factory, DaggerElements elements, DaggerTypes types) {
        return (ExecutableElement)Iterables.getOnlyElement(AssistedInjectionAnnotations.assistedFactoryMethods(factory, elements, types));
    }

    public static ImmutableSet<ExecutableElement> assistedFactoryMethods(TypeElement factory, DaggerElements elements, DaggerTypes types) {
        return (ImmutableSet)MoreElements.getLocalAndInheritedMethods(factory, types, elements).stream().filter(method -> method.getModifiers().contains((Object)Modifier.ABSTRACT)).filter(method -> !method.isDefault()).collect(DaggerStreams.toImmutableSet());
    }

    public static boolean isAssistedInjectionType(TypeElement typeElement) {
        ImmutableSet<ExecutableElement> injectConstructors = AssistedInjectionAnnotations.assistedInjectedConstructors(typeElement);
        return !injectConstructors.isEmpty() && MoreElements.isAnnotationPresent((Element)Iterables.getOnlyElement(injectConstructors), AssistedInject.class);
    }

    public static boolean isAssistedFactoryType(Element element) {
        return MoreElements.isAnnotationPresent(element, AssistedFactory.class);
    }

    public static ImmutableList<ParameterSpec> assistedParameterSpecs(Binding binding, DaggerTypes types) {
        Preconditions.checkArgument((binding.kind() == BindingKind.ASSISTED_INJECTION ? 1 : 0) != 0);
        ExecutableElement constructor = MoreElements.asExecutable(binding.bindingElement().get());
        ExecutableType constructorType = MoreTypes.asExecutable(types.asMemberOf(MoreTypes.asDeclared(binding.key().type()), constructor));
        return AssistedInjectionAnnotations.assistedParameterSpecs(constructor.getParameters(), constructorType.getParameterTypes());
    }

    private static ImmutableList<ParameterSpec> assistedParameterSpecs(List<? extends VariableElement> paramElements, List<? extends TypeMirror> paramTypes) {
        ImmutableList.Builder assistedParameterSpecs = ImmutableList.builder();
        for (int i = 0; i < paramElements.size(); ++i) {
            VariableElement paramElement = paramElements.get(i);
            TypeMirror paramType = paramTypes.get(i);
            if (!AssistedInjectionAnnotations.isAssistedParameter(paramElement)) continue;
            assistedParameterSpecs.add((Object)ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)paramType), (String)paramElement.getSimpleName().toString(), (Modifier[])new Modifier[0]).build());
        }
        return assistedParameterSpecs.build();
    }

    public static ImmutableList<ParameterSpec> assistedFactoryParameterSpecs(Binding binding, DaggerElements elements, DaggerTypes types) {
        Preconditions.checkArgument((binding.kind() == BindingKind.ASSISTED_FACTORY ? 1 : 0) != 0);
        TypeElement factory = MoreElements.asType(binding.bindingElement().get());
        ExecutableElement factoryMethod = AssistedInjectionAnnotations.assistedFactoryMethod(factory, elements, types);
        ExecutableType factoryMethodType = MoreTypes.asExecutable(types.asMemberOf(MoreTypes.asDeclared(binding.key().type()), factoryMethod));
        TypeMirror returnType = factoryMethodType.getReturnType();
        TypeElement returnElement = MoreTypes.asTypeElement(returnType);
        ExecutableElement constructor = (ExecutableElement)Iterables.getOnlyElement(AssistedInjectionAnnotations.assistedInjectedConstructors(returnElement));
        return AssistedInjectionAnnotations.assistedParameterSpecs(AssistedInjectionAnnotations.assistedParameters(constructor), factoryMethodType.getParameterTypes());
    }

    public static ImmutableSet<ExecutableElement> assistedInjectedConstructors(TypeElement type) {
        return (ImmutableSet)ElementFilter.constructorsIn(type.getEnclosedElements()).stream().filter(constructor -> MoreElements.isAnnotationPresent(constructor, AssistedInject.class)).collect(DaggerStreams.toImmutableSet());
    }

    public static ImmutableList<VariableElement> assistedParameters(Binding binding) {
        return binding.kind() == BindingKind.ASSISTED_INJECTION ? AssistedInjectionAnnotations.assistedParameters(MoreElements.asExecutable(binding.bindingElement().get())) : ImmutableList.of();
    }

    private static ImmutableList<VariableElement> assistedParameters(ExecutableElement constructor) {
        return (ImmutableList)constructor.getParameters().stream().filter(AssistedInjectionAnnotations::isAssistedParameter).collect(DaggerStreams.toImmutableList());
    }

    public static boolean isAssistedParameter(VariableElement param) {
        return MoreElements.isAnnotationPresent(MoreElements.asVariable(param), Assisted.class);
    }

    private AssistedInjectionAnnotations() {
    }
}

