/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.componentgenerator;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.BindsInstance;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentCreatorKind;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.componentgenerator.MethodSignature;
import dagger.internal.codegen.javapoet.TypeSpecs;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.ComponentNames;
import dagger.producers.internal.CancellationListener;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.HashSet;
import java.util.stream.Stream;
import javax.annotation.processing.Filer;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Types;

final class ComponentHjarGenerator
extends SourceFileGenerator<ComponentDescriptor> {
    private final DaggerElements elements;
    private final DaggerTypes types;
    private final KotlinMetadataUtil metadataUtil;

    @Inject
    ComponentHjarGenerator(Filer filer, DaggerElements elements, DaggerTypes types, SourceVersion sourceVersion, KotlinMetadataUtil metadataUtil) {
        super(filer, elements, sourceVersion);
        this.elements = elements;
        this.types = types;
        this.metadataUtil = metadataUtil;
    }

    @Override
    public Element originatingElement(ComponentDescriptor input) {
        return input.typeElement();
    }

    @Override
    public ImmutableList<TypeSpec.Builder> topLevelTypes(ComponentDescriptor componentDescriptor) {
        boolean noArgFactoryMethod;
        ComponentCreatorKind creatorKind;
        ClassName builderMethodReturnType;
        ClassName generatedTypeName = ComponentNames.getRootComponentClassName(componentDescriptor);
        TypeSpec.Builder generatedComponent = TypeSpec.classBuilder((ClassName)generatedTypeName).addModifiers(new Modifier[]{Modifier.FINAL}).addMethod(ComponentHjarGenerator.privateConstructor());
        if (componentDescriptor.typeElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
            generatedComponent.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        TypeElement componentElement = componentDescriptor.typeElement();
        TypeSpecs.addSupertype(generatedComponent, componentElement);
        if (componentDescriptor.creatorDescriptor().isPresent()) {
            ComponentCreatorDescriptor creatorDescriptor = componentDescriptor.creatorDescriptor().get();
            builderMethodReturnType = ClassName.get((TypeElement)creatorDescriptor.typeElement());
            creatorKind = creatorDescriptor.kind();
            noArgFactoryMethod = creatorDescriptor.factoryParameters().isEmpty();
        } else {
            ClassName builderClassName;
            TypeSpec.Builder builder = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL}).addMethod(ComponentHjarGenerator.privateConstructor());
            if (componentDescriptor.typeElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
                builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
            }
            builderMethodReturnType = builderClassName = generatedTypeName.nestedClass("Builder");
            creatorKind = ComponentCreatorKind.BUILDER;
            noArgFactoryMethod = true;
            ComponentHjarGenerator.componentRequirements(componentDescriptor).map(requirement -> ComponentHjarGenerator.builderSetterMethod(requirement.typeElement(), builderClassName)).forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
            builder.addMethod(ComponentHjarGenerator.builderBuildMethod(componentDescriptor));
            generatedComponent.addType(builder.build());
        }
        generatedComponent.addMethod(ComponentHjarGenerator.staticCreatorMethod((TypeName)builderMethodReturnType, creatorKind));
        if (noArgFactoryMethod && !this.hasBindsInstanceMethods(componentDescriptor) && ComponentHjarGenerator.componentRequirements(componentDescriptor).noneMatch(requirement -> requirement.requiresAPassedInstance(this.elements, this.metadataUtil))) {
            generatedComponent.addMethod(ComponentHjarGenerator.createMethod(componentDescriptor));
        }
        DeclaredType componentType = MoreTypes.asDeclared(componentElement.asType());
        HashSet methodSignatures = Sets.newHashSetWithExpectedSize((int)componentDescriptor.componentMethods().size());
        componentDescriptor.componentMethods().stream().filter(method -> methodSignatures.add(MethodSignature.forComponentMethod(method, componentType, this.types))).forEach(method -> generatedComponent.addMethod(this.emptyComponentMethod(componentElement, method.methodElement())));
        if (componentDescriptor.isProduction()) {
            generatedComponent.addSuperinterface((TypeName)ClassName.get(CancellationListener.class)).addMethod(ComponentHjarGenerator.onProducerFutureCancelledMethod());
        }
        return ImmutableList.of((Object)generatedComponent);
    }

    private MethodSpec emptyComponentMethod(TypeElement typeElement, ExecutableElement baseMethod) {
        return MethodSpec.overriding((ExecutableElement)baseMethod, (DeclaredType)MoreTypes.asDeclared(typeElement.asType()), (Types)this.types).build();
    }

    private static MethodSpec privateConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }

    private static Stream<ComponentRequirement> componentRequirements(ComponentDescriptor component) {
        Preconditions.checkArgument((!component.isSubcomponent() ? 1 : 0) != 0);
        return Stream.concat(component.dependencies().stream(), component.modules().stream().filter(module -> !module.moduleElement().getModifiers().contains((Object)Modifier.ABSTRACT) && Accessibility.isElementAccessibleFrom((Element)module.moduleElement(), ClassName.get((TypeElement)component.typeElement()).packageName())).map(module -> ComponentRequirement.forModule(module.moduleElement().asType())));
    }

    private boolean hasBindsInstanceMethods(ComponentDescriptor componentDescriptor) {
        return componentDescriptor.creatorDescriptor().isPresent() && this.elements.getUnimplementedMethods(componentDescriptor.creatorDescriptor().get().typeElement()).stream().anyMatch(method -> ComponentHjarGenerator.isBindsInstance(method));
    }

    private static boolean isBindsInstance(ExecutableElement method) {
        if (MoreElements.isAnnotationPresent(method, BindsInstance.class)) {
            return true;
        }
        if (method.getParameters().size() == 1) {
            return MoreElements.isAnnotationPresent(method.getParameters().get(0), BindsInstance.class);
        }
        return false;
    }

    private static MethodSpec builderSetterMethod(TypeElement componentRequirement, ClassName builderClass) {
        String simpleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, componentRequirement.getSimpleName().toString());
        return MethodSpec.methodBuilder((String)simpleName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get((TypeElement)componentRequirement), simpleName, new Modifier[0]).returns((TypeName)builderClass).build();
    }

    private static MethodSpec builderBuildMethod(ComponentDescriptor component) {
        return MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((TypeElement)component.typeElement())).build();
    }

    private static MethodSpec staticCreatorMethod(TypeName creatorMethodReturnType, ComponentCreatorKind creatorKind) {
        return MethodSpec.methodBuilder((String)Ascii.toLowerCase((String)creatorKind.typeName())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(creatorMethodReturnType).build();
    }

    private static MethodSpec createMethod(ComponentDescriptor componentDescriptor) {
        return MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ClassName.get((TypeElement)componentDescriptor.typeElement())).build();
    }

    private static MethodSpec onProducerFutureCancelledMethod() {
        return MethodSpec.methodBuilder((String)"onProducerFutureCancelled").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeName.BOOLEAN, "mayInterruptIfRunning", new Modifier[0]).build();
    }
}

