/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.componentgenerator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.Preconditions;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentCreatorKind;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.componentgenerator.ComponentCreatorImplementationFactory;
import dagger.internal.codegen.componentgenerator.MethodSignature;
import dagger.internal.codegen.componentgenerator.TopLevelImplementationComponent;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.ComponentBindingExpressions;
import dagger.internal.codegen.writing.ComponentCreatorImplementation;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequirementExpressions;
import dagger.internal.codegen.writing.ParentComponent;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Types;

public final class ComponentImplementationBuilder {
    private final Optional<ComponentImplementation> parent;
    private final BindingGraph graph;
    private final ComponentBindingExpressions bindingExpressions;
    private final ComponentRequirementExpressions componentRequirementExpressions;
    private final ComponentImplementation componentImplementation;
    private final ComponentCreatorImplementationFactory componentCreatorImplementationFactory;
    private final TopLevelImplementationComponent topLevelImplementationComponent;
    private final DaggerTypes types;
    private final DaggerElements elements;
    private final KotlinMetadataUtil metadataUtil;
    private boolean done;

    @Inject
    ComponentImplementationBuilder(@ParentComponent Optional<ComponentImplementation> parent, BindingGraph graph, ComponentBindingExpressions bindingExpressions, ComponentRequirementExpressions componentRequirementExpressions, ComponentImplementation componentImplementation, ComponentCreatorImplementationFactory componentCreatorImplementationFactory, TopLevelImplementationComponent topLevelImplementationComponent, DaggerTypes types, DaggerElements elements, KotlinMetadataUtil metadataUtil) {
        this.parent = parent;
        this.graph = graph;
        this.bindingExpressions = bindingExpressions;
        this.componentRequirementExpressions = componentRequirementExpressions;
        this.componentImplementation = componentImplementation;
        this.componentCreatorImplementationFactory = componentCreatorImplementationFactory;
        this.types = types;
        this.elements = elements;
        this.topLevelImplementationComponent = topLevelImplementationComponent;
        this.metadataUtil = metadataUtil;
    }

    ComponentImplementation build() {
        com.google.common.base.Preconditions.checkState((!this.done ? 1 : 0) != 0, (String)"ComponentImplementationBuilder has already built the ComponentImplementation for [%s].", (Object)this.componentImplementation.name());
        this.componentCreatorImplementationFactory.create().map(ComponentCreatorImplementation::spec).ifPresent(this::addCreatorClass);
        this.elements.getLocalAndInheritedMethods(this.graph.componentTypeElement()).forEach(method -> this.componentImplementation.claimMethodName(method.getSimpleName()));
        this.addFactoryMethods();
        this.addInterfaceMethods();
        this.addChildComponents();
        this.done = true;
        return this.componentImplementation;
    }

    private void addCreatorClass(TypeSpec creator) {
        if (this.parent.isPresent()) {
            this.parent.get().addType(ComponentImplementation.TypeSpecKind.SUBCOMPONENT, creator);
        } else {
            this.componentImplementation.addType(ComponentImplementation.TypeSpecKind.COMPONENT_CREATOR, creator);
        }
    }

    private void addFactoryMethods() {
        if (this.parent.isPresent()) {
            this.graph.factoryMethod().ifPresent(this::createSubcomponentFactoryMethod);
        } else {
            this.createRootComponentFactoryMethod();
        }
    }

    private void addInterfaceMethods() {
        ImmutableListMultimap componentMethodsBySignature = Multimaps.index(this.graph.componentDescriptor().entryPointMethods(), this::getMethodSignature);
        for (List methodsWithSameSignature : Multimaps.asMap((ListMultimap)componentMethodsBySignature).values()) {
            ComponentDescriptor.ComponentMethodDescriptor anyOneMethod = (ComponentDescriptor.ComponentMethodDescriptor)methodsWithSameSignature.stream().findAny().get();
            MethodSpec methodSpec = this.bindingExpressions.getComponentMethod(anyOneMethod);
            this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.COMPONENT_METHOD, methodSpec);
        }
    }

    private MethodSignature getMethodSignature(ComponentDescriptor.ComponentMethodDescriptor method) {
        return MethodSignature.forComponentMethod(method, MoreTypes.asDeclared(this.graph.componentTypeElement().asType()), this.types);
    }

    private void addChildComponents() {
        for (BindingGraph subgraph : this.graph.subgraphs()) {
            this.componentImplementation.addType(ComponentImplementation.TypeSpecKind.SUBCOMPONENT, this.childComponent(subgraph));
        }
    }

    private TypeSpec childComponent(BindingGraph childGraph) {
        return this.topLevelImplementationComponent.currentImplementationSubcomponentBuilder().bindingGraph(childGraph).parentImplementation(Optional.of(this.componentImplementation)).parentBindingExpressions(Optional.of(this.bindingExpressions)).parentRequirementExpressions(Optional.of(this.componentRequirementExpressions)).build().componentImplementationBuilder().build().generate();
    }

    private void createRootComponentFactoryMethod() {
        boolean noArgFactoryMethod;
        String factoryMethodName;
        ClassName creatorType;
        ComponentCreatorKind creatorKind;
        com.google.common.base.Preconditions.checkState((!this.parent.isPresent() ? 1 : 0) != 0);
        Optional<ComponentCreatorDescriptor> creatorDescriptor = this.graph.componentDescriptor().creatorDescriptor();
        if (creatorDescriptor.isPresent()) {
            ComponentCreatorDescriptor descriptor = creatorDescriptor.get();
            creatorKind = descriptor.kind();
            creatorType = ClassName.get((TypeElement)descriptor.typeElement());
            factoryMethodName = descriptor.factoryMethod().getSimpleName().toString();
            noArgFactoryMethod = descriptor.factoryParameters().isEmpty();
        } else {
            creatorKind = ComponentCreatorKind.BUILDER;
            creatorType = this.componentImplementation.getCreatorName();
            factoryMethodName = "build";
            noArgFactoryMethod = true;
        }
        MethodSpec creatorFactoryMethod = MethodSpec.methodBuilder((String)creatorKind.methodName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)creatorType).addStatement("return new $T()", new Object[]{this.componentImplementation.getCreatorName()}).build();
        this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.BUILDER_METHOD, creatorFactoryMethod);
        if (noArgFactoryMethod && this.canInstantiateAllRequirements()) {
            this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.BUILDER_METHOD, MethodSpec.methodBuilder((String)"create").returns((TypeName)ClassName.get((TypeElement)this.graph.componentTypeElement())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addStatement("return new $L().$L()", new Object[]{creatorKind.typeName(), factoryMethodName}).build());
        }
    }

    private boolean canInstantiateAllRequirements() {
        return !Iterables.any(this.graph.componentRequirements(), dependency -> dependency.requiresAPassedInstance(this.elements, this.metadataUtil));
    }

    private void createSubcomponentFactoryMethod(ExecutableElement factoryMethod) {
        com.google.common.base.Preconditions.checkState((boolean)this.parent.isPresent());
        Collection<ParameterSpec> params = ComponentImplementationBuilder.getFactoryMethodParameters(this.graph).values();
        MethodSpec.Builder method = MethodSpec.overriding((ExecutableElement)factoryMethod, (DeclaredType)this.parentType(), (Types)this.types);
        params.forEach(param -> method.addStatement("$T.checkNotNull($N)", new Object[]{Preconditions.class, param}));
        method.addStatement("return new $T($L)", new Object[]{this.componentImplementation.name(), CodeBlocks.parameterNames((Iterable<ParameterSpec>)ImmutableList.builder().addAll((Iterable)this.componentImplementation.creatorComponentFields().stream().map(field -> ParameterSpec.builder((TypeName)field.type, (String)field.name, (Modifier[])new Modifier[0]).build()).collect(DaggerStreams.toImmutableList())).addAll(params).build())});
        this.parent.get().addMethod(ComponentImplementation.MethodSpecKind.COMPONENT_METHOD, method.build());
    }

    private DeclaredType parentType() {
        return MoreTypes.asDeclared(this.parent.get().graph().componentTypeElement().asType());
    }

    private static Map<ComponentRequirement, ParameterSpec> getFactoryMethodParameters(BindingGraph graph) {
        return Maps.transformValues(graph.factoryMethodParameters(), ParameterSpec::get);
    }
}

