/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingNode;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.binding.FrameworkTypeMapper;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.BindingExpression;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentMethodBindingExpression;
import dagger.internal.codegen.writing.ComponentRequirementExpressions;
import dagger.internal.codegen.writing.DelegateBindingExpression;
import dagger.internal.codegen.writing.DerivedFromFrameworkInstanceBindingExpression;
import dagger.internal.codegen.writing.FrameworkFieldInitializer;
import dagger.internal.codegen.writing.FrameworkInstanceBindingExpression;
import dagger.internal.codegen.writing.FrameworkInstanceSupplier;
import dagger.internal.codegen.writing.ImmediateFutureBindingExpression;
import dagger.internal.codegen.writing.MemberSelect;
import dagger.internal.codegen.writing.MembersInjectionBindingExpression;
import dagger.internal.codegen.writing.MethodBindingExpression;
import dagger.internal.codegen.writing.ParentComponent;
import dagger.internal.codegen.writing.PerComponentImplementation;
import dagger.internal.codegen.writing.PrivateMethodBindingExpression;
import dagger.internal.codegen.writing.ProducerFromProviderCreationExpression;
import dagger.internal.codegen.writing.ProducerNodeInstanceBindingExpression;
import dagger.internal.codegen.writing.ProviderInstanceBindingExpression;
import dagger.internal.codegen.writing.SwitchingProviders;
import dagger.internal.codegen.writing.UnscopedDirectInstanceBindingExpressionFactory;
import dagger.internal.codegen.writing.UnscopedFrameworkInstanceCreationExpressionFactory;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.model.RequestKind;
import dagger.shaded.auto.common.MoreTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

@PerComponentImplementation
public final class ComponentBindingExpressions {
    private final Optional<ComponentBindingExpressions> parent;
    private final BindingGraph graph;
    private final ComponentImplementation componentImplementation;
    private final ComponentRequirementExpressions componentRequirementExpressions;
    private final ComponentMethodBindingExpression.Factory componentMethodBindingExpressionFactory;
    private final DelegateBindingExpression.Factory delegateBindingExpressionFactory;
    private final DerivedFromFrameworkInstanceBindingExpression.Factory derivedFromFrameworkInstanceBindingExpressionFactory;
    private final ImmediateFutureBindingExpression.Factory immediateFutureBindingExpressionFactory;
    private final MembersInjectionBindingExpression.Factory membersInjectionBindingExpressionFactory;
    private final PrivateMethodBindingExpression.Factory privateMethodBindingExpressionFactory;
    private final ProducerNodeInstanceBindingExpression.Factory producerNodeInstanceBindingExpressionFactory;
    private final ProviderInstanceBindingExpression.Factory providerInstanceBindingExpressionFactory;
    private final UnscopedDirectInstanceBindingExpressionFactory unscopedDirectInstanceBindingExpressionFactory;
    private final ProducerFromProviderCreationExpression.Factory producerFromProviderCreationExpressionFactory;
    private final UnscopedFrameworkInstanceCreationExpressionFactory unscopedFrameworkInstanceCreationExpressionFactory;
    private final DaggerTypes types;
    private final CompilerOptions compilerOptions;
    private final SwitchingProviders switchingProviders;
    private final Map<BindingRequest, BindingExpression> expressions = new HashMap<BindingRequest, BindingExpression>();

    @Inject
    ComponentBindingExpressions(@ParentComponent Optional<ComponentBindingExpressions> parent, BindingGraph graph, ComponentImplementation componentImplementation, ComponentRequirementExpressions componentRequirementExpressions, ComponentMethodBindingExpression.Factory componentMethodBindingExpressionFactory, DelegateBindingExpression.Factory delegateBindingExpressionFactory, DerivedFromFrameworkInstanceBindingExpression.Factory derivedFromFrameworkInstanceBindingExpressionFactory, ImmediateFutureBindingExpression.Factory immediateFutureBindingExpressionFactory, MembersInjectionBindingExpression.Factory membersInjectionBindingExpressionFactory, PrivateMethodBindingExpression.Factory privateMethodBindingExpressionFactory, ProducerNodeInstanceBindingExpression.Factory producerNodeInstanceBindingExpressionFactory, ProviderInstanceBindingExpression.Factory providerInstanceBindingExpressionFactory, UnscopedDirectInstanceBindingExpressionFactory unscopedDirectInstanceBindingExpressionFactory, ProducerFromProviderCreationExpression.Factory producerFromProviderCreationExpressionFactory, UnscopedFrameworkInstanceCreationExpressionFactory unscopedFrameworkInstanceCreationExpressionFactory, DaggerTypes types, CompilerOptions compilerOptions) {
        this.parent = parent;
        this.graph = graph;
        this.componentImplementation = componentImplementation;
        this.componentRequirementExpressions = (ComponentRequirementExpressions)Preconditions.checkNotNull((Object)componentRequirementExpressions);
        this.componentMethodBindingExpressionFactory = componentMethodBindingExpressionFactory;
        this.delegateBindingExpressionFactory = delegateBindingExpressionFactory;
        this.derivedFromFrameworkInstanceBindingExpressionFactory = derivedFromFrameworkInstanceBindingExpressionFactory;
        this.immediateFutureBindingExpressionFactory = immediateFutureBindingExpressionFactory;
        this.membersInjectionBindingExpressionFactory = membersInjectionBindingExpressionFactory;
        this.privateMethodBindingExpressionFactory = privateMethodBindingExpressionFactory;
        this.producerNodeInstanceBindingExpressionFactory = producerNodeInstanceBindingExpressionFactory;
        this.providerInstanceBindingExpressionFactory = providerInstanceBindingExpressionFactory;
        this.unscopedDirectInstanceBindingExpressionFactory = unscopedDirectInstanceBindingExpressionFactory;
        this.producerFromProviderCreationExpressionFactory = producerFromProviderCreationExpressionFactory;
        this.unscopedFrameworkInstanceCreationExpressionFactory = unscopedFrameworkInstanceCreationExpressionFactory;
        this.types = types;
        this.compilerOptions = compilerOptions;
        this.switchingProviders = new SwitchingProviders(componentImplementation, this, types);
    }

    public Expression getDependencyExpression(BindingRequest request, ClassName requestingClass) {
        return this.getBindingExpression(request).getDependencyExpression(requestingClass);
    }

    Expression getDependencyExpressionForComponentMethod(BindingRequest request, ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation componentImplementation) {
        return this.getBindingExpression(request).getDependencyExpressionForComponentMethod(componentMethod, componentImplementation);
    }

    CodeBlock getCreateMethodArgumentsCodeBlock(ContributionBinding binding) {
        return CodeBlocks.makeParametersCodeBlock(this.getCreateMethodArgumentsCodeBlocks(binding));
    }

    private ImmutableList<CodeBlock> getCreateMethodArgumentsCodeBlocks(ContributionBinding binding) {
        ImmutableList.Builder arguments = ImmutableList.builder();
        if (binding.requiresModuleInstance()) {
            arguments.add((Object)this.componentRequirementExpressions.getExpressionDuringInitialization(ComponentRequirement.forModule(binding.contributingModule().get().asType()), this.componentImplementation.name()));
        }
        binding.dependencies().stream().map(dependency -> ComponentBindingExpressions.frameworkRequest(binding, dependency)).map(request -> this.getDependencyExpression((BindingRequest)request, this.componentImplementation.name())).map(Expression::codeBlock).forEach(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
        return arguments.build();
    }

    private static BindingRequest frameworkRequest(ContributionBinding binding, DependencyRequest dependency) {
        FrameworkType frameworkType = FrameworkTypeMapper.forBindingType(binding.bindingType()).getFrameworkType(dependency.kind());
        return BindingRequest.bindingRequest(dependency.key(), frameworkType);
    }

    Expression getDependencyArgumentExpression(DependencyRequest dependencyRequest, ClassName requestingClass) {
        TypeMirror dependencyType = dependencyRequest.key().type();
        BindingRequest bindingRequest = BindingRequest.bindingRequest(dependencyRequest);
        Expression dependencyExpression = this.getDependencyExpression(bindingRequest, requestingClass);
        if (dependencyRequest.kind().equals((Object)RequestKind.INSTANCE) && !Accessibility.isTypeAccessibleFrom(dependencyType, requestingClass.packageName()) && Accessibility.isRawTypeAccessible(dependencyType, requestingClass.packageName())) {
            return dependencyExpression.castTo(this.types.erasure(dependencyType));
        }
        return dependencyExpression;
    }

    public MethodSpec getComponentMethod(ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
        Preconditions.checkArgument((boolean)componentMethod.dependencyRequest().isPresent());
        BindingRequest request = BindingRequest.bindingRequest(componentMethod.dependencyRequest().get());
        return MethodSpec.overriding((ExecutableElement)componentMethod.methodElement(), (DeclaredType)MoreTypes.asDeclared(this.graph.componentTypeElement().asType()), (Types)this.types).addCode(this.getBindingExpression(request).getComponentMethodImplementation(componentMethod, this.componentImplementation)).build();
    }

    BindingExpression getBindingExpression(BindingRequest request) {
        if (this.expressions.containsKey(request)) {
            return this.expressions.get(request);
        }
        Optional optionalBinding = (Optional)this.graph.bindingNodes(request.key()).stream().filter(bindingNode -> bindingNode.componentPath().equals((Object)this.graph.componentPath())).filter(bindingNode -> request.isRequestKind(RequestKind.MEMBERS_INJECTION) ? bindingNode.delegate().bindingType() == BindingType.MEMBERS_INJECTION : bindingNode.delegate().bindingType() == BindingType.PROVISION || bindingNode.delegate().bindingType() == BindingType.PRODUCTION).map(BindingNode::delegate).collect(DaggerCollectors.toOptional());
        if (optionalBinding.isPresent()) {
            BindingExpression expression = this.createBindingExpression((Binding)optionalBinding.get(), request);
            this.expressions.put(request, expression);
            return expression;
        }
        Preconditions.checkArgument((boolean)this.parent.isPresent(), (String)"no expression found for %s", (Object)request);
        return this.parent.get().getBindingExpression(request);
    }

    private BindingExpression createBindingExpression(Binding binding, BindingRequest request) {
        switch (binding.bindingType()) {
            case MEMBERS_INJECTION: {
                Preconditions.checkArgument((boolean)request.isRequestKind(RequestKind.MEMBERS_INJECTION));
                return this.membersInjectionBindingExpressionFactory.create((MembersInjectionBinding)binding);
            }
            case PROVISION: {
                return this.provisionBindingExpression((ContributionBinding)binding, request);
            }
            case PRODUCTION: {
                return this.productionBindingExpression((ContributionBinding)binding, request);
            }
        }
        throw new AssertionError(binding);
    }

    private BindingExpression frameworkInstanceBindingExpression(ContributionBinding binding) {
        Optional<Object> staticMethod;
        Optional<Object> optional = staticMethod = this.useStaticFactoryCreation(binding) ? MemberSelect.staticFactoryCreation(binding) : Optional.empty();
        FrameworkInstanceSupplier frameworkInstanceSupplier = staticMethod.isPresent() ? staticMethod::get : new FrameworkFieldInitializer(this.componentImplementation, binding, binding.scope().isPresent() ? this.scope(binding, this.unscopedFrameworkInstanceCreationExpressionFactory.create(binding)) : this.unscopedFrameworkInstanceCreationExpressionFactory.create(binding));
        switch (binding.bindingType()) {
            case PROVISION: {
                return this.providerInstanceBindingExpressionFactory.create(binding, frameworkInstanceSupplier);
            }
            case PRODUCTION: {
                return this.producerNodeInstanceBindingExpressionFactory.create(binding, frameworkInstanceSupplier);
            }
        }
        throw new AssertionError((Object)("invalid binding type: " + (Object)((Object)binding.bindingType())));
    }

    private FrameworkFieldInitializer.FrameworkInstanceCreationExpression scope(ContributionBinding binding, FrameworkFieldInitializer.FrameworkInstanceCreationExpression unscoped) {
        return () -> CodeBlock.of((String)"$T.provider($L)", (Object[])new Object[]{binding.scope().get().isReusable() ? TypeNames.SINGLE_CHECK : TypeNames.DOUBLE_CHECK, unscoped.creationExpression()});
    }

    private BindingExpression provisionBindingExpression(ContributionBinding binding, BindingRequest request) {
        Key key = request.key();
        switch (request.requestKind()) {
            case INSTANCE: {
                return this.instanceBindingExpression(binding);
            }
            case PROVIDER: {
                return this.providerBindingExpression(binding);
            }
            case LAZY: 
            case PRODUCED: 
            case PROVIDER_OF_LAZY: {
                return this.derivedFromFrameworkInstanceBindingExpressionFactory.create(request, FrameworkType.PROVIDER);
            }
            case PRODUCER: {
                return this.producerFromProviderBindingExpression(binding);
            }
            case FUTURE: {
                return this.immediateFutureBindingExpressionFactory.create(key);
            }
            case MEMBERS_INJECTION: {
                throw new IllegalArgumentException();
            }
        }
        throw new AssertionError();
    }

    private BindingExpression productionBindingExpression(ContributionBinding binding, BindingRequest request) {
        return request.frameworkType().isPresent() ? this.frameworkInstanceBindingExpression(binding) : this.derivedFromFrameworkInstanceBindingExpressionFactory.create(request, FrameworkType.PRODUCER_NODE);
    }

    private BindingExpression providerBindingExpression(ContributionBinding binding) {
        if (binding.kind().equals((Object)BindingKind.DELEGATE) && !this.needsCaching(binding)) {
            return this.delegateBindingExpressionFactory.create(binding, RequestKind.PROVIDER);
        }
        if (this.isFastInit() && this.unscopedFrameworkInstanceCreationExpressionFactory.create(binding).useSwitchingProvider() && !(this.instanceBindingExpression(binding) instanceof DerivedFromFrameworkInstanceBindingExpression)) {
            return this.wrapInMethod(binding, RequestKind.PROVIDER, this.switchingProviders.newBindingExpression(binding));
        }
        return this.frameworkInstanceBindingExpression(binding);
    }

    private FrameworkInstanceBindingExpression producerFromProviderBindingExpression(ContributionBinding binding) {
        Preconditions.checkArgument((boolean)binding.bindingType().equals((Object)BindingType.PROVISION));
        return this.producerNodeInstanceBindingExpressionFactory.create(binding, new FrameworkFieldInitializer(this.componentImplementation, binding, this.producerFromProviderCreationExpressionFactory.create(binding)));
    }

    private BindingExpression instanceBindingExpression(ContributionBinding binding) {
        Optional<BindingExpression> maybeDirectInstanceExpression = this.unscopedDirectInstanceBindingExpressionFactory.create(binding);
        if (maybeDirectInstanceExpression.isPresent() && (!this.needsCaching(binding) && binding.kind() != BindingKind.ASSISTED_FACTORY || this.isFastInit())) {
            BindingExpression directInstanceExpression = maybeDirectInstanceExpression.get();
            return directInstanceExpression.requiresMethodEncapsulation() || this.needsCaching(binding) ? this.wrapInMethod(binding, RequestKind.INSTANCE, directInstanceExpression) : directInstanceExpression;
        }
        return this.derivedFromFrameworkInstanceBindingExpressionFactory.create(BindingRequest.bindingRequest(binding.key(), RequestKind.INSTANCE), FrameworkType.PROVIDER);
    }

    private boolean useStaticFactoryCreation(ContributionBinding binding) {
        return !this.isFastInit() || binding.kind().equals((Object)BindingKind.MULTIBOUND_MAP) || binding.kind().equals((Object)BindingKind.MULTIBOUND_SET);
    }

    BindingExpression wrapInMethod(ContributionBinding binding, RequestKind requestKind, BindingExpression bindingExpression) {
        if (bindingExpression instanceof MethodBindingExpression) {
            return bindingExpression;
        }
        BindingRequest request = BindingRequest.bindingRequest(binding.key(), requestKind);
        MethodBindingExpression.MethodImplementationStrategy methodImplementationStrategy = this.methodImplementationStrategy(binding, request);
        Optional<ComponentDescriptor.ComponentMethodDescriptor> matchingComponentMethod = this.graph.componentDescriptor().firstMatchingComponentMethod(request);
        ComponentImplementation.ShardImplementation shardImplementation = this.componentImplementation.shardImplementation(binding.key());
        if (matchingComponentMethod.isPresent() && shardImplementation.isComponentShard()) {
            ComponentDescriptor.ComponentMethodDescriptor componentMethod = matchingComponentMethod.get();
            return this.componentMethodBindingExpressionFactory.create(request, binding, methodImplementationStrategy, bindingExpression, componentMethod);
        }
        return this.privateMethodBindingExpressionFactory.create(request, binding, methodImplementationStrategy, bindingExpression);
    }

    private MethodBindingExpression.MethodImplementationStrategy methodImplementationStrategy(ContributionBinding binding, BindingRequest request) {
        if (this.isFastInit()) {
            if (request.isRequestKind(RequestKind.PROVIDER)) {
                return MethodBindingExpression.MethodImplementationStrategy.SINGLE_CHECK;
            }
            if (request.isRequestKind(RequestKind.INSTANCE) && this.needsCaching(binding)) {
                return binding.scope().get().isReusable() ? MethodBindingExpression.MethodImplementationStrategy.SINGLE_CHECK : MethodBindingExpression.MethodImplementationStrategy.DOUBLE_CHECK;
            }
        }
        return MethodBindingExpression.MethodImplementationStrategy.SIMPLE;
    }

    private boolean needsCaching(ContributionBinding binding) {
        if (!binding.scope().isPresent()) {
            return false;
        }
        if (binding.kind().equals((Object)BindingKind.DELEGATE)) {
            return DelegateBindingExpression.isBindsScopeStrongerThanDependencyScope(binding, this.graph);
        }
        return true;
    }

    private boolean isFastInit() {
        return this.compilerOptions.fastInit(this.parent.map(p -> p.graph).orElse(this.graph).componentDescriptor().typeElement());
    }
}

