/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.writing.ComponentBindingExpressions;
import dagger.internal.codegen.writing.ComponentRequirementExpressions;
import dagger.internal.codegen.writing.InjectionMethods;
import dagger.internal.codegen.writing.MembersInjectionMethods;
import dagger.internal.codegen.writing.SimpleInvocationBindingExpression;
import dagger.model.DependencyRequest;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

final class SimpleMethodBindingExpression
extends SimpleInvocationBindingExpression {
    private final CompilerOptions compilerOptions;
    private final ProvisionBinding provisionBinding;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final MembersInjectionMethods membersInjectionMethods;
    private final ComponentRequirementExpressions componentRequirementExpressions;
    private final DaggerElements elements;
    private final SourceVersion sourceVersion;
    private final KotlinMetadataUtil metadataUtil;

    @AssistedInject
    SimpleMethodBindingExpression(@Assisted ProvisionBinding binding, MembersInjectionMethods membersInjectionMethods, CompilerOptions compilerOptions, ComponentBindingExpressions componentBindingExpressions, ComponentRequirementExpressions componentRequirementExpressions, DaggerElements elements, SourceVersion sourceVersion, KotlinMetadataUtil metadataUtil) {
        super(binding);
        this.compilerOptions = compilerOptions;
        this.provisionBinding = binding;
        this.metadataUtil = metadataUtil;
        Preconditions.checkArgument((boolean)this.provisionBinding.implicitDependencies().isEmpty(), (Object)"framework deps are not currently supported");
        Preconditions.checkArgument((boolean)this.provisionBinding.bindingElement().isPresent());
        this.componentBindingExpressions = componentBindingExpressions;
        this.membersInjectionMethods = membersInjectionMethods;
        this.componentRequirementExpressions = componentRequirementExpressions;
        this.elements = elements;
        this.sourceVersion = sourceVersion;
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        return InjectionMethods.ProvisionMethod.requiresInjectionMethod(this.provisionBinding, this.compilerOptions, requestingClass) ? this.invokeInjectionMethod(requestingClass) : this.invokeMethod(requestingClass);
    }

    private Expression invokeMethod(ClassName requestingClass) {
        CodeBlock invocation;
        CodeBlock arguments = CodeBlocks.makeParametersCodeBlock(InjectionMethods.ProvisionMethod.invokeArguments(this.provisionBinding, request -> this.dependencyArgument((DependencyRequest)request, requestingClass).codeBlock(), requestingClass));
        ExecutableElement method = MoreElements.asExecutable(this.provisionBinding.bindingElement().get());
        switch (method.getKind()) {
            case CONSTRUCTOR: {
                invocation = CodeBlock.of((String)"new $T($L)", (Object[])new Object[]{this.constructorTypeName(requestingClass), arguments});
                break;
            }
            case METHOD: {
                Optional<CodeBlock> requiredModuleInstance = this.moduleReference(requestingClass);
                CodeBlock module = requiredModuleInstance.isPresent() ? requiredModuleInstance.get() : (this.metadataUtil.isObjectClass(MoreElements.asType(method.getEnclosingElement())) ? CodeBlock.of((String)"$T.INSTANCE", (Object[])new Object[]{this.provisionBinding.bindingTypeElement().get()}) : CodeBlock.of((String)"$T", (Object[])new Object[]{this.provisionBinding.bindingTypeElement().get()}));
                invocation = CodeBlock.of((String)"$L.$L($L)", (Object[])new Object[]{module, method.getSimpleName(), arguments});
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Expression.create(this.simpleMethodReturnType(), invocation);
    }

    private TypeName constructorTypeName(ClassName requestingClass) {
        DeclaredType type = MoreTypes.asDeclared(this.provisionBinding.key().type());
        TypeName typeName = TypeName.get((TypeMirror)type);
        if (type.getTypeArguments().stream().allMatch(t -> Accessibility.isTypeAccessibleFrom(t, requestingClass.packageName()))) {
            return typeName;
        }
        return TypeNames.rawTypeName(typeName);
    }

    private Expression invokeInjectionMethod(ClassName requestingClass) {
        return this.injectMembers(InjectionMethods.ProvisionMethod.invoke(this.provisionBinding, request -> this.dependencyArgument((DependencyRequest)request, requestingClass).codeBlock(), requestingClass, this.moduleReference(requestingClass), this.compilerOptions, this.metadataUtil));
    }

    private Expression dependencyArgument(DependencyRequest dependency, ClassName requestingClass) {
        return this.componentBindingExpressions.getDependencyArgumentExpression(dependency, requestingClass);
    }

    private Expression injectMembers(CodeBlock instance) {
        if (this.provisionBinding.injectionSites().isEmpty()) {
            return Expression.create(this.simpleMethodReturnType(), instance);
        }
        if (this.sourceVersion.compareTo(SourceVersion.RELEASE_7) <= 0 && !MoreTypes.asDeclared(this.provisionBinding.key().type()).getTypeArguments().isEmpty()) {
            TypeName keyType = TypeName.get((TypeMirror)this.provisionBinding.key().type());
            instance = CodeBlock.of((String)"($T) ($T) $L", (Object[])new Object[]{keyType, TypeNames.rawTypeName(keyType), instance});
        }
        MethodSpec membersInjectionMethod = this.membersInjectionMethods.getOrCreate(this.provisionBinding.key());
        TypeMirror returnType = membersInjectionMethod.returnType.equals((Object)TypeName.OBJECT) ? this.elements.getTypeElement(Object.class).asType() : this.provisionBinding.key().type();
        return Expression.create(returnType, CodeBlock.of((String)"$N($L)", (Object[])new Object[]{membersInjectionMethod, instance}));
    }

    private Optional<CodeBlock> moduleReference(ClassName requestingClass) {
        return this.provisionBinding.requiresModuleInstance() ? this.provisionBinding.contributingModule().map(Element::asType).map(ComponentRequirement::forModule).map(module -> this.componentRequirementExpressions.getExpression((ComponentRequirement)module, requestingClass)) : Optional.empty();
    }

    private TypeMirror simpleMethodReturnType() {
        return this.provisionBinding.contributedPrimitiveType().orElse(this.provisionBinding.key().type());
    }

    @AssistedFactory
    static interface Factory {
        public SimpleMethodBindingExpression create(ProvisionBinding var1);
    }
}

