/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.binding.InjectBindingRegistry;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.shaded.auto.common.MoreElements;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementKindVisitor8;

final class InjectProcessingStep
extends TypeCheckingProcessingStep<Element> {
    private final ElementVisitor<Void, Void> visitor;
    private final Set<Element> processedElements = Sets.newLinkedHashSet();

    @Inject
    InjectProcessingStep(final InjectBindingRegistry injectBindingRegistry) {
        super((Element e) -> e);
        this.visitor = new ElementKindVisitor8<Void, Void>(){

            @Override
            public Void visitExecutableAsConstructor(ExecutableElement constructorElement, Void aVoid) {
                injectBindingRegistry.tryRegisterConstructor(constructorElement);
                return null;
            }

            @Override
            public Void visitVariableAsField(VariableElement fieldElement, Void aVoid) {
                injectBindingRegistry.tryRegisterMembersInjectedType(MoreElements.asType(fieldElement.getEnclosingElement()));
                return null;
            }

            @Override
            public Void visitExecutableAsMethod(ExecutableElement methodElement, Void aVoid) {
                injectBindingRegistry.tryRegisterMembersInjectedType(MoreElements.asType(methodElement.getEnclosingElement()));
                return null;
            }
        };
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return ImmutableSet.of((Object)TypeNames.INJECT, (Object)TypeNames.ASSISTED_INJECT);
    }

    @Override
    protected void process(Element injectElement, ImmutableSet<ClassName> annotations) {
        if (this.processedElements.contains(injectElement)) {
            return;
        }
        injectElement.accept(this.visitor, null);
        this.processedElements.add(injectElement);
    }
}

