/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.BindingFactory;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.DelegateDeclaration;
import dagger.internal.codegen.binding.ProductionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.validation.ModuleValidator;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.writing.InaccessibleMapKeyProxyGenerator;
import dagger.internal.codegen.writing.ModuleGenerator;
import dagger.shaded.auto.common.MoreElements;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class ModuleProcessingStep
extends TypeCheckingProcessingStep<TypeElement> {
    private final Messager messager;
    private final ModuleValidator moduleValidator;
    private final BindingFactory bindingFactory;
    private final SourceFileGenerator<ProvisionBinding> factoryGenerator;
    private final SourceFileGenerator<ProductionBinding> producerFactoryGenerator;
    private final SourceFileGenerator<TypeElement> moduleConstructorProxyGenerator;
    private final InaccessibleMapKeyProxyGenerator inaccessibleMapKeyProxyGenerator;
    private final DelegateDeclaration.Factory delegateDeclarationFactory;
    private final KotlinMetadataUtil metadataUtil;
    private final Set<TypeElement> processedModuleElements = Sets.newLinkedHashSet();

    @Inject
    ModuleProcessingStep(Messager messager, ModuleValidator moduleValidator, BindingFactory bindingFactory, SourceFileGenerator<ProvisionBinding> factoryGenerator, SourceFileGenerator<ProductionBinding> producerFactoryGenerator, @ModuleGenerator SourceFileGenerator<TypeElement> moduleConstructorProxyGenerator, InaccessibleMapKeyProxyGenerator inaccessibleMapKeyProxyGenerator, DelegateDeclaration.Factory delegateDeclarationFactory, KotlinMetadataUtil metadataUtil) {
        super(MoreElements::asType);
        this.messager = messager;
        this.moduleValidator = moduleValidator;
        this.bindingFactory = bindingFactory;
        this.factoryGenerator = factoryGenerator;
        this.producerFactoryGenerator = producerFactoryGenerator;
        this.moduleConstructorProxyGenerator = moduleConstructorProxyGenerator;
        this.inaccessibleMapKeyProxyGenerator = inaccessibleMapKeyProxyGenerator;
        this.delegateDeclarationFactory = delegateDeclarationFactory;
        this.metadataUtil = metadataUtil;
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return ImmutableSet.of((Object)TypeNames.MODULE, (Object)TypeNames.PRODUCER_MODULE);
    }

    @Override
    public ImmutableSet<Element> process(ImmutableSetMultimap<String, Element> elementsByAnnotation) {
        List<TypeElement> modules = ElementFilter.typesIn((Iterable<? extends Element>)elementsByAnnotation.values());
        this.moduleValidator.addKnownModules(modules);
        return super.process(elementsByAnnotation);
    }

    @Override
    protected void process(TypeElement module, ImmutableSet<ClassName> annotations) {
        if (this.processedModuleElements.contains(module)) {
            return;
        }
        if (this.metadataUtil.isCompanionObjectClass(module)) {
            return;
        }
        ValidationReport<TypeElement> report = this.moduleValidator.validate(module);
        report.printMessagesTo(this.messager);
        if (report.isClean()) {
            this.generateForMethodsIn(module);
            if (this.metadataUtil.hasEnclosedCompanionObject(module)) {
                this.generateForMethodsIn(this.metadataUtil.getEnclosedCompanionObject(module));
            }
        }
        this.processedModuleElements.add(module);
    }

    private void generateForMethodsIn(TypeElement module) {
        for (ExecutableElement method : ElementFilter.methodsIn(module.getEnclosedElements())) {
            if (DaggerElements.isAnnotationPresent((Element)method, TypeNames.PROVIDES)) {
                this.generate(this.factoryGenerator, this.bindingFactory.providesMethodBinding(method, module));
                continue;
            }
            if (DaggerElements.isAnnotationPresent((Element)method, TypeNames.PRODUCES)) {
                this.generate(this.producerFactoryGenerator, this.bindingFactory.producesMethodBinding(method, module));
                continue;
            }
            if (!DaggerElements.isAnnotationPresent((Element)method, TypeNames.BINDS)) continue;
            this.inaccessibleMapKeyProxyGenerator.generate(this.bindsMethodBinding(module, method), this.messager);
        }
        this.moduleConstructorProxyGenerator.generate(module, this.messager);
    }

    private <B extends ContributionBinding> void generate(SourceFileGenerator<B> generator, B binding) {
        generator.generate(binding, this.messager);
        this.inaccessibleMapKeyProxyGenerator.generate(binding, this.messager);
    }

    private ContributionBinding bindsMethodBinding(TypeElement module, ExecutableElement method) {
        return this.bindingFactory.unresolvedDelegateBinding(this.delegateDeclarationFactory.create(method, module));
    }
}

