/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.validation.AnyBindingMethodValidator;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.shaded.auto.common.MoreElements;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.tools.Diagnostic;

public final class MultibindingAnnotationsProcessingStep
extends TypeCheckingProcessingStep<ExecutableElement> {
    private final AnyBindingMethodValidator anyBindingMethodValidator;
    private final Messager messager;

    @Inject
    MultibindingAnnotationsProcessingStep(AnyBindingMethodValidator anyBindingMethodValidator, Messager messager) {
        super(MoreElements::asExecutable);
        this.anyBindingMethodValidator = anyBindingMethodValidator;
        this.messager = messager;
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return ImmutableSet.of((Object)TypeNames.INTO_SET, (Object)TypeNames.ELEMENTS_INTO_SET, (Object)TypeNames.INTO_MAP);
    }

    @Override
    protected void process(ExecutableElement method, ImmutableSet<ClassName> annotations) {
        if (!this.anyBindingMethodValidator.isBindingMethod(method)) {
            annotations.forEach(annotation -> this.messager.printMessage(Diagnostic.Kind.ERROR, "Multibinding annotations may only be on @Provides, @Produces, or @Binds methods", method, DaggerElements.getAnnotationMirror(method, annotation).get()));
        }
    }
}

