/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.internal.codegen.binding.ConfigurationAnnotations;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.BindingElementValidator;
import dagger.internal.codegen.validation.BindingMethodValidator;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

final class ProducesMethodValidator
extends BindingMethodValidator {
    @Inject
    ProducesMethodValidator(DaggerElements elements, DaggerTypes types, KotlinMetadataUtil kotlinMetadataUtil, DependencyRequestValidator dependencyRequestValidator, InjectionAnnotations injectionAnnotations) {
        super(elements, types, kotlinMetadataUtil, dependencyRequestValidator, TypeNames.PRODUCES, TypeNames.PRODUCER_MODULE, BindingMethodValidator.Abstractness.MUST_BE_CONCRETE, BindingMethodValidator.ExceptionSuperclass.EXCEPTION, BindingElementValidator.AllowsMultibindings.ALLOWS_MULTIBINDINGS, BindingElementValidator.AllowsScoping.NO_SCOPING, injectionAnnotations);
    }

    @Override
    protected String elementsIntoSetNotASetMessage() {
        return "@Produces methods of type set values must return a Set or ListenableFuture of Set";
    }

    @Override
    protected String badTypeMessage() {
        return "@Produces methods can return only a primitive, an array, a type variable, a declared type, or a ListenableFuture of one of those types";
    }

    @Override
    protected BindingElementValidator.ElementValidator elementValidator(ExecutableElement element) {
        return new Validator(element);
    }

    private class Validator
    extends BindingMethodValidator.MethodValidator {
        Validator(ExecutableElement element) {
            super(ProducesMethodValidator.this, element);
        }

        @Override
        protected void checkAdditionalMethodProperties() {
            this.checkNullable();
        }

        private void checkNullable() {
            if (ConfigurationAnnotations.getNullableType(this.element).isPresent()) {
                this.report.addWarning("@Nullable on @Produces methods does not do anything");
            }
        }

        @Override
        protected void checkKeyType(TypeMirror keyType) {
            Optional<TypeMirror> typeToCheck = this.unwrapListenableFuture(keyType);
            if (typeToCheck.isPresent()) {
                super.checkKeyType(typeToCheck.get());
            }
        }

        @Override
        protected void checkSetValuesType() {
            Optional<TypeMirror> typeToCheck = this.unwrapListenableFuture(((ExecutableElement)this.element).getReturnType());
            if (typeToCheck.isPresent()) {
                this.checkSetValuesType(typeToCheck.get());
            }
        }

        private Optional<TypeMirror> unwrapListenableFuture(TypeMirror type) {
            if (MoreTypes.isType(type) && MoreTypes.isTypeOf(ListenableFuture.class, type)) {
                DeclaredType declaredType = MoreTypes.asDeclared(type);
                if (declaredType.getTypeArguments().isEmpty()) {
                    this.report.addError("@Produces methods cannot return a raw ListenableFuture");
                    return Optional.empty();
                }
                return Optional.of((TypeMirror)Iterables.getOnlyElement(declaredType.getTypeArguments()));
            }
            return Optional.of(type);
        }
    }
}

