/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import javax.lang.model.element.Element;

public abstract class TypeCheckingProcessingStep<E extends Element>
implements BasicAnnotationProcessor.Step {
    private final Function<Element, E> downcaster;

    protected TypeCheckingProcessingStep(Function<Element, E> downcaster) {
        this.downcaster = (Function)Preconditions.checkNotNull(downcaster);
    }

    public final ImmutableSet<String> annotations() {
        return (ImmutableSet)this.annotationClassNames().stream().map(ClassName::canonicalName).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<Element> process(ImmutableSetMultimap<String, Element> elementsByAnnotation) {
        ImmutableMap annotationClassNames = (ImmutableMap)this.annotationClassNames().stream().collect(DaggerStreams.toImmutableMap(ClassName::canonicalName, className -> className));
        Preconditions.checkState((boolean)annotationClassNames.keySet().containsAll((Collection)elementsByAnnotation.keySet()), (String)"Unexpected annotations for %s: %s", (Object)this.getClass().getName(), (Object)Sets.difference((Set)elementsByAnnotation.keySet(), (Set)annotationClassNames.keySet()));
        ImmutableSet.Builder deferredElements = ImmutableSet.builder();
        ImmutableSetMultimap.copyOf(elementsByAnnotation).inverse().asMap().forEach((element, annotations) -> {
            try {
                this.process((Element)this.downcaster.apply((Element)element), (ImmutableSet<ClassName>)((ImmutableSet)annotations.stream().map(arg_0 -> ((ImmutableMap)annotationClassNames).get(arg_0)).collect(DaggerStreams.toImmutableSet())));
            }
            catch (TypeNotPresentException e) {
                deferredElements.add(element);
            }
        });
        return deferredElements.build();
    }

    protected abstract void process(E var1, ImmutableSet<ClassName> var2);

    protected abstract Set<ClassName> annotationClassNames();
}

