/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.Preconditions;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingNode;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentCreatorKind;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.KeyVariableNamer;
import dagger.internal.codegen.binding.MethodSignature;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.AnnotationSpecs;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.javapoet.TypeSpecs;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.ComponentBindingExpressions;
import dagger.internal.codegen.writing.ComponentCreatorImplementation;
import dagger.internal.codegen.writing.ComponentCreatorImplementationFactory;
import dagger.internal.codegen.writing.ComponentNames;
import dagger.internal.codegen.writing.ParentComponent;
import dagger.internal.codegen.writing.PerComponentImplementation;
import dagger.model.Key;
import dagger.model.RequestKind;
import dagger.producers.CancellationPolicy;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

@PerComponentImplementation
public final class ComponentImplementation {
    public static final ParameterSpec MAY_INTERRUPT_IF_RUNNING_PARAM = ParameterSpec.builder(Boolean.TYPE, (String)"mayInterruptIfRunning", (Modifier[])new Modifier[0]).build();
    private static final String CANCELLATION_LISTENER_METHOD_NAME = "onProducerFutureCancelled";
    private static final int STATEMENTS_PER_METHOD = 100;
    private final ShardImplementation componentShard;
    private final ImmutableMap<Binding, ShardImplementation> shardsByBinding;
    private final Map<ShardImplementation, FieldSpec> shardFieldsByImplementation = new HashMap<ShardImplementation, FieldSpec>();
    private final List<CodeBlock> shardInitializations = new ArrayList<CodeBlock>();
    private final List<CodeBlock> shardCancellations = new ArrayList<CodeBlock>();
    private final Optional<ComponentImplementation> parent;
    private final ChildComponentImplementationFactory childComponentImplementationFactory;
    private final Provider<ComponentBindingExpressions> bindingExpressionsProvider;
    private final Provider<ComponentCreatorImplementationFactory> componentCreatorImplementationFactoryProvider;
    private final BindingGraph graph;
    private final ComponentNames componentNames;
    private final CompilerOptions compilerOptions;
    private final DaggerElements elements;
    private final DaggerTypes types;
    private final KotlinMetadataUtil metadataUtil;
    private final ImmutableMap<ComponentImplementation, FieldSpec> componentFieldsByImplementation;

    private static ImmutableMap<Binding, ShardImplementation> createShardsByBinding(ShardImplementation componentShard, BindingGraph graph, CompilerOptions compilerOptions) {
        ImmutableList<ImmutableList<Binding>> partitions = ComponentImplementation.bindingPartitions(graph, compilerOptions);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < partitions.size(); ++i) {
            ShardImplementation shard = i == 0 ? componentShard : componentShard.createShard("Shard" + i);
            ((ImmutableList)partitions.get(i)).forEach(binding -> builder.put(binding, (Object)shard));
        }
        return builder.build();
    }

    private static ImmutableList<ImmutableList<Binding>> bindingPartitions(BindingGraph graph, CompilerOptions compilerOptions) {
        int bindingsPerShard = compilerOptions.keysPerComponentShard(graph.componentTypeElement());
        int maxPartitions = graph.localBindingNodes().size() / bindingsPerShard + 1;
        if (maxPartitions <= 1) {
            return ImmutableList.of((Object)((ImmutableList)graph.localBindingNodes().stream().map(BindingNode::delegate).collect(DaggerStreams.toImmutableList())));
        }
        ArrayList currPartition = new ArrayList(bindingsPerShard);
        ImmutableList.Builder partitions = ImmutableList.builderWithExpectedSize((int)maxPartitions);
        for (ImmutableSet nodes : graph.topLevelBindingGraph().stronglyConnectedNodes()) {
            nodes.stream().flatMap(DaggerStreams.instancesOf(BindingNode.class)).filter(bindingNode -> bindingNode.componentPath().equals((Object)graph.componentPath())).map(BindingNode::delegate).forEach(currPartition::add);
            if (currPartition.size() < bindingsPerShard) continue;
            partitions.add((Object)ImmutableList.copyOf(currPartition));
            currPartition = new ArrayList(bindingsPerShard);
        }
        if (!currPartition.isEmpty()) {
            partitions.add((Object)ImmutableList.copyOf(currPartition));
        }
        return partitions.build();
    }

    @Inject
    ComponentImplementation(@ParentComponent Optional<ComponentImplementation> parent, ChildComponentImplementationFactory childComponentImplementationFactory, Provider<ComponentBindingExpressions> bindingExpressionsProvider, Provider<ComponentCreatorImplementationFactory> componentCreatorImplementationFactoryProvider, BindingGraph graph, ComponentNames componentNames, CompilerOptions compilerOptions, DaggerElements elements, DaggerTypes types, KotlinMetadataUtil metadataUtil) {
        this.parent = parent;
        this.childComponentImplementationFactory = childComponentImplementationFactory;
        this.bindingExpressionsProvider = bindingExpressionsProvider;
        this.componentCreatorImplementationFactoryProvider = componentCreatorImplementationFactoryProvider;
        this.graph = graph;
        this.componentNames = componentNames;
        this.compilerOptions = compilerOptions;
        this.elements = elements;
        this.types = types;
        this.metadataUtil = metadataUtil;
        this.componentShard = new ShardImplementation(ComponentImplementation.getComponentName(graph, parent, componentNames));
        elements.getLocalAndInheritedMethods(graph.componentTypeElement()).forEach(method -> this.componentShard.componentMethodNames.claim(method.getSimpleName()));
        this.shardsByBinding = ComponentImplementation.createShardsByBinding(this.componentShard, graph, compilerOptions);
        this.componentFieldsByImplementation = ComponentImplementation.createComponentFieldsByImplementation(this, compilerOptions);
    }

    public ShardImplementation shardImplementation(Binding binding) {
        com.google.common.base.Preconditions.checkState((boolean)this.shardsByBinding.containsKey((Object)binding), (String)"No shard in %s for: %s", (Object)this.name(), (Object)binding);
        return (ShardImplementation)this.shardsByBinding.get((Object)binding);
    }

    ComponentImplementation rootComponentImplementation() {
        return this.parent.map(ComponentImplementation::rootComponentImplementation).orElse(this);
    }

    public CodeBlock componentFieldReference() {
        return CodeBlock.of((String)"$N", (Object[])new Object[]{this.componentFieldsByImplementation.get((Object)this)});
    }

    public ImmutableList<FieldSpec> componentFields() {
        return ImmutableList.copyOf((Collection)this.componentFieldsByImplementation.values());
    }

    public ImmutableList<FieldSpec> creatorComponentFields() {
        return (ImmutableList)this.componentFieldsByImplementation.entrySet().stream().filter(entry -> !this.equals(entry.getKey())).map(Map.Entry::getValue).collect(DaggerStreams.toImmutableList());
    }

    private static ImmutableMap<ComponentImplementation, FieldSpec> createComponentFieldsByImplementation(ComponentImplementation componentImplementation, CompilerOptions compilerOptions) {
        com.google.common.base.Preconditions.checkArgument((componentImplementation.componentShard != null ? 1 : 0) != 0, (Object)"The component shard must be set before computing the component fields.");
        ImmutableList.Builder builder = ImmutableList.builder();
        ComponentImplementation curr = componentImplementation;
        while (curr != null) {
            builder.add((Object)curr);
            curr = curr.parent.orElse(null);
        }
        return (ImmutableMap)builder.build().reverse().stream().collect(DaggerStreams.toImmutableMap(componentImpl -> componentImpl, componentImpl -> {
            TypeElement component = componentImpl.graph.componentPath().currentComponent();
            ClassName fieldType = componentImpl.name();
            String fieldName = componentImpl.isNested() ? SourceFiles.simpleVariableName(componentImpl.name()) : SourceFiles.simpleVariableName(component);
            FieldSpec.Builder field = FieldSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            componentImplementation.componentShard.componentFieldNames.claim(fieldName);
            return field.build();
        }));
    }

    public ShardImplementation getComponentShard() {
        return this.componentShard;
    }

    public BindingGraph graph() {
        return this.componentShard.graph();
    }

    public ComponentDescriptor componentDescriptor() {
        return this.componentShard.componentDescriptor();
    }

    public ClassName name() {
        return this.componentShard.name;
    }

    private boolean isNested() {
        return this.name().enclosingClassName() != null;
    }

    private ComponentCreatorKind creatorKind() {
        com.google.common.base.Preconditions.checkState((boolean)this.componentDescriptor().hasCreator());
        return this.componentDescriptor().creatorDescriptor().map(ComponentCreatorDescriptor::kind).orElse(ComponentCreatorKind.BUILDER);
    }

    public ClassName getCreatorName() {
        return this.isNested() ? this.name().peerClass(this.componentNames.getCreatorName(this.componentDescriptor())) : this.name().nestedClass(this.creatorKind().typeName());
    }

    private static ClassName getComponentName(BindingGraph graph, Optional<ComponentImplementation> parent, ComponentNames componentNames) {
        if (!parent.isPresent()) {
            return ComponentNames.getRootComponentClassName(graph.componentDescriptor());
        }
        ComponentDescriptor parentDescriptor = parent.get().graph.componentDescriptor();
        ComponentDescriptor childDescriptor = graph.componentDescriptor();
        com.google.common.base.Preconditions.checkArgument((boolean)parentDescriptor.childComponents().contains((Object)childDescriptor), (String)"%s is not a child component of %s", (Object)childDescriptor.typeElement(), (Object)parentDescriptor.typeElement());
        String suffix = parent.get().name().simpleNames().size() > 2 ? "I" : "Impl";
        return parent.get().name().nestedClass(componentNames.get(childDescriptor) + suffix);
    }

    public TypeSpec generate() {
        return this.componentShard.generate();
    }

    private static ImmutableList<ComponentRequirement> constructorRequirements(BindingGraph graph) {
        if (graph.componentDescriptor().hasCreator()) {
            return graph.componentRequirements().asList();
        }
        if (graph.factoryMethod().isPresent()) {
            return graph.factoryMethodParameters().keySet().asList();
        }
        throw new AssertionError((Object)"Expected either a component creator or factory method but found neither.");
    }

    private static ImmutableList<ParameterSpec> makeFinal(List<ParameterSpec> parameters) {
        return (ImmutableList)parameters.stream().map(param -> param.toBuilder().addModifiers(new Modifier[]{Modifier.FINAL}).build()).collect(DaggerStreams.toImmutableList());
    }

    public final class ShardImplementation {
        private final ClassName name;
        private final UniqueNameSet componentFieldNames = new UniqueNameSet();
        private final UniqueNameSet componentMethodNames = new UniqueNameSet();
        private final List<CodeBlock> initializations = new ArrayList<CodeBlock>();
        private final Map<Key, CodeBlock> cancellations = new LinkedHashMap<Key, CodeBlock>();
        private final List<CodeBlock> componentRequirementInitializations = new ArrayList<CodeBlock>();
        private final ImmutableMap<ComponentRequirement, ParameterSpec> constructorParameters;
        private final ListMultimap<FieldSpecKind, FieldSpec> fieldSpecsMap = MultimapBuilder.enumKeys(FieldSpecKind.class).arrayListValues().build();
        private final ListMultimap<MethodSpecKind, MethodSpec> methodSpecsMap = MultimapBuilder.enumKeys(MethodSpecKind.class).arrayListValues().build();
        private final ListMultimap<TypeSpecKind, TypeSpec> typeSpecsMap = MultimapBuilder.enumKeys(TypeSpecKind.class).arrayListValues().build();
        private final List<Supplier<TypeSpec>> typeSuppliers = new ArrayList<Supplier<TypeSpec>>();

        private ShardImplementation(ClassName name) {
            this.name = name;
            if (ComponentImplementation.this.graph.componentDescriptor().isProduction()) {
                this.claimMethodName(ComponentImplementation.CANCELLATION_LISTENER_METHOD_NAME);
            }
            this.constructorParameters = (ImmutableMap)ComponentImplementation.constructorRequirements(ComponentImplementation.this.graph).stream().collect(DaggerStreams.toImmutableMap(requirement -> requirement, requirement -> ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)requirement.type()), (String)this.getUniqueFieldName(requirement.variableName() + "Param"), (Modifier[])new Modifier[0]).build()));
        }

        private ShardImplementation createShard(String shardName) {
            com.google.common.base.Preconditions.checkState((boolean)this.isComponentShard(), (Object)"Only the componentShard can create other shards.");
            return new ShardImplementation(this.name.nestedClass(shardName));
        }

        public ComponentImplementation getComponentImplementation() {
            return ComponentImplementation.this;
        }

        public boolean isComponentShard() {
            return this == ComponentImplementation.this.componentShard;
        }

        public ImmutableMap<ComponentImplementation, FieldSpec> componentFieldsByImplementation() {
            return ComponentImplementation.this.componentFieldsByImplementation;
        }

        public CodeBlock shardFieldReference() {
            if (!this.isComponentShard() && !ComponentImplementation.this.shardFieldsByImplementation.containsKey(this)) {
                String shardFieldName = ComponentImplementation.this.componentShard.getUniqueFieldName(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, this.name.simpleName()));
                FieldSpec shardField = FieldSpec.builder((TypeName)this.name, (String)shardFieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
                ComponentImplementation.this.shardFieldsByImplementation.put(this, shardField);
            }
            return this.isComponentShard() ? ComponentImplementation.this.componentFieldReference() : CodeBlock.of((String)"$L.$N", (Object[])new Object[]{ComponentImplementation.this.componentFieldReference(), ComponentImplementation.this.shardFieldsByImplementation.get(this)});
        }

        public BindingGraph graph() {
            return ComponentImplementation.this.graph;
        }

        public ComponentDescriptor componentDescriptor() {
            return ComponentImplementation.this.graph.componentDescriptor();
        }

        public ClassName name() {
            return this.name;
        }

        String getSubcomponentCreatorSimpleName(Key key) {
            return ComponentImplementation.this.componentNames.getCreatorName(key);
        }

        boolean isTypeAccessible(TypeMirror type) {
            return Accessibility.isTypeAccessibleFrom(type, this.name.packageName());
        }

        public void addField(FieldSpecKind fieldKind, FieldSpec fieldSpec) {
            this.fieldSpecsMap.put((Object)fieldKind, (Object)fieldSpec);
        }

        public void addMethod(MethodSpecKind methodKind, MethodSpec methodSpec) {
            this.methodSpecsMap.put((Object)methodKind, (Object)methodSpec);
        }

        public void addType(TypeSpecKind typeKind, TypeSpec typeSpec) {
            this.typeSpecsMap.put((Object)typeKind, (Object)typeSpec);
        }

        void addTypeSupplier(Supplier<TypeSpec> typeSpecSupplier) {
            this.typeSuppliers.add(typeSpecSupplier);
        }

        void addInitialization(CodeBlock codeBlock) {
            this.initializations.add(codeBlock);
        }

        void addComponentRequirementInitialization(CodeBlock codeBlock) {
            this.componentRequirementInitializations.add(codeBlock);
        }

        void addCancellation(Key key, CodeBlock codeBlock) {
            this.cancellations.putIfAbsent(key, codeBlock);
        }

        String getUniqueFieldName(String name) {
            return this.componentFieldNames.getUniqueName(name);
        }

        public String getUniqueMethodName(String name) {
            return this.componentMethodNames.getUniqueName(name);
        }

        String getUniqueMethodName(BindingRequest request) {
            return this.uniqueMethodName(request, KeyVariableNamer.name(request.key()));
        }

        private String uniqueMethodName(BindingRequest request, String bindingName) {
            String baseMethodName = bindingName + (request.isRequestKind(RequestKind.INSTANCE) ? "" : CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, request.kindName()));
            return this.getUniqueMethodName(baseMethodName);
        }

        public String getParameterName(ComponentRequirement requirement) {
            return ((ParameterSpec)this.constructorParameters.get((Object)requirement)).name;
        }

        public void claimMethodName(CharSequence name) {
            this.componentMethodNames.claim(name);
        }

        private TypeSpec generate() {
            TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.name);
            if (this.isComponentShard()) {
                TypeSpecs.addSupertype(builder, ComponentImplementation.this.graph.componentTypeElement());
                this.addCreator();
                this.addFactoryMethods();
                this.addInterfaceMethods();
                this.addChildComponents();
                this.addShards();
            }
            this.addConstructorAndInitializationMethods();
            if (ComponentImplementation.this.graph.componentDescriptor().isProduction() && (this.isComponentShard() || !this.cancellations.isEmpty())) {
                TypeSpecs.addSupertype(builder, ComponentImplementation.this.elements.getTypeElement(TypeNames.CANCELLATION_LISTENER.canonicalName()));
                this.addCancellationListenerImplementation();
            }
            this.modifiers().forEach(xva$0 -> builder.addModifiers(new Modifier[]{xva$0}));
            this.fieldSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)builder).addFields(arg_0));
            this.methodSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethods(arg_0));
            this.typeSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)builder).addTypes(arg_0));
            this.typeSuppliers.stream().map(Supplier::get).forEach(arg_0 -> ((TypeSpec.Builder)builder).addType(arg_0));
            return builder.build();
        }

        private ImmutableSet<Modifier> modifiers() {
            if (!this.isComponentShard()) {
                return ImmutableSet.of((Object)((Object)Modifier.PRIVATE), (Object)((Object)Modifier.FINAL));
            }
            if (ComponentImplementation.this.isNested()) {
                return ImmutableSet.of((Object)((Object)Modifier.PRIVATE), (Object)((Object)Modifier.STATIC), (Object)((Object)Modifier.FINAL));
            }
            return ComponentImplementation.this.graph.componentTypeElement().getModifiers().contains((Object)Modifier.PUBLIC) ? ImmutableSet.of((Object)((Object)Modifier.PUBLIC), (Object)((Object)Modifier.FINAL)) : ImmutableSet.of((Object)((Object)Modifier.FINAL));
        }

        private void addCreator() {
            ((ComponentCreatorImplementationFactory)ComponentImplementation.this.componentCreatorImplementationFactoryProvider.get()).create().map(ComponentCreatorImplementation::spec).ifPresent(creator -> {
                if (ComponentImplementation.this.parent.isPresent()) {
                    ((ComponentImplementation)ComponentImplementation.this.parent.get()).componentShard.addType(TypeSpecKind.SUBCOMPONENT, (TypeSpec)creator);
                } else {
                    this.addType(TypeSpecKind.COMPONENT_CREATOR, (TypeSpec)creator);
                }
            });
        }

        private void addFactoryMethods() {
            if (ComponentImplementation.this.parent.isPresent()) {
                ComponentImplementation.this.graph.factoryMethod().ifPresent(this::createSubcomponentFactoryMethod);
            } else {
                this.createRootComponentFactoryMethod();
            }
        }

        private void createRootComponentFactoryMethod() {
            boolean noArgFactoryMethod;
            String factoryMethodName;
            ClassName creatorType;
            ComponentCreatorKind creatorKind;
            com.google.common.base.Preconditions.checkState((!ComponentImplementation.this.parent.isPresent() ? 1 : 0) != 0);
            Optional<ComponentCreatorDescriptor> creatorDescriptor = ComponentImplementation.this.graph.componentDescriptor().creatorDescriptor();
            if (creatorDescriptor.isPresent()) {
                ComponentCreatorDescriptor descriptor = creatorDescriptor.get();
                creatorKind = descriptor.kind();
                creatorType = ClassName.get((TypeElement)descriptor.typeElement());
                factoryMethodName = descriptor.factoryMethod().getSimpleName().toString();
                noArgFactoryMethod = descriptor.factoryParameters().isEmpty();
            } else {
                creatorKind = ComponentCreatorKind.BUILDER;
                creatorType = ComponentImplementation.this.getCreatorName();
                factoryMethodName = "build";
                noArgFactoryMethod = true;
            }
            MethodSpec creatorFactoryMethod = MethodSpec.methodBuilder((String)creatorKind.methodName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)creatorType).addStatement("return new $T()", new Object[]{ComponentImplementation.this.getCreatorName()}).build();
            this.addMethod(MethodSpecKind.BUILDER_METHOD, creatorFactoryMethod);
            if (noArgFactoryMethod && this.canInstantiateAllRequirements()) {
                this.addMethod(MethodSpecKind.BUILDER_METHOD, MethodSpec.methodBuilder((String)"create").returns((TypeName)ClassName.get((TypeElement)ComponentImplementation.this.graph.componentTypeElement())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addStatement("return new $L().$L()", new Object[]{creatorKind.typeName(), factoryMethodName}).build());
            }
        }

        private boolean canInstantiateAllRequirements() {
            return !Iterables.any(ComponentImplementation.this.graph.componentRequirements(), dependency -> dependency.requiresAPassedInstance(ComponentImplementation.this.elements, ComponentImplementation.this.metadataUtil));
        }

        private void createSubcomponentFactoryMethod(ExecutableElement factoryMethod) {
            com.google.common.base.Preconditions.checkState((boolean)ComponentImplementation.this.parent.isPresent());
            Collection params = Maps.transformValues(ComponentImplementation.this.graph.factoryMethodParameters(), ParameterSpec::get).values();
            DeclaredType parentType = MoreTypes.asDeclared(((ComponentImplementation)ComponentImplementation.this.parent.get()).graph().componentTypeElement().asType());
            MethodSpec.Builder method = MethodSpec.overriding((ExecutableElement)factoryMethod, (DeclaredType)parentType, (Types)ComponentImplementation.this.types);
            params.forEach(param -> method.addStatement("$T.checkNotNull($N)", new Object[]{Preconditions.class, param}));
            method.addStatement("return new $T($L)", new Object[]{this.name(), CodeBlocks.parameterNames((Iterable<ParameterSpec>)ImmutableList.builder().addAll((Iterable)ComponentImplementation.this.creatorComponentFields().stream().map(field -> ParameterSpec.builder((TypeName)field.type, (String)field.name, (Modifier[])new Modifier[0]).build()).collect(DaggerStreams.toImmutableList())).addAll(params).build())});
            ((ComponentImplementation)ComponentImplementation.this.parent.get()).getComponentShard().addMethod(MethodSpecKind.COMPONENT_METHOD, method.build());
        }

        private void addInterfaceMethods() {
            DeclaredType componentType = MoreTypes.asDeclared(ComponentImplementation.this.graph.componentTypeElement().asType());
            HashSet signatures = Sets.newHashSet();
            for (ComponentDescriptor.ComponentMethodDescriptor method : ComponentImplementation.this.graph.componentDescriptor().entryPointMethods()) {
                if (!signatures.add(MethodSignature.forComponentMethod(method, componentType, ComponentImplementation.this.types))) continue;
                this.addMethod(MethodSpecKind.COMPONENT_METHOD, ((ComponentBindingExpressions)ComponentImplementation.this.bindingExpressionsProvider.get()).getComponentMethod(method));
            }
        }

        private void addChildComponents() {
            for (BindingGraph subgraph : ComponentImplementation.this.graph.subgraphs()) {
                this.addType(TypeSpecKind.SUBCOMPONENT, ComponentImplementation.this.childComponentImplementationFactory.create(subgraph).generate());
            }
        }

        private void addShards() {
            for (ShardImplementation shard : ImmutableSet.copyOf((Collection)ComponentImplementation.this.shardsByBinding.values())) {
                if (!ComponentImplementation.this.shardFieldsByImplementation.containsKey(shard)) continue;
                this.addField(FieldSpecKind.COMPONENT_SHARD_FIELD, (FieldSpec)ComponentImplementation.this.shardFieldsByImplementation.get(shard));
                TypeSpec shardTypeSpec = shard.generate();
                this.addType(TypeSpecKind.COMPONENT_SHARD_TYPE, shardTypeSpec);
            }
        }

        private void addConstructorAndInitializationMethods() {
            MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
            ImmutableList parameters = this.constructorParameters.values().asList();
            if (this.isComponentShard()) {
                this.componentFieldsByImplementation().forEach((componentImplementation, field) -> {
                    if (componentImplementation.equals(ComponentImplementation.this)) {
                        this.addField(FieldSpecKind.COMPONENT_REQUIREMENT_FIELD, field.toBuilder().initializer("this", new Object[0]).build());
                    } else {
                        this.addField(FieldSpecKind.COMPONENT_REQUIREMENT_FIELD, (FieldSpec)field);
                        constructor.addStatement("this.$1N = $1N", new Object[]{field});
                        constructor.addParameter(field.type, field.name, new Modifier[0]);
                    }
                });
                constructor.addCode(CodeBlocks.concat(this.componentRequirementInitializations));
            }
            constructor.addParameters((Iterable)parameters);
            CodeBlock args = CodeBlocks.parameterNames((Iterable<ParameterSpec>)parameters);
            ImmutableList<MethodSpec> initializationMethods = this.createPartitionedMethods("initialize", (Iterable<ParameterSpec>)ComponentImplementation.makeFinal((List)parameters), this.initializations, (Function<String, MethodSpec.Builder>)((Function)methodName -> MethodSpec.methodBuilder((String)methodName).addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0]))));
            for (MethodSpec initializationMethod : initializationMethods) {
                constructor.addStatement("$N($L)", new Object[]{initializationMethod, args});
                this.addMethod(MethodSpecKind.INITIALIZE_METHOD, initializationMethod);
            }
            if (this.isComponentShard()) {
                constructor.addCode(CodeBlocks.concat(ComponentImplementation.this.shardInitializations));
            } else {
                CodeBlock componentArgs = CodeBlocks.parameterNames((Iterable<ParameterSpec>)((ComponentImplementation)ComponentImplementation.this).componentShard.constructorParameters.values().asList());
                FieldSpec shardField = (FieldSpec)ComponentImplementation.this.shardFieldsByImplementation.get(this);
                ComponentImplementation.this.shardInitializations.add(CodeBlock.of((String)"$N = new $T($L);", (Object[])new Object[]{shardField, this.name, componentArgs}));
            }
            this.addMethod(MethodSpecKind.CONSTRUCTOR, constructor.build());
        }

        private void addCancellationListenerImplementation() {
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)ComponentImplementation.CANCELLATION_LISTENER_METHOD_NAME).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(MAY_INTERRUPT_IF_RUNNING_PARAM);
            if (this.isComponentShard()) {
                methodBuilder.addCode(CodeBlocks.concat((Iterable<CodeBlock>)ImmutableList.copyOf((Collection)ComponentImplementation.this.shardCancellations).reverse()));
            } else if (!this.cancellations.isEmpty()) {
                ComponentImplementation.this.shardCancellations.add(CodeBlock.of((String)"$N.$N($N);", (Object[])new Object[]{ComponentImplementation.this.shardFieldsByImplementation.get(this), ComponentImplementation.CANCELLATION_LISTENER_METHOD_NAME, MAY_INTERRUPT_IF_RUNNING_PARAM}));
            }
            ImmutableList cancellationStatements = ImmutableList.copyOf(this.cancellations.values()).reverse();
            if (cancellationStatements.size() < 100) {
                methodBuilder.addCode(CodeBlocks.concat((Iterable<CodeBlock>)cancellationStatements)).build();
            } else {
                ImmutableList<MethodSpec> cancelProducersMethods = this.createPartitionedMethods("cancelProducers", (Iterable<ParameterSpec>)ImmutableList.of((Object)MAY_INTERRUPT_IF_RUNNING_PARAM), (List<CodeBlock>)cancellationStatements, (Function<String, MethodSpec.Builder>)((Function)methodName -> MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE})));
                for (MethodSpec cancelProducersMethod : cancelProducersMethods) {
                    methodBuilder.addStatement("$N($N)", new Object[]{cancelProducersMethod, MAY_INTERRUPT_IF_RUNNING_PARAM});
                    this.addMethod(MethodSpecKind.CANCELLATION_LISTENER_METHOD, cancelProducersMethod);
                }
            }
            if (this.isComponentShard()) {
                this.cancelParentStatement().ifPresent(arg_0 -> ((MethodSpec.Builder)methodBuilder).addCode(arg_0));
            }
            this.addMethod(MethodSpecKind.CANCELLATION_LISTENER_METHOD, methodBuilder.build());
        }

        private Optional<CodeBlock> cancelParentStatement() {
            if (!this.shouldPropagateCancellationToParent()) {
                return Optional.empty();
            }
            return Optional.of(CodeBlock.builder().addStatement("$L.$N($N)", new Object[]{((ComponentImplementation)ComponentImplementation.this.parent.get()).componentFieldReference(), ComponentImplementation.CANCELLATION_LISTENER_METHOD_NAME, MAY_INTERRUPT_IF_RUNNING_PARAM}).build());
        }

        private boolean shouldPropagateCancellationToParent() {
            return ComponentImplementation.this.parent.isPresent() && ((ComponentImplementation)ComponentImplementation.this.parent.get()).componentDescriptor().cancellationPolicy().map(policy -> policy.fromSubcomponents().equals((Object)CancellationPolicy.Propagation.PROPAGATE)).orElse(false) != false;
        }

        private ImmutableList<MethodSpec> createPartitionedMethods(String methodName, Iterable<ParameterSpec> parameters, List<CodeBlock> statements, Function<String, MethodSpec.Builder> methodBuilderCreator) {
            return (ImmutableList)Lists.partition(statements, (int)100).stream().map(partition -> ((MethodSpec.Builder)methodBuilderCreator.apply((Object)this.getUniqueMethodName(methodName))).addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameters(parameters).addCode(CodeBlocks.concat(partition)).build()).collect(DaggerStreams.toImmutableList());
        }
    }

    public static enum TypeSpecKind {
        PRESENT_FACTORY,
        COMPONENT_CREATOR,
        COMPONENT_PROVISION_FACTORY,
        COMPONENT_SHARD_TYPE,
        SUBCOMPONENT;

    }

    public static enum MethodSpecKind {
        CONSTRUCTOR,
        BUILDER_METHOD,
        PRIVATE_METHOD,
        INITIALIZE_METHOD,
        COMPONENT_METHOD,
        MEMBERS_INJECTION_METHOD,
        ABSENT_OPTIONAL_METHOD,
        CANCELLATION_LISTENER_METHOD;

    }

    public static enum FieldSpecKind {
        COMPONENT_SHARD_FIELD,
        COMPONENT_REQUIREMENT_FIELD,
        PRIVATE_METHOD_SCOPED_FIELD,
        PRIVATE_METHOD_CACHED_PROVIDER_FIELD,
        FRAMEWORK_FIELD,
        ABSENT_OPTIONAL_FIELD;

    }

    public static interface ChildComponentImplementationFactory {
        public ComponentImplementation create(BindingGraph var1);
    }
}

