/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.CodeBlock;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.writing.ComponentBindingExpressions;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.FrameworkFieldInitializer;
import dagger.shaded.auto.common.MoreTypes;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class MembersInjectorProviderCreationExpression
implements FrameworkFieldInitializer.FrameworkInstanceCreationExpression {
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final ProvisionBinding binding;

    @AssistedInject
    MembersInjectorProviderCreationExpression(@Assisted ProvisionBinding binding, ComponentImplementation componentImplementation, ComponentBindingExpressions componentBindingExpressions) {
        this.binding = (ProvisionBinding)Preconditions.checkNotNull((Object)binding);
        this.shardImplementation = componentImplementation.shardImplementation(binding);
        this.componentBindingExpressions = (ComponentBindingExpressions)Preconditions.checkNotNull((Object)componentBindingExpressions);
    }

    @Override
    public CodeBlock creationExpression() {
        CodeBlock membersInjector;
        TypeMirror membersInjectedType = (TypeMirror)Iterables.getOnlyElement(MoreTypes.asDeclared(this.binding.key().type()).getTypeArguments());
        boolean castThroughRawType = false;
        if (this.binding.injectionSites().isEmpty()) {
            membersInjector = CodeBlock.of((String)"$T.<$T>noOp()", (Object[])new Object[]{TypeNames.MEMBERS_INJECTORS, membersInjectedType});
        } else {
            TypeElement injectedTypeElement = MoreTypes.asTypeElement(membersInjectedType);
            while (!this.hasLocalInjectionSites(injectedTypeElement)) {
                castThroughRawType = true;
                injectedTypeElement = MoreTypes.asTypeElement(injectedTypeElement.getSuperclass());
            }
            membersInjector = CodeBlock.of((String)"$T.create($L)", (Object[])new Object[]{SourceFiles.membersInjectorNameForType(injectedTypeElement), this.componentBindingExpressions.getCreateMethodArgumentsCodeBlock(this.binding, this.shardImplementation.name())});
        }
        CodeBlock providerExpression = CodeBlock.of((String)"$T.create($L)", (Object[])new Object[]{TypeNames.INSTANCE_FACTORY, membersInjector});
        return castThroughRawType ? CodeBlock.of((String)"($T) $L", (Object[])new Object[]{TypeNames.INSTANCE_FACTORY, providerExpression}) : providerExpression;
    }

    private boolean hasLocalInjectionSites(TypeElement injectedTypeElement) {
        return this.binding.injectionSites().stream().anyMatch(injectionSite -> injectionSite.element().getEnclosingElement().equals(injectedTypeElement));
    }

    @Override
    public boolean useSwitchingProvider() {
        return !this.binding.injectionSites().isEmpty();
    }

    @AssistedFactory
    static interface Factory {
        public MembersInjectorProviderCreationExpression create(ProvisionBinding var1);
    }
}

