/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.shaded.androidx.room.compiler.processing.XMessager;
import dagger.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.shaded.auto.common.MoreTypes;
import java.util.HashSet;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;

final class AssistedInjectProcessingStep
extends TypeCheckingProcessingStep<XExecutableElement> {
    private final DaggerTypes types;
    private final XMessager messager;
    private final XProcessingEnv processingEnv;

    @Inject
    AssistedInjectProcessingStep(DaggerTypes types, XMessager messager2, XProcessingEnv processingEnv) {
        this.types = types;
        this.messager = messager2;
        this.processingEnv = processingEnv;
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return ImmutableSet.of((Object)TypeNames.ASSISTED_INJECT);
    }

    @Override
    protected void process(XExecutableElement assistedInjectElement, ImmutableSet<ClassName> annotations2) {
        new AssistedInjectValidator().validate(assistedInjectElement).printMessagesTo(this.messager);
    }

    private final class AssistedInjectValidator {
        private AssistedInjectValidator() {
        }

        ValidationReport validate(XExecutableElement constructor) {
            ExecutableElement javaConstructor = XConverters.toJavac(constructor);
            Preconditions.checkState((javaConstructor.getKind() == ElementKind.CONSTRUCTOR ? 1 : 0) != 0);
            ValidationReport.Builder report = ValidationReport.about(constructor);
            DeclaredType assistedInjectType = MoreTypes.asDeclared(DaggerElements.closestEnclosingTypeElement(javaConstructor).asType());
            ImmutableList<AssistedInjectionAnnotations.AssistedParameter> assistedParameters = AssistedInjectionAnnotations.assistedInjectAssistedParameters(assistedInjectType, AssistedInjectProcessingStep.this.types);
            HashSet<AssistedInjectionAnnotations.AssistedParameter> uniqueAssistedParameters = new HashSet<AssistedInjectionAnnotations.AssistedParameter>();
            for (AssistedInjectionAnnotations.AssistedParameter assistedParameter : assistedParameters) {
                if (uniqueAssistedParameters.add(assistedParameter)) continue;
                report.addError(String.format("@AssistedInject constructor has duplicate @Assisted type: %s. Consider setting an identifier on the parameter by using @Assisted(\"identifier\") in both the factory and @AssistedInject constructor", assistedParameter), XConverters.toXProcessing(assistedParameter.variableElement(), AssistedInjectProcessingStep.this.processingEnv));
            }
            return report.build();
        }
    }
}

