/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.kotlin;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.kotlin.KotlinMetadata;
import dagger.internal.codegen.kotlin.KotlinMetadataFactory;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlinx.metadata.Flag;

public final class KotlinMetadataUtil {
    private final KotlinMetadataFactory metadataFactory;

    @Inject
    KotlinMetadataUtil(KotlinMetadataFactory metadataFactory) {
        this.metadataFactory = metadataFactory;
    }

    public boolean hasMetadata(Element element) {
        return MoreElements.isAnnotationPresent(DaggerElements.closestEnclosingTypeElement(element), Metadata.class);
    }

    public ImmutableCollection<? extends AnnotationMirror> getSyntheticPropertyAnnotations(VariableElement fieldElement, Class<? extends Annotation> annotationType) {
        return (ImmutableCollection)this.metadataFactory.create(fieldElement).getSyntheticAnnotationMethod(fieldElement).map(methodElement -> AnnotationMirrors.getAnnotatedAnnotations(methodElement, annotationType).asList()).orElse(ImmutableList.of());
    }

    public boolean isMissingSyntheticPropertyForAnnotations(VariableElement fieldElement) {
        return this.metadataFactory.create(fieldElement).isMissingSyntheticAnnotationMethod(fieldElement);
    }

    public boolean isObjectClass(TypeElement typeElement2) {
        return this.hasMetadata(typeElement2) && this.metadataFactory.create(typeElement2).classMetadata().flags(Flag.Class.IS_OBJECT);
    }

    public boolean isDataClass(TypeElement typeElement2) {
        return this.hasMetadata(typeElement2) && this.metadataFactory.create(typeElement2).classMetadata().flags(Flag.Class.IS_DATA);
    }

    public boolean isCompanionObjectClass(TypeElement typeElement2) {
        return this.hasMetadata(typeElement2) && this.metadataFactory.create(typeElement2).classMetadata().flags(Flag.Class.IS_COMPANION_OBJECT);
    }

    public boolean isObjectOrCompanionObjectClass(TypeElement typeElement2) {
        return this.isObjectClass(typeElement2) || this.isCompanionObjectClass(typeElement2);
    }

    public boolean hasEnclosedCompanionObject(TypeElement typeElement2) {
        return this.hasMetadata(typeElement2) && this.metadataFactory.create(typeElement2).classMetadata().companionObjectName().isPresent();
    }

    public TypeElement getEnclosedCompanionObject(TypeElement typeElement2) {
        return this.metadataFactory.create(typeElement2).classMetadata().companionObjectName().map(companionObjectName -> (TypeElement)ElementFilter.typesIn(typeElement2.getEnclosedElements()).stream().filter(innerType -> innerType.getSimpleName().contentEquals((CharSequence)companionObjectName)).collect(DaggerCollectors.onlyElement())).get();
    }

    public boolean isVisibilityPrivate(TypeElement typeElement2) {
        return this.hasMetadata(typeElement2) && this.metadataFactory.create(typeElement2).classMetadata().flags(Flag.IS_PRIVATE);
    }

    public boolean isVisibilityInternal(TypeElement type2) {
        return this.hasMetadata(type2) && this.metadataFactory.create(type2).classMetadata().flags(Flag.IS_INTERNAL);
    }

    public boolean isVisibilityInternal(ExecutableElement method) {
        return this.hasMetadata(method) && this.metadataFactory.create(method).getFunctionMetadata(method).flags(Flag.IS_INTERNAL);
    }

    public Optional<ExecutableElement> getPropertyGetter(VariableElement fieldElement) {
        return this.metadataFactory.create(fieldElement).getPropertyGetter(fieldElement);
    }

    public boolean containsConstructorWithDefaultParam(TypeElement typeElement2) {
        return this.hasMetadata(typeElement2) && this.metadataFactory.create(typeElement2).containsConstructorWithDefaultParam();
    }

    public ImmutableMap<String, String> getAllMethodNamesBySignature(TypeElement element) {
        Preconditions.checkState((boolean)this.hasMetadata(element), (Object)"Can not call getAllMethodNamesBySignature for non-Kotlin class");
        return (ImmutableMap)this.metadataFactory.create(element).classMetadata().functionsBySignature().values().stream().collect(DaggerStreams.toImmutableMap(KotlinMetadata.FunctionMetadata::signature, KotlinMetadata.BaseMetadata::name));
    }

    public static boolean isJvmStaticPresent(ExecutableElement element) {
        return MoreElements.isAnnotationPresent(element, JvmStatic.class);
    }
}

