/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.shaded.androidx.room.compiler.processing.XAnnotationKt;
import dagger.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.shaded.androidx.room.compiler.processing.XTypeKt;
import java.util.List;
import javax.inject.Inject;

public final class MapKeyValidator {
    private final DaggerElements elements;

    @Inject
    MapKeyValidator(DaggerElements elements) {
        this.elements = elements;
    }

    public ValidationReport validate(XTypeElement element) {
        ValidationReport.Builder builder = ValidationReport.about(element);
        List<XMethodElement> members = element.getDeclaredMethods();
        if (members.isEmpty()) {
            builder.addError("Map key annotations must have members", element);
        } else if (XAnnotationKt.get(element.getAnnotation(TypeNames.MAP_KEY), "unwrapValue", Boolean.class).booleanValue()) {
            if (members.size() > 1) {
                builder.addError("Map key annotations with unwrapped values must have exactly one member", element);
            } else if (XTypeKt.isArray(members.get(0).getReturnType())) {
                builder.addError("Map key annotations with unwrapped values cannot use arrays", element);
            }
        } else if (this.autoAnnotationIsMissing()) {
            builder.addError("@AutoAnnotation is a necessary dependency if @MapKey(unwrapValue = false). Add a dependency on com.google.auto.value:auto-value:<current version>");
        }
        return builder.build();
    }

    private boolean autoAnnotationIsMissing() {
        return this.elements.getTypeElement("com.google.auto.value.AutoAnnotation") == null;
    }
}

