/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeTraverser;
import dagger.Component;
import dagger.internal.codegen.AutoValue_BindingGraph;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DelegateDeclaration;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.InjectBindingRegistry;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.MultibindingDeclaration;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.Scope;
import dagger.producers.ProductionComponent;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

abstract class BindingGraph {
    private static final TreeTraverser<BindingGraph> SUBGRAPH_TRAVERSER = new TreeTraverser<BindingGraph>(){

        public Iterable<BindingGraph> children(BindingGraph node) {
            return node.subgraphs().values();
        }
    };

    BindingGraph() {
    }

    abstract ComponentDescriptor componentDescriptor();

    abstract ImmutableMap<BindingKey, ResolvedBindings> resolvedBindings();

    abstract ImmutableMap<ExecutableElement, BindingGraph> subgraphs();

    abstract ImmutableSet<ModuleDescriptor> ownedModules();

    ImmutableSet<TypeElement> ownedModuleTypes() {
        return FluentIterable.from(this.ownedModules()).transform(ModuleDescriptor.getModuleElement()).toSet();
    }

    ImmutableSet<TypeElement> componentRequirements() {
        return SUBGRAPH_TRAVERSER.preOrderTraversal((Object)this).transformAndConcat((Function)new Function<BindingGraph, Iterable<ResolvedBindings>>(){

            public Iterable<ResolvedBindings> apply(BindingGraph input) {
                return input.resolvedBindings().values();
            }
        }).transformAndConcat((Function)new Function<ResolvedBindings, Set<ContributionBinding>>(){

            public Set<ContributionBinding> apply(ResolvedBindings input) {
                return input.contributionBindings();
            }
        }).transformAndConcat((Function)new Function<ContributionBinding, Set<TypeElement>>(){

            public Set<TypeElement> apply(ContributionBinding input) {
                return input.bindingElement().getModifiers().contains((Object)Modifier.STATIC) ? ImmutableSet.of() : input.contributedBy().asSet();
            }
        }).filter(Predicates.in(this.ownedModuleTypes())).append(this.componentDescriptor().dependencies()).toSet();
    }

    ImmutableSet<ComponentDescriptor> componentDescriptors() {
        return SUBGRAPH_TRAVERSER.preOrderTraversal((Object)this).transform((Function)new Function<BindingGraph, ComponentDescriptor>(){

            public ComponentDescriptor apply(BindingGraph graph) {
                return graph.componentDescriptor();
            }
        }).toSet();
    }

    ImmutableSet<TypeElement> availableDependencies() {
        return new ImmutableSet.Builder().addAll(this.componentDescriptor().transitiveModuleTypes()).addAll(this.componentDescriptor().dependencies()).build();
    }

    static final class Factory {
        private final Elements elements;
        private final InjectBindingRegistry injectBindingRegistry;
        private final Key.Factory keyFactory;
        private final ProvisionBinding.Factory provisionBindingFactory;
        private final ProductionBinding.Factory productionBindingFactory;

        Factory(Elements elements, InjectBindingRegistry injectBindingRegistry, Key.Factory keyFactory, ProvisionBinding.Factory provisionBindingFactory, ProductionBinding.Factory productionBindingFactory) {
            this.elements = elements;
            this.injectBindingRegistry = injectBindingRegistry;
            this.keyFactory = keyFactory;
            this.provisionBindingFactory = provisionBindingFactory;
            this.productionBindingFactory = productionBindingFactory;
        }

        BindingGraph create(ComponentDescriptor componentDescriptor) {
            return this.create((Optional<Resolver>)Optional.absent(), componentDescriptor);
        }

        private BindingGraph create(Optional<Resolver> parentResolver, ComponentDescriptor componentDescriptor) {
            ImmutableSet.Builder explicitBindingsBuilder = ImmutableSet.builder();
            ImmutableSet.Builder delegatesBuilder = ImmutableSet.builder();
            TypeElement componentDefinitionType = componentDescriptor.componentDefinitionType();
            explicitBindingsBuilder.add((Object)this.provisionBindingFactory.forComponent(componentDefinitionType));
            Optional componentMirror = MoreElements.getAnnotationMirror(componentDefinitionType, Component.class).or(MoreElements.getAnnotationMirror(componentDefinitionType, ProductionComponent.class));
            ImmutableSet<TypeElement> componentDependencyTypes = componentMirror.isPresent() ? MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentDependencies((AnnotationMirror)componentMirror.get())) : ImmutableSet.of();
            for (TypeElement componentDependency : componentDependencyTypes) {
                explicitBindingsBuilder.add((Object)this.provisionBindingFactory.forComponent(componentDependency));
                List<ExecutableElement> dependencyMethods = ElementFilter.methodsIn(this.elements.getAllMembers(componentDependency));
                for (ExecutableElement method : dependencyMethods) {
                    if (!ComponentDescriptor.isComponentContributionMethod(this.elements, method)) continue;
                    explicitBindingsBuilder.add((Object)(componentDescriptor.kind().equals((Object)ComponentDescriptor.Kind.PRODUCTION_COMPONENT) && ComponentDescriptor.isComponentProductionMethod(this.elements, method) ? this.productionBindingFactory.forComponentMethod(method) : this.provisionBindingFactory.forComponentMethod(method)));
                }
            }
            for (ComponentDescriptor.ComponentMethodDescriptor subcomponentMethodDescriptor : Iterables.filter((Iterable)componentDescriptor.subcomponents().keySet(), ComponentDescriptor.ComponentMethodDescriptor.isOfKind(ComponentDescriptor.ComponentMethodKind.SUBCOMPONENT_BUILDER, ComponentDescriptor.ComponentMethodKind.PRODUCTION_SUBCOMPONENT_BUILDER))) {
                explicitBindingsBuilder.add((Object)this.provisionBindingFactory.forSubcomponentBuilderMethod(subcomponentMethodDescriptor.methodElement(), componentDescriptor.componentDefinitionType()));
            }
            ImmutableSet.Builder multibindingDeclarations = ImmutableSet.builder();
            for (ModuleDescriptor moduleDescriptor : componentDescriptor.transitiveModules()) {
                explicitBindingsBuilder.addAll(moduleDescriptor.bindings());
                multibindingDeclarations.addAll(moduleDescriptor.multibindingDeclarations());
                delegatesBuilder.addAll(moduleDescriptor.delegateDeclarations());
            }
            Resolver requestResolver = new Resolver(parentResolver, componentDescriptor, Key.indexByKey(explicitBindingsBuilder.build()), Key.indexByKey(multibindingDeclarations.build()), Key.indexByKey(delegatesBuilder.build()));
            for (ComponentDescriptor.ComponentMethodDescriptor componentMethod : componentDescriptor.componentMethods()) {
                Optional<DependencyRequest> componentMethodRequest = componentMethod.dependencyRequest();
                if (!componentMethodRequest.isPresent()) continue;
                requestResolver.resolve((DependencyRequest)componentMethodRequest.get());
            }
            ImmutableMap.Builder subgraphsBuilder = ImmutableMap.builder();
            for (Map.Entry subcomponentEntry : componentDescriptor.subcomponents().entrySet()) {
                subgraphsBuilder.put((Object)((ComponentDescriptor.ComponentMethodDescriptor)subcomponentEntry.getKey()).methodElement(), (Object)this.create((Optional<Resolver>)Optional.of((Object)requestResolver), (ComponentDescriptor)subcomponentEntry.getValue()));
            }
            for (ResolvedBindings resolvedBindings : requestResolver.getResolvedBindings().values()) {
                Verify.verify((boolean)resolvedBindings.owningComponent().equals(componentDescriptor), (String)"%s is not owned by %s", (Object[])new Object[]{resolvedBindings, componentDescriptor});
            }
            return new AutoValue_BindingGraph(componentDescriptor, requestResolver.getResolvedBindings(), (ImmutableMap<ExecutableElement, BindingGraph>)subgraphsBuilder.build(), requestResolver.getOwnedModules());
        }

        private final class Resolver {
            final Optional<Resolver> parentResolver;
            final ComponentDescriptor componentDescriptor;
            final ImmutableSetMultimap<Key, ContributionBinding> explicitBindings;
            final ImmutableSet<ContributionBinding> explicitBindingsSet;
            final ImmutableSetMultimap<Key, ContributionBinding> explicitMultibindings;
            final ImmutableSetMultimap<Key, MultibindingDeclaration> multibindingDeclarations;
            final ImmutableSetMultimap<Key, DelegateDeclaration> delegateDeclarations;
            final Map<BindingKey, ResolvedBindings> resolvedBindings;
            final Deque<BindingKey> cycleStack = new ArrayDeque<BindingKey>();
            final Cache<BindingKey, Boolean> dependsOnLocalMultibindingsCache = CacheBuilder.newBuilder().build();
            final Cache<Binding, Boolean> bindingDependsOnLocalMultibindingsCache = CacheBuilder.newBuilder().build();

            Resolver(Optional<Resolver> parentResolver, ComponentDescriptor componentDescriptor, ImmutableSetMultimap<Key, ContributionBinding> explicitBindings, ImmutableSetMultimap<Key, MultibindingDeclaration> multibindingDeclarations, ImmutableSetMultimap<Key, DelegateDeclaration> delegateDeclarations) {
                assert (parentResolver != null);
                this.parentResolver = parentResolver;
                assert (componentDescriptor != null);
                this.componentDescriptor = componentDescriptor;
                assert (explicitBindings != null);
                this.explicitBindings = explicitBindings;
                this.explicitBindingsSet = ImmutableSet.copyOf((Collection)explicitBindings.values());
                assert (multibindingDeclarations != null);
                this.multibindingDeclarations = multibindingDeclarations;
                assert (delegateDeclarations != null);
                this.delegateDeclarations = delegateDeclarations;
                this.resolvedBindings = Maps.newLinkedHashMap();
                ImmutableSetMultimap.Builder explicitMultibindingsBuilder = ImmutableSetMultimap.builder();
                for (ContributionBinding binding : this.explicitBindingsSet) {
                    if (!binding.key().bindingMethod().isPresent()) continue;
                    explicitMultibindingsBuilder.put((Object)binding.key().withoutBindingMethod(), (Object)binding);
                }
                this.explicitMultibindings = explicitMultibindingsBuilder.build();
            }

            ResolvedBindings lookUpBindings(DependencyRequest request) {
                BindingKey bindingKey = request.bindingKey();
                Key key = bindingKey.key();
                switch (bindingKey.kind()) {
                    case CONTRIBUTION: {
                        LinkedHashSet<ContributionBinding> contributionBindings = new LinkedHashSet<ContributionBinding>();
                        LinkedHashSet<ContributionBinding> multibindings = new LinkedHashSet<ContributionBinding>();
                        ImmutableSet.Builder multibindingDeclarationsBuilder = ImmutableSet.builder();
                        ImmutableSet.Builder delegateDeclarationsBuilder = ImmutableSet.builder();
                        contributionBindings.addAll((Collection<ContributionBinding>)this.getExplicitBindings(key));
                        multibindings.addAll((Collection<ContributionBinding>)this.getExplicitMultibindings(key));
                        multibindingDeclarationsBuilder.addAll(this.getMultibindingDeclarations(key));
                        delegateDeclarationsBuilder.addAll(this.getDelegateDeclarations(key));
                        Optional<Key> implicitSetKey = Factory.this.keyFactory.implicitSetKeyFromProduced(key);
                        contributionBindings.addAll((Collection<ContributionBinding>)this.getExplicitBindings(implicitSetKey));
                        multibindings.addAll((Collection<ContributionBinding>)this.getExplicitMultibindings(implicitSetKey));
                        multibindingDeclarationsBuilder.addAll(this.getMultibindingDeclarations(implicitSetKey));
                        delegateDeclarationsBuilder.addAll(this.getDelegateDeclarations(implicitSetKey));
                        ImmutableSet multibindingDeclarations = multibindingDeclarationsBuilder.build();
                        ImmutableSet delegateDeclarations = delegateDeclarationsBuilder.build();
                        contributionBindings.addAll((Collection<ContributionBinding>)this.delegateBindings((ImmutableSet<DelegateDeclaration>)delegateDeclarations));
                        Optional<Key> implicitMapProviderKey = Factory.this.keyFactory.implicitMapProviderKeyFrom(key);
                        ImmutableSet<ContributionBinding> explicitProviderMapBindings = this.getExplicitMultibindings(implicitMapProviderKey);
                        ImmutableSet<MultibindingDeclaration> explicitProviderMultibindingDeclarations = this.getMultibindingDeclarations(implicitMapProviderKey);
                        Optional<Key> implicitMapProducerKey = Factory.this.keyFactory.implicitMapProducerKeyFrom(key);
                        ImmutableSet<ContributionBinding> explicitProducerMapBindings = this.getExplicitMultibindings(implicitMapProducerKey);
                        ImmutableSet<MultibindingDeclaration> explicitProducerMultibindingDeclarations = this.getMultibindingDeclarations(implicitMapProducerKey);
                        if (!explicitProducerMapBindings.isEmpty() || !explicitProducerMultibindingDeclarations.isEmpty()) {
                            contributionBindings.add(Factory.this.productionBindingFactory.syntheticMapOfValuesOrProducedBinding(request));
                        } else if (!explicitProviderMapBindings.isEmpty() || !explicitProviderMultibindingDeclarations.isEmpty()) {
                            contributionBindings.add(Factory.this.provisionBindingFactory.syntheticMapOfValuesBinding(request));
                        }
                        Iterable multibindingsAndDeclarations = Iterables.concat(multibindings, (Iterable)multibindingDeclarations);
                        if (Iterables.any((Iterable)multibindingsAndDeclarations, BindingType.isOfType(BindingType.PRODUCTION))) {
                            contributionBindings.add(Factory.this.productionBindingFactory.syntheticMultibinding(request, multibindings));
                        } else if (Iterables.any((Iterable)multibindingsAndDeclarations, BindingType.isOfType(BindingType.PROVISION))) {
                            contributionBindings.add(Factory.this.provisionBindingFactory.syntheticMultibinding(request, multibindings));
                        }
                        if (contributionBindings.isEmpty() && multibindings.isEmpty() && multibindingDeclarations.isEmpty() && delegateDeclarations.isEmpty()) {
                            contributionBindings.addAll(Factory.this.injectBindingRegistry.getOrFindProvisionBinding(key).asSet());
                        }
                        return ResolvedBindings.forContributionBindings(bindingKey, this.componentDescriptor, this.indexBindingsByOwningComponent(request, (Iterable<? extends ContributionBinding>)ImmutableSet.copyOf(contributionBindings)), (Iterable<MultibindingDeclaration>)multibindingDeclarations);
                    }
                    case MEMBERS_INJECTION: {
                        Optional<MembersInjectionBinding> binding = Factory.this.injectBindingRegistry.getOrFindMembersInjectionBinding(key);
                        return binding.isPresent() ? ResolvedBindings.forMembersInjectionBinding(bindingKey, this.componentDescriptor, (MembersInjectionBinding)binding.get()) : ResolvedBindings.noBindings(bindingKey, this.componentDescriptor);
                    }
                }
                throw new AssertionError();
            }

            private ImmutableSet<ContributionBinding> delegateBindings(ImmutableSet<DelegateDeclaration> delegateDeclarations) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (DelegateDeclaration delegateDeclaration : delegateDeclarations) {
                    DependencyRequest delegateRequest = delegateDeclaration.delegateRequest();
                    ResolvedBindings resolvedDelegate = this.lookUpBindings(delegateRequest);
                    block5: for (ContributionBinding explicitDelegate : resolvedDelegate.contributionBindings()) {
                        switch (explicitDelegate.bindingType()) {
                            case PRODUCTION: {
                                builder.add((Object)Factory.this.productionBindingFactory.delegate(delegateDeclaration, (ProductionBinding)explicitDelegate));
                                continue block5;
                            }
                            case PROVISION: {
                                builder.add((Object)Factory.this.provisionBindingFactory.delegate(delegateDeclaration, (ProvisionBinding)explicitDelegate));
                                continue block5;
                            }
                        }
                        throw new AssertionError();
                    }
                }
                return builder.build();
            }

            private ImmutableSetMultimap<ComponentDescriptor, ContributionBinding> indexBindingsByOwningComponent(DependencyRequest request, Iterable<? extends ContributionBinding> bindings) {
                ImmutableSetMultimap.Builder index = ImmutableSetMultimap.builder();
                for (ContributionBinding contributionBinding : bindings) {
                    index.put((Object)this.getOwningComponent(request, contributionBinding), (Object)contributionBinding);
                }
                return index.build();
            }

            private ComponentDescriptor getOwningComponent(DependencyRequest request, ContributionBinding binding) {
                return this.isResolvedInParent(request, binding) && !new MultibindingDependencies().dependsOnLocalMultibindings(binding) ? ((Resolver)this.getOwningResolver((ContributionBinding)binding).get()).componentDescriptor : this.componentDescriptor;
            }

            private boolean isResolvedInParent(DependencyRequest request, ContributionBinding binding) {
                Optional<Resolver> owningResolver = this.getOwningResolver(binding);
                if (owningResolver.isPresent() && !((Resolver)owningResolver.get()).equals(this)) {
                    ((Resolver)this.parentResolver.get()).resolve(request);
                    return true;
                }
                return false;
            }

            private Optional<Resolver> getOwningResolver(ContributionBinding binding) {
                if (binding.scope().isPresent() && ((Scope)binding.scope().get()).equals(Scope.reusableScope(Factory.this.elements))) {
                    for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                        if (!requestResolver.resolvedBindings.containsKey(BindingKey.create(BindingKey.Kind.CONTRIBUTION, binding.key()))) continue;
                        return Optional.of((Object)requestResolver);
                    }
                    return Optional.absent();
                }
                for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                    if (!requestResolver.explicitBindingsSet.contains((Object)binding)) continue;
                    return Optional.of((Object)requestResolver);
                }
                Optional<Scope> bindingScope = binding.scope();
                if (bindingScope.isPresent()) {
                    for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                        if (!requestResolver.componentDescriptor.scopes().contains(bindingScope.get())) continue;
                        return Optional.of((Object)requestResolver);
                    }
                }
                return Optional.absent();
            }

            private ImmutableList<Resolver> getResolverLineage() {
                ArrayList resolverList = Lists.newArrayList();
                Optional<Resolver> currentResolver = Optional.of((Object)this);
                while (currentResolver.isPresent()) {
                    resolverList.add(currentResolver.get());
                    currentResolver = ((Resolver)currentResolver.get()).parentResolver;
                }
                return ImmutableList.copyOf((Collection)Lists.reverse((List)resolverList));
            }

            private ImmutableSet<ContributionBinding> getExplicitBindings(Key requestKey) {
                ImmutableSet.Builder explicitBindingsForKey = ImmutableSet.builder();
                for (Resolver resolver : this.getResolverLineage()) {
                    explicitBindingsForKey.addAll((Iterable)resolver.explicitBindings.get((Object)requestKey));
                }
                return explicitBindingsForKey.build();
            }

            private ImmutableSet<ContributionBinding> getExplicitBindings(Optional<Key> optionalKey) {
                return optionalKey.isPresent() ? this.getExplicitBindings((Key)optionalKey.get()) : ImmutableSet.of();
            }

            private ImmutableSet<ContributionBinding> getExplicitMultibindings(Key requestKey) {
                ImmutableSet.Builder explicitMultibindingsForKey = ImmutableSet.builder();
                for (Resolver resolver : this.getResolverLineage()) {
                    explicitMultibindingsForKey.addAll((Iterable)resolver.explicitMultibindings.get((Object)requestKey));
                }
                return explicitMultibindingsForKey.build();
            }

            private ImmutableSet<ContributionBinding> getExplicitMultibindings(Optional<Key> optionalKey) {
                return optionalKey.isPresent() ? this.getExplicitMultibindings((Key)optionalKey.get()) : ImmutableSet.of();
            }

            private ImmutableSet<MultibindingDeclaration> getMultibindingDeclarations(Key key) {
                ImmutableSet.Builder multibindingDeclarations = ImmutableSet.builder();
                for (Resolver resolver : this.getResolverLineage()) {
                    multibindingDeclarations.addAll((Iterable)resolver.multibindingDeclarations.get((Object)key));
                }
                return multibindingDeclarations.build();
            }

            private ImmutableSet<MultibindingDeclaration> getMultibindingDeclarations(Optional<Key> optionalKey) {
                return optionalKey.isPresent() ? this.getMultibindingDeclarations((Key)optionalKey.get()) : ImmutableSet.of();
            }

            private ImmutableSet<DelegateDeclaration> getDelegateDeclarations(Key key) {
                ImmutableSet.Builder delegateDeclarations = ImmutableSet.builder();
                for (Resolver resolver : this.getResolverLineage()) {
                    delegateDeclarations.addAll((Iterable)resolver.delegateDeclarations.get((Object)key));
                }
                return delegateDeclarations.build();
            }

            private ImmutableSet<DelegateDeclaration> getDelegateDeclarations(Optional<Key> optionalKey) {
                return optionalKey.isPresent() ? this.getDelegateDeclarations((Key)optionalKey.get()) : ImmutableSet.of();
            }

            private Optional<ResolvedBindings> getPreviouslyResolvedBindings(BindingKey bindingKey) {
                Optional result = Optional.fromNullable((Object)this.resolvedBindings.get(bindingKey));
                if (result.isPresent()) {
                    return result;
                }
                if (this.parentResolver.isPresent()) {
                    return ((Resolver)this.parentResolver.get()).getPreviouslyResolvedBindings(bindingKey);
                }
                return Optional.absent();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void resolve(DependencyRequest request) {
                BindingKey bindingKey = request.bindingKey();
                if (this.cycleStack.contains(bindingKey)) {
                    return;
                }
                if (this.resolvedBindings.containsKey(bindingKey)) {
                    return;
                }
                if (this.getPreviouslyResolvedBindings(bindingKey).isPresent() && !new MultibindingDependencies().dependsOnLocalMultibindings(bindingKey) && this.getExplicitBindings(bindingKey.key()).isEmpty()) {
                    ((Resolver)this.parentResolver.get()).resolve(request);
                    ResolvedBindings inheritedBindings = ((ResolvedBindings)this.getPreviouslyResolvedBindings(bindingKey).get()).asInheritedIn(this.componentDescriptor);
                    this.resolvedBindings.put(bindingKey, inheritedBindings);
                    return;
                }
                this.cycleStack.push(bindingKey);
                try {
                    ResolvedBindings bindings = this.lookUpBindings(request);
                    for (Binding binding : bindings.ownedBindings()) {
                        for (DependencyRequest dependency : binding.implicitDependencies()) {
                            this.resolve(dependency);
                        }
                    }
                    this.resolvedBindings.put(bindingKey, bindings);
                }
                finally {
                    this.cycleStack.pop();
                }
            }

            ImmutableMap<BindingKey, ResolvedBindings> getResolvedBindings() {
                ImmutableMap.Builder resolvedBindingsBuilder = ImmutableMap.builder();
                resolvedBindingsBuilder.putAll(this.resolvedBindings);
                if (this.parentResolver.isPresent()) {
                    Collection bindingsResolvedInParent = Maps.difference(((Resolver)this.parentResolver.get()).getResolvedBindings(), this.resolvedBindings).entriesOnlyOnLeft().values();
                    for (ResolvedBindings resolvedInParent : bindingsResolvedInParent) {
                        resolvedBindingsBuilder.put((Object)resolvedInParent.bindingKey(), (Object)resolvedInParent.asInheritedIn(this.componentDescriptor));
                    }
                }
                return resolvedBindingsBuilder.build();
            }

            ImmutableSet<ModuleDescriptor> getInheritedModules() {
                return this.parentResolver.isPresent() ? Sets.union(((Resolver)this.parentResolver.get()).getInheritedModules(), ((Resolver)this.parentResolver.get()).componentDescriptor.transitiveModules()).immutableCopy() : ImmutableSet.of();
            }

            ImmutableSet<ModuleDescriptor> getOwnedModules() {
                return Sets.difference(this.componentDescriptor.transitiveModules(), this.getInheritedModules()).immutableCopy();
            }

            private final class MultibindingDependencies {
                private final Set<Object> cycleChecker = new HashSet<Object>();

                private MultibindingDependencies() {
                }

                boolean dependsOnLocalMultibindings(final BindingKey bindingKey) {
                    Preconditions.checkArgument((boolean)Resolver.this.getPreviouslyResolvedBindings(bindingKey).isPresent(), (String)"no previously resolved bindings in %s for %s", (Object[])new Object[]{Resolver.this, bindingKey});
                    if (!this.cycleChecker.add(bindingKey)) {
                        return false;
                    }
                    try {
                        return (Boolean)Resolver.this.dependsOnLocalMultibindingsCache.get((Object)bindingKey, (Callable)new Callable<Boolean>(){

                            @Override
                            public Boolean call() {
                                ResolvedBindings previouslyResolvedBindings = (ResolvedBindings)Resolver.this.getPreviouslyResolvedBindings(bindingKey).get();
                                if (MultibindingDependencies.this.isMultibindingsWithLocalContributions(previouslyResolvedBindings)) {
                                    return true;
                                }
                                for (Binding binding : previouslyResolvedBindings.bindings()) {
                                    if (!MultibindingDependencies.this.dependsOnLocalMultibindings(binding)) continue;
                                    return true;
                                }
                                return false;
                            }
                        });
                    }
                    catch (ExecutionException e) {
                        throw new AssertionError((Object)e);
                    }
                }

                boolean dependsOnLocalMultibindings(final Binding binding) {
                    if (!this.cycleChecker.add(binding)) {
                        return false;
                    }
                    try {
                        return (Boolean)Resolver.this.bindingDependsOnLocalMultibindingsCache.get((Object)binding, (Callable)new Callable<Boolean>(){

                            @Override
                            public Boolean call() {
                                if (!(binding.scope().isPresent() && !((Scope)binding.scope().get()).equals(Scope.reusableScope(Factory.this.elements)) || binding.bindingType().equals((Object)BindingType.PRODUCTION))) {
                                    for (DependencyRequest dependency : binding.implicitDependencies()) {
                                        if (!MultibindingDependencies.this.dependsOnLocalMultibindings(dependency.bindingKey())) continue;
                                        return true;
                                    }
                                }
                                return false;
                            }
                        });
                    }
                    catch (ExecutionException e) {
                        throw new AssertionError((Object)e);
                    }
                }

                private boolean isMultibindingsWithLocalContributions(ResolvedBindings resolvedBindings) {
                    return FluentIterable.from(resolvedBindings.contributionBindings()).transform(ContributionBinding.KIND).anyMatch(ContributionBinding.Kind.IS_SYNTHETIC_MULTIBINDING_KIND) && Resolver.this.explicitMultibindings.containsKey((Object)resolvedBindings.key());
                }
            }
        }
    }
}

