/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import dagger.Provides;
import dagger.multibindings.ElementsIntoSet;
import dagger.multibindings.IntoMap;
import dagger.multibindings.IntoSet;
import dagger.producers.Produces;
import dagger.shaded.auto.common.MoreElements;
import javax.lang.model.element.ExecutableElement;

enum ContributionType {
    MAP,
    SET,
    SET_VALUES,
    UNIQUE;


    boolean isMultibinding() {
        return !this.equals((Object)UNIQUE);
    }

    private static ContributionType forProvisionType(Provides.Type provisionType) {
        switch (provisionType) {
            case SET: {
                return SET;
            }
            case SET_VALUES: {
                return SET_VALUES;
            }
            case MAP: {
                return MAP;
            }
            case UNIQUE: {
                return UNIQUE;
            }
        }
        String string = String.valueOf(provisionType);
        throw new AssertionError((Object)new StringBuilder(24 + String.valueOf(string).length()).append("Unknown provision type: ").append(string).toString());
    }

    private static ContributionType forProductionType(Produces.Type productionType) {
        switch (productionType) {
            case SET: {
                return SET;
            }
            case SET_VALUES: {
                return SET_VALUES;
            }
            case MAP: {
                return MAP;
            }
            case UNIQUE: {
                return UNIQUE;
            }
        }
        String string = String.valueOf(productionType);
        throw new AssertionError((Object)new StringBuilder(25 + String.valueOf(string).length()).append("Unknown production type: ").append(string).toString());
    }

    static ContributionType fromBindingMethod(ExecutableElement method) {
        Preconditions.checkArgument((MoreElements.isAnnotationPresent(method, Provides.class) || MoreElements.isAnnotationPresent(method, Produces.class) ? 1 : 0) != 0);
        if (MoreElements.isAnnotationPresent(method, IntoMap.class)) {
            return MAP;
        }
        if (MoreElements.isAnnotationPresent(method, IntoSet.class)) {
            return SET;
        }
        if (MoreElements.isAnnotationPresent(method, ElementsIntoSet.class)) {
            return SET_VALUES;
        }
        if (MoreElements.isAnnotationPresent(method, Provides.class)) {
            return ContributionType.forProvisionType(method.getAnnotation(Provides.class).type());
        }
        if (MoreElements.isAnnotationPresent(method, Produces.class)) {
            return ContributionType.forProductionType(method.getAnnotation(Produces.class).type());
        }
        throw new AssertionError();
    }

    static <T extends HasContributionType> ImmutableListMultimap<ContributionType, T> indexByContributionType(Iterable<T> haveContributionTypes) {
        return Multimaps.index(haveContributionTypes, (Function)new Function<HasContributionType, ContributionType>(){

            public ContributionType apply(HasContributionType hasContributionType) {
                return hasContributionType.contributionType();
            }
        });
    }

    static interface HasContributionType {
        public ContributionType contributionType();
    }
}

