/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import dagger.Binds;
import dagger.internal.codegen.AutoValue_DelegateDeclaration;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.SourceElement;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

abstract class DelegateDeclaration
implements Key.HasKey,
SourceElement.HasSourceElement,
ContributionType.HasContributionType {
    DelegateDeclaration() {
    }

    abstract DependencyRequest delegateRequest();

    @Override
    public ContributionType contributionType() {
        return ContributionType.UNIQUE;
    }

    static final class Factory {
        private final Types types;
        private final Key.Factory keyFactory;
        private final DependencyRequest.Factory dependencyRequestFactory;

        Factory(Types types, Key.Factory keyFactory, DependencyRequest.Factory dependencyRequestFactory) {
            this.types = types;
            this.keyFactory = keyFactory;
            this.dependencyRequestFactory = dependencyRequestFactory;
        }

        DelegateDeclaration create(ExecutableElement bindsMethod, TypeElement contributingElement) {
            Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(bindsMethod, Binds.class));
            SourceElement sourceElement = SourceElement.forElement(bindsMethod, contributingElement);
            ExecutableType resolvedMethod = MoreTypes.asExecutable(sourceElement.asMemberOfContributingType(this.types));
            DependencyRequest delegateRequest = this.dependencyRequestFactory.forRequiredResolvedVariable(MoreTypes.asDeclared(contributingElement.asType()), (VariableElement)Iterables.getOnlyElement(bindsMethod.getParameters()), (TypeMirror)Iterables.getOnlyElement(resolvedMethod.getParameterTypes()));
            return new AutoValue_DelegateDeclaration(this.keyFactory.forBindsMethod(sourceElement), sourceElement, delegateRequest);
        }
    }
}

