/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.MembersInjectors;
import dagger.internal.Preconditions;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.TypeNames;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.inject.Provider;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

final class FactoryGenerator
extends SourceFileGenerator<ProvisionBinding> {
    private final CompilerOptions compilerOptions;

    FactoryGenerator(Filer filer, Elements elements, CompilerOptions compilerOptions) {
        super(filer, elements);
        this.compilerOptions = compilerOptions;
    }

    @Override
    ClassName nameGeneratedType(ProvisionBinding binding) {
        return SourceFiles.generatedClassNameForBinding(binding);
    }

    @Override
    Optional<? extends Element> getElementForErrorReporting(ProvisionBinding binding) {
        return Optional.of((Object)binding.bindingElement());
    }

    @Override
    Optional<TypeSpec.Builder> write(ClassName generatedTypeName, ProvisionBinding binding) {
        Optional createMethod;
        TypeSpec.Builder factoryBuilder;
        com.google.common.base.Preconditions.checkState((!binding.unresolved().isPresent() ? 1 : 0) != 0);
        TypeMirror keyType = binding.contributionType().equals((Object)ContributionType.MAP) ? MapType.from(binding.key().type()).unwrappedValueType(Provider.class) : binding.key().type();
        TypeName providedTypeName = TypeName.get(keyType);
        ParameterizedTypeName parameterizedFactoryName = TypeNames.factoryOf(providedTypeName);
        Optional factoryOfRawTypeName = Optional.absent();
        Optional constructorBuilder = Optional.absent();
        ImmutableList<TypeVariableName> typeParameters = SourceFiles.bindingTypeElementTypeVariableNames(binding);
        ImmutableMap<BindingKey, FrameworkField> fields = SourceFiles.generateBindingFieldsForDependencies(binding);
        boolean useRawType = binding.factoryCreationStrategy() == ContributionBinding.FactoryCreationStrategy.ENUM_INSTANCE && binding.bindingKind() == ContributionBinding.Kind.INJECTION && !typeParameters.isEmpty();
        switch (binding.factoryCreationStrategy()) {
            case ENUM_INSTANCE: {
                factoryBuilder = TypeSpec.enumBuilder(generatedTypeName.simpleName()).addEnumConstant("INSTANCE");
                if (!useRawType) break;
                factoryBuilder.addAnnotation(AnnotationSpecs.SUPPRESS_WARNINGS_RAWTYPES);
                providedTypeName = ((ParameterizedTypeName)providedTypeName).rawType;
                factoryOfRawTypeName = Optional.of((Object)TypeNames.factoryOf(providedTypeName));
                break;
            }
            case CLASS_CONSTRUCTOR: {
                factoryBuilder = TypeSpec.classBuilder(generatedTypeName).addTypeVariables((Iterable<TypeVariableName>)typeParameters).addModifiers(Modifier.FINAL);
                constructorBuilder = Optional.of((Object)MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC));
                if (binding.bindingKind().equals((Object)ContributionBinding.Kind.PROVISION) && !binding.bindingElement().getModifiers().contains((Object)Modifier.STATIC)) {
                    this.addConstructorParameterAndTypeField(TypeName.get(binding.bindingTypeElement().asType()), "module", factoryBuilder, (MethodSpec.Builder)constructorBuilder.get());
                }
                for (FrameworkField bindingField : fields.values()) {
                    this.addConstructorParameterAndTypeField(bindingField.frameworkType(), bindingField.name(), factoryBuilder, (MethodSpec.Builder)constructorBuilder.get());
                }
                break;
            }
            case DELEGATE: {
                return Optional.absent();
            }
            default: {
                throw new AssertionError();
            }
        }
        factoryBuilder.addModifiers(Modifier.PUBLIC).addSuperinterface((TypeName)factoryOfRawTypeName.or((Object)parameterizedFactoryName));
        switch (binding.bindingKind()) {
            case INJECTION: 
            case PROVISION: {
                MethodSpec.Builder createMethodBuilder = MethodSpec.methodBuilder("create").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(parameterizedFactoryName);
                if (binding.factoryCreationStrategy() != ContributionBinding.FactoryCreationStrategy.ENUM_INSTANCE || binding.bindingKind() == ContributionBinding.Kind.INJECTION) {
                    createMethodBuilder.addTypeVariables((Iterable<TypeVariableName>)typeParameters);
                }
                UnmodifiableIterator params = constructorBuilder.isPresent() ? ((MethodSpec.Builder)constructorBuilder.get()).build().parameters : ImmutableList.of();
                createMethodBuilder.addParameters((Iterable<ParameterSpec>)params);
                switch (binding.factoryCreationStrategy()) {
                    case ENUM_INSTANCE: {
                        if (!useRawType) {
                            createMethodBuilder.addStatement("return INSTANCE", new Object[0]);
                            break;
                        }
                        createMethodBuilder.addStatement("return ($T) INSTANCE", TypeNames.FACTORY);
                        createMethodBuilder.addAnnotation(AnnotationSpecs.SUPPRESS_WARNINGS_UNCHECKED);
                        break;
                    }
                    case CLASS_CONSTRUCTOR: {
                        createMethodBuilder.addStatement("return new $T($L)", SourceFiles.parameterizedGeneratedTypeNameForBinding(binding), CodeBlocks.makeParametersCodeBlock(Lists.transform((List)params, CodeBlocks.PARAMETER_NAME)));
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                createMethod = Optional.of((Object)createMethodBuilder.build());
                break;
            }
            default: {
                createMethod = Optional.absent();
            }
        }
        if (constructorBuilder.isPresent()) {
            factoryBuilder.addMethod(((MethodSpec.Builder)constructorBuilder.get()).build());
        }
        ArrayList parameters = Lists.newArrayList();
        for (DependencyRequest dependency : binding.dependencies()) {
            parameters.add(SourceFiles.frameworkTypeUsageStatement(CodeBlock.of("$L", ((FrameworkField)fields.get((Object)dependency.bindingKey())).name()), dependency.kind()));
        }
        CodeBlock parametersCodeBlock = CodeBlocks.makeParametersCodeBlock(parameters);
        MethodSpec.Builder getMethodBuilder = MethodSpec.methodBuilder("get").returns(providedTypeName).addAnnotation(Override.class).addModifiers(Modifier.PUBLIC);
        if (binding.bindingKind().equals((Object)ContributionBinding.Kind.PROVISION)) {
            CodeBlock.Builder providesMethodInvocationBuilder = CodeBlock.builder();
            if (binding.bindingElement().getModifiers().contains((Object)Modifier.STATIC)) {
                providesMethodInvocationBuilder.add("$T", ClassName.get(binding.bindingTypeElement()));
            } else {
                providesMethodInvocationBuilder.add("module", new Object[0]);
            }
            providesMethodInvocationBuilder.add(".$L($L)", binding.bindingElement().getSimpleName(), parametersCodeBlock);
            CodeBlock providesMethodInvocation = providesMethodInvocationBuilder.build();
            if (binding.contributionType().equals((Object)ContributionType.SET)) {
                TypeName paramTypeName = TypeName.get(MoreTypes.asDeclared(keyType).getTypeArguments().get(0));
                getMethodBuilder.addStatement("return $T.<$T>singleton($L)", Collections.class, paramTypeName, providesMethodInvocation);
            } else if (binding.nullableType().isPresent() || this.compilerOptions.nullableValidationKind().equals((Object)Diagnostic.Kind.WARNING)) {
                if (binding.nullableType().isPresent()) {
                    getMethodBuilder.addAnnotation((ClassName)TypeName.get((TypeMirror)binding.nullableType().get()));
                }
                getMethodBuilder.addStatement("return $L", providesMethodInvocation);
            } else {
                getMethodBuilder.addStatement("return $T.checkNotNull($L, $S)", Preconditions.class, providesMethodInvocation, "Cannot return null from a non-@Nullable @Provides method");
            }
        } else if (binding.membersInjectionRequest().isPresent()) {
            getMethodBuilder.addStatement("return $T.injectMembers($L, new $T($L))", MembersInjectors.class, ((FrameworkField)fields.get((Object)((DependencyRequest)binding.membersInjectionRequest().get()).bindingKey())).name(), providedTypeName, parametersCodeBlock);
        } else {
            getMethodBuilder.addStatement("return new $T($L)", providedTypeName, parametersCodeBlock);
        }
        factoryBuilder.addMethod(getMethodBuilder.build());
        if (createMethod.isPresent()) {
            factoryBuilder.addMethod((MethodSpec)createMethod.get());
        }
        return Optional.of((Object)factoryBuilder);
    }

    private void addConstructorParameterAndTypeField(TypeName typeName, String variableName, TypeSpec.Builder factoryBuilder, MethodSpec.Builder constructorBuilder) {
        FieldSpec field = FieldSpec.builder(typeName, variableName, Modifier.PRIVATE, Modifier.FINAL).build();
        factoryBuilder.addField(field);
        ParameterSpec parameter = ParameterSpec.builder(typeName, variableName, new Modifier[0]).build();
        constructorBuilder.addParameter(parameter);
        constructorBuilder.addCode("assert $1N != null; this.$2N = $1N;", parameter, field);
    }
}

