/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Optional;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.AutoValue_FrameworkField;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.KeyVariableNamer;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.ResolvedBindings;
import dagger.shaded.auto.common.MoreTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor6;

abstract class FrameworkField {
    private static final ElementVisitor<String, Binding> BINDING_ELEMENT_NAME = new ElementKindVisitor6<String, Binding>(){

        @Override
        protected String defaultAction(Element e, Binding p) {
            String string = String.valueOf(p);
            throw new IllegalArgumentException(new StringBuilder(19 + String.valueOf(string).length()).append("Unexpected binding ").append(string).toString());
        }

        @Override
        public String visitExecutableAsConstructor(ExecutableElement e, Binding p) {
            return (String)this.visit(e.getEnclosingElement(), p);
        }

        @Override
        public String visitExecutableAsMethod(ExecutableElement e, Binding p) {
            return e.getSimpleName().toString();
        }

        @Override
        public String visitType(TypeElement e, Binding p) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, e.getSimpleName().toString());
        }
    };

    FrameworkField() {
    }

    static FrameworkField createWithTypeFromKey(Class<?> frameworkClass, Key key, String name) {
        String string;
        String suffix = frameworkClass.getSimpleName();
        ParameterizedTypeName frameworkType = ParameterizedTypeName.get(ClassName.get(frameworkClass), TypeName.get(key.type()));
        if (name.endsWith(suffix)) {
            string = name;
        } else {
            String string2 = String.valueOf(name);
            String string3 = String.valueOf(suffix);
            string = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        }
        return new AutoValue_FrameworkField(frameworkType, string);
    }

    private static FrameworkField createForMapBindingContribution(Key key, String name) {
        String string;
        TypeMirror type = MapType.from(key.type()).valueType();
        String suffix = MoreTypes.asDeclared(type).asElement().getSimpleName().toString();
        ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)TypeName.get(type);
        if (name.endsWith(suffix)) {
            string = name;
        } else {
            String string2 = String.valueOf(name);
            String string3 = String.valueOf(suffix);
            string = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        }
        return new AutoValue_FrameworkField(parameterizedTypeName, string);
    }

    static FrameworkField createForResolvedBindings(ResolvedBindings resolvedBindings, Optional<BindingType> bindingType) {
        if (resolvedBindings.isMultibindingContribution() && resolvedBindings.contributionType().equals((Object)ContributionType.MAP)) {
            return FrameworkField.createForMapBindingContribution(resolvedBindings.key(), FrameworkField.frameworkFieldName(resolvedBindings));
        }
        return FrameworkField.createWithTypeFromKey(bindingType.isPresent() ? ((BindingType)((Object)bindingType.get())).frameworkClass() : resolvedBindings.frameworkClass(), resolvedBindings.key(), FrameworkField.frameworkFieldName(resolvedBindings));
    }

    private static String frameworkFieldName(ResolvedBindings resolvedBindings) {
        ContributionBinding binding;
        if (resolvedBindings.bindingKey().kind().equals((Object)BindingKey.Kind.CONTRIBUTION) && !(binding = resolvedBindings.contributionBinding()).isSyntheticBinding()) {
            return BINDING_ELEMENT_NAME.visit(binding.bindingElement(), binding);
        }
        return KeyVariableNamer.INSTANCE.apply(resolvedBindings.key());
    }

    abstract ParameterizedTypeName frameworkType();

    abstract String name();
}

