/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.FrameworkTypes;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

final class InjectConstructorValidator {
    InjectConstructorValidator() {
    }

    ValidationReport<TypeElement> validate(ExecutableElement constructorElement) {
        ImmutableSet<? extends AnnotationMirror> scopes;
        FluentIterable injectConstructors;
        ValidationReport.Builder<TypeElement> builder = ValidationReport.about(MoreElements.asType(constructorElement.getEnclosingElement()));
        if (constructorElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            builder.addError("Dagger does not support injection into private constructors", constructorElement);
        }
        for (AnnotationMirror qualifier : InjectionAnnotations.getQualifiers(constructorElement)) {
            builder.addError("@Qualifier annotations are not allowed on @Inject constructors.", constructorElement, qualifier);
        }
        for (AnnotationMirror scope : InjectionAnnotations.getScopes(constructorElement)) {
            builder.addError("@Scope annotations are not allowed on @Inject constructors. Annotate the class instead.", constructorElement, scope);
        }
        for (VariableElement parameter : constructorElement.getParameters()) {
            ImmutableSet<? extends AnnotationMirror> qualifiers = InjectionAnnotations.getQualifiers(parameter);
            if (qualifiers.size() > 1) {
                for (AnnotationMirror qualifier : qualifiers) {
                    builder.addError("A single injection site may not use more than one @Qualifier.", constructorElement, qualifier);
                }
            }
            if (!FrameworkTypes.isProducerType(parameter.asType())) continue;
            builder.addError(ErrorMessages.provisionMayNotDependOnProducerType(parameter.asType()), parameter);
        }
        TypeElement enclosingElement = MoreElements.asType(constructorElement.getEnclosingElement());
        Set<Modifier> typeModifiers = enclosingElement.getModifiers();
        if (typeModifiers.contains((Object)Modifier.PRIVATE)) {
            builder.addError("Dagger does not support injection into private classes", constructorElement);
        }
        if (typeModifiers.contains((Object)Modifier.ABSTRACT)) {
            builder.addError("@Inject is nonsense on the constructor of an abstract class", constructorElement);
        }
        if (enclosingElement.getNestingKind().isNested() && !typeModifiers.contains((Object)Modifier.STATIC)) {
            builder.addError("@Inject constructors are invalid on inner classes", constructorElement);
        }
        if ((injectConstructors = FluentIterable.from(ElementFilter.constructorsIn(enclosingElement.getEnclosedElements())).filter((Predicate)new Predicate<ExecutableElement>(){

            public boolean apply(ExecutableElement input) {
                return MoreElements.isAnnotationPresent(input, Inject.class);
            }
        })).size() > 1) {
            builder.addError("Types may only contain one @Inject constructor.", constructorElement);
        }
        if ((scopes = InjectionAnnotations.getScopes(enclosingElement)).size() > 1) {
            for (AnnotationMirror scope : scopes) {
                builder.addError("A single binding may not declare more than one @Scope.", enclosingElement, scope);
            }
        }
        return builder.build();
    }
}

