/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.AutoValue_MembersInjectionBinding;
import dagger.internal.codegen.AutoValue_MembersInjectionBinding_InjectionSite;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.SourceElement;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor6;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

abstract class MembersInjectionBinding
extends Binding {
    MembersInjectionBinding() {
    }

    abstract Optional<MembersInjectionBinding> unresolved();

    @Override
    TypeElement bindingElement() {
        return MoreElements.asType(super.bindingElement());
    }

    @Override
    Set<DependencyRequest> implicitDependencies() {
        return this.dependencies();
    }

    abstract ImmutableSortedSet<InjectionSite> injectionSites();

    abstract Optional<Key> parentKey();

    Strategy injectionStrategy() {
        return this.injectionSites().isEmpty() ? Strategy.NO_OP : Strategy.INJECT_MEMBERS;
    }

    @Override
    public BindingType bindingType() {
        return BindingType.MEMBERS_INJECTION;
    }

    boolean hasLocalInjectionSites() {
        return FluentIterable.from(this.injectionSites()).anyMatch((Predicate)new Predicate<InjectionSite>(){

            public boolean apply(InjectionSite injectionSite) {
                return injectionSite.element().getEnclosingElement().equals(MembersInjectionBinding.this.bindingElement());
            }
        });
    }

    static final class Factory {
        private final Elements elements;
        private final Types types;
        private final Key.Factory keyFactory;
        private final DependencyRequest.Factory dependencyRequestFactory;
        private final ElementVisitor<Optional<InjectionSite>, DeclaredType> injectionSiteVisitor = new ElementKindVisitor6<Optional<InjectionSite>, DeclaredType>(Optional.absent()){

            @Override
            public Optional<InjectionSite> visitExecutableAsMethod(ExecutableElement e, DeclaredType type) {
                return Optional.of((Object)Factory.this.injectionSiteForInjectMethod(e, type));
            }

            @Override
            public Optional<InjectionSite> visitVariableAsField(VariableElement e, DeclaredType type) {
                return MoreElements.isAnnotationPresent(e, Inject.class) && !e.getModifiers().contains((Object)Modifier.PRIVATE) && !e.getModifiers().contains((Object)Modifier.STATIC) ? Optional.of((Object)Factory.this.injectionSiteForInjectField(e, type)) : Optional.absent();
            }
        };

        Factory(Elements elements, Types types, Key.Factory keyFactory, DependencyRequest.Factory dependencyRequestFactory) {
            this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
            this.types = (Types)Preconditions.checkNotNull((Object)types);
            this.keyFactory = (Key.Factory)Preconditions.checkNotNull((Object)keyFactory);
            this.dependencyRequestFactory = (DependencyRequest.Factory)Preconditions.checkNotNull((Object)dependencyRequestFactory);
        }

        private InjectionSite injectionSiteForInjectMethod(ExecutableElement methodElement, DeclaredType containingType) {
            Preconditions.checkNotNull((Object)methodElement);
            Preconditions.checkArgument((boolean)methodElement.getKind().equals((Object)ElementKind.METHOD));
            ExecutableType resolved = MoreTypes.asExecutable(this.types.asMemberOf(containingType, methodElement));
            return new AutoValue_MembersInjectionBinding_InjectionSite(InjectionSite.Kind.METHOD, methodElement, this.dependencyRequestFactory.forRequiredResolvedVariables(containingType, methodElement.getParameters(), resolved.getParameterTypes()));
        }

        private InjectionSite injectionSiteForInjectField(VariableElement fieldElement, DeclaredType containingType) {
            Preconditions.checkNotNull((Object)fieldElement);
            Preconditions.checkArgument((boolean)fieldElement.getKind().equals((Object)ElementKind.FIELD));
            Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(fieldElement, Inject.class));
            TypeMirror resolved = this.types.asMemberOf(containingType, fieldElement);
            return new AutoValue_MembersInjectionBinding_InjectionSite(InjectionSite.Kind.FIELD, fieldElement, (ImmutableSet<DependencyRequest>)ImmutableSet.of((Object)this.dependencyRequestFactory.forRequiredResolvedVariable(containingType, fieldElement, resolved)));
        }

        boolean hasInjectedMembers(DeclaredType declaredType) {
            return !this.getInjectionSites(declaredType).isEmpty();
        }

        MembersInjectionBinding forInjectedType(DeclaredType declaredType, Optional<TypeMirror> resolvedType) {
            if (!declaredType.getTypeArguments().isEmpty() && resolvedType.isPresent()) {
                DeclaredType resolved = MoreTypes.asDeclared((TypeMirror)resolvedType.get());
                Preconditions.checkState((boolean)this.types.isSameType(this.types.erasure(resolved), this.types.erasure(declaredType)), (String)"erased expected type: %s, erased actual type: %s", (Object[])new Object[]{this.types.erasure(resolved), this.types.erasure(declaredType)});
                declaredType = resolved;
            }
            ImmutableSortedSet<InjectionSite> injectionSites = this.getInjectionSites(declaredType);
            ImmutableSet dependencies = FluentIterable.from(injectionSites).transformAndConcat((Function)new Function<InjectionSite, Set<DependencyRequest>>(){

                public Set<DependencyRequest> apply(InjectionSite input) {
                    return input.dependencies();
                }
            }).toSet();
            Optional parentKey = MoreTypes.nonObjectSuperclass(this.types, this.elements, declaredType).transform((Function)new Function<DeclaredType, Key>(){

                public Key apply(DeclaredType superclass) {
                    return Factory.this.keyFactory.forMembersInjectedType(superclass);
                }
            });
            Key key = this.keyFactory.forMembersInjectedType(declaredType);
            TypeElement typeElement = MoreElements.asType(declaredType.asElement());
            return new AutoValue_MembersInjectionBinding(SourceElement.forElement(typeElement), key, (ImmutableSet<DependencyRequest>)dependencies, Binding.findBindingPackage(key), (Optional<MembersInjectionBinding>)(Binding.hasNonDefaultTypeParameters(typeElement, key.type(), this.types) ? Optional.of((Object)this.forInjectedType(MoreTypes.asDeclared(typeElement.asType()), (Optional<TypeMirror>)Optional.absent())) : Optional.absent()), injectionSites, (Optional<Key>)parentKey);
        }

        private ImmutableSortedSet<InjectionSite> getInjectionSites(DeclaredType declaredType) {
            HashSet<InjectionSite> injectionSites = new HashSet<InjectionSite>();
            final ArrayList<TypeElement> ancestors = new ArrayList<TypeElement>();
            LinkedHashMultimap overriddenMethodMap = LinkedHashMultimap.create();
            Optional<DeclaredType> currentType = Optional.of((Object)declaredType);
            while (currentType.isPresent()) {
                DeclaredType type = (DeclaredType)currentType.get();
                ancestors.add(MoreElements.asType(type.asElement()));
                for (Element element : type.asElement().getEnclosedElements()) {
                    Optional<InjectionSite> maybeInjectionSite = this.injectionSiteVisitor.visit(element, type);
                    if (!maybeInjectionSite.isPresent()) continue;
                    InjectionSite injectionSite = (InjectionSite)maybeInjectionSite.get();
                    if (this.shouldBeInjected(injectionSite.element(), (SetMultimap<String, ExecutableElement>)overriddenMethodMap)) {
                        injectionSites.add(injectionSite);
                    }
                    if (injectionSite.kind() != InjectionSite.Kind.METHOD) continue;
                    ExecutableElement injectionSiteMethod = MoreElements.asExecutable(injectionSite.element());
                    overriddenMethodMap.put((Object)injectionSiteMethod.getSimpleName().toString(), (Object)injectionSiteMethod);
                }
                currentType = MoreTypes.nonObjectSuperclass(this.types, this.elements, (DeclaredType)currentType.get());
            }
            return ImmutableSortedSet.copyOf((Comparator)new Comparator<InjectionSite>(){

                @Override
                public int compare(InjectionSite left, InjectionSite right) {
                    return ComparisonChain.start().compare(ancestors.indexOf(right.element().getEnclosingElement()), ancestors.indexOf(left.element().getEnclosingElement())).compare((Comparable)((Object)left.element().getKind()), (Comparable)((Object)right.element().getKind())).compare(left.indexAmongSiblingMembers(left), right.indexAmongSiblingMembers(right)).result();
                }
            }, injectionSites);
        }

        private boolean shouldBeInjected(Element injectionSite, SetMultimap<String, ExecutableElement> overriddenMethodMap) {
            if (!MoreElements.isAnnotationPresent(injectionSite, Inject.class) || injectionSite.getModifiers().contains((Object)Modifier.PRIVATE) || injectionSite.getModifiers().contains((Object)Modifier.STATIC)) {
                return false;
            }
            if (injectionSite.getKind().isField()) {
                return true;
            }
            ExecutableElement injectionSiteMethod = MoreElements.asExecutable(injectionSite);
            TypeElement injectionSiteType = MoreElements.asType(injectionSite.getEnclosingElement());
            for (ExecutableElement method : overriddenMethodMap.get((Object)injectionSiteMethod.getSimpleName().toString())) {
                if (!this.elements.overrides(method, injectionSiteMethod, injectionSiteType)) continue;
                return false;
            }
            return true;
        }
    }

    static abstract class InjectionSite {
        InjectionSite() {
        }

        abstract Kind kind();

        abstract Element element();

        abstract ImmutableSet<DependencyRequest> dependencies();

        protected int indexAmongSiblingMembers(InjectionSite injectionSite) {
            return injectionSite.element().getEnclosingElement().getEnclosedElements().indexOf(injectionSite.element());
        }

        static enum Kind {
            FIELD,
            METHOD;

        }
    }

    static enum Strategy {
        NO_OP,
        INJECT_MEMBERS;

    }
}

