/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import dagger.Provides;
import dagger.internal.codegen.Util;
import dagger.multibindings.ElementsIntoSet;
import dagger.multibindings.IntoMap;
import dagger.multibindings.IntoSet;
import dagger.producers.Produces;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

final class MultibindingAnnotationsProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;

    MultibindingAnnotationsProcessingStep(Messager messager) {
        this.messager = messager;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(IntoSet.class, ElementsIntoSet.class, IntoMap.class);
    }

    @Override
    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        for (Map.Entry entry : elementsByAnnotation.entries()) {
            Element element = (Element)entry.getValue();
            boolean onBindingMethod = FluentIterable.from(element.getAnnotationMirrors()).anyMatch(MultibindingAnnotationsProcessingStep.providesOrProducesMethod());
            if (onBindingMethod) continue;
            AnnotationMirror annotation = (AnnotationMirror)MoreElements.getAnnotationMirror((Element)entry.getValue(), (Class)entry.getKey()).get();
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Multibinding annotations may only be on @Provides or @Produces methods", element, annotation);
        }
        return ImmutableSet.of();
    }

    private static Predicate<AnnotationMirror> providesOrProducesMethod() {
        return Predicates.or(Util.hasAnnotationType(Provides.class), Util.hasAnnotationType(Produces.class));
    }
}

