/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import dagger.Module;
import dagger.Multibindings;
import dagger.internal.codegen.AutoValue_MultibindingDeclaration;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.SourceElement;
import dagger.producers.ProducerModule;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

abstract class MultibindingDeclaration
implements BindingType.HasBindingType,
Key.HasKey,
SourceElement.HasSourceElement,
ContributionType.HasContributionType {
    MultibindingDeclaration() {
    }

    @Override
    public abstract SourceElement sourceElement();

    @Override
    public abstract Key key();

    @Override
    public abstract ContributionType contributionType();

    @Override
    public abstract BindingType bindingType();

    static final class Factory {
        private final Elements elements;
        private final Types types;
        private final Key.Factory keyFactory;
        private final TypeElement objectElement;

        Factory(Elements elements, Types types, Key.Factory keyFactory) {
            this.elements = elements;
            this.types = types;
            this.keyFactory = keyFactory;
            this.objectElement = elements.getTypeElement(Object.class.getCanonicalName());
        }

        ImmutableSet<MultibindingDeclaration> forDeclaredInterface(TypeElement interfaceElement) {
            Preconditions.checkArgument((boolean)interfaceElement.getKind().equals((Object)ElementKind.INTERFACE));
            Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(interfaceElement, Multibindings.class));
            BindingType bindingType = this.bindingType(interfaceElement);
            DeclaredType interfaceType = MoreTypes.asDeclared(interfaceElement.asType());
            ImmutableSet.Builder declarations = ImmutableSet.builder();
            for (ExecutableElement method : MoreElements.getLocalAndInheritedMethods(interfaceElement, this.elements)) {
                if (method.getEnclosingElement().equals(this.objectElement)) continue;
                ExecutableType methodType = MoreTypes.asExecutable(this.types.asMemberOf(interfaceType, method));
                declarations.add((Object)this.forDeclaredMethod(bindingType, method, methodType, interfaceElement));
            }
            return declarations.build();
        }

        private BindingType bindingType(TypeElement interfaceElement) {
            if (MoreElements.isAnnotationPresent(interfaceElement.getEnclosingElement(), Module.class)) {
                return BindingType.PROVISION;
            }
            if (MoreElements.isAnnotationPresent(interfaceElement.getEnclosingElement(), ProducerModule.class)) {
                return BindingType.PRODUCTION;
            }
            String string = String.valueOf(interfaceElement);
            throw new IllegalArgumentException(new StringBuilder(54 + String.valueOf(string).length()).append("Expected ").append(string).append(" to be nested in a @Module or @ProducerModule").toString());
        }

        private MultibindingDeclaration forDeclaredMethod(BindingType bindingType, ExecutableElement method, ExecutableType methodType, TypeElement interfaceElement) {
            TypeMirror returnType = methodType.getReturnType();
            Preconditions.checkArgument((SetType.isSet(returnType) || MapType.isMap(returnType) ? 1 : 0) != 0, (String)"%s must return a set or map", (Object[])new Object[]{method});
            return new AutoValue_MultibindingDeclaration(SourceElement.forElement(method, interfaceElement), this.keyFactory.forMultibindingsMethod(bindingType, methodType, method), this.contributionType(returnType), bindingType);
        }

        private ContributionType contributionType(TypeMirror returnType) {
            if (MapType.isMap(returnType)) {
                return ContributionType.MAP;
            }
            if (SetType.isSet(returnType)) {
                return ContributionType.SET;
            }
            String string = String.valueOf(returnType);
            throw new IllegalArgumentException(new StringBuilder(20 + String.valueOf(string).length()).append("Must be Map or Set: ").append(string).toString());
        }
    }
}

