/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.internal.codegen.AutoValue_ProductionBinding;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DelegateDeclaration;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.SourceElement;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

abstract class ProductionBinding
extends ContributionBinding {
    ProductionBinding() {
    }

    @Override
    public BindingType bindingType() {
        return BindingType.PRODUCTION;
    }

    Optional<ProductionBinding> unresolved() {
        return Optional.absent();
    }

    @Override
    Set<DependencyRequest> implicitDependencies() {
        if (!this.executorRequest().isPresent() && !this.monitorRequest().isPresent()) {
            return super.implicitDependencies();
        }
        return Sets.union((Set)Sets.union((Set)this.executorRequest().asSet(), (Set)this.monitorRequest().asSet()), super.implicitDependencies());
    }

    abstract ImmutableList<? extends TypeMirror> thrownTypes();

    abstract Optional<DependencyRequest> executorRequest();

    abstract Optional<DependencyRequest> monitorRequest();

    static final class Factory {
        private final Types types;
        private final Key.Factory keyFactory;
        private final DependencyRequest.Factory dependencyRequestFactory;

        Factory(Types types, Key.Factory keyFactory, DependencyRequest.Factory dependencyRequestFactory) {
            this.types = types;
            this.keyFactory = keyFactory;
            this.dependencyRequestFactory = dependencyRequestFactory;
        }

        ProductionBinding forProducesMethod(ExecutableElement producesMethod, TypeElement contributedBy) {
            Preconditions.checkArgument((boolean)producesMethod.getKind().equals((Object)ElementKind.METHOD));
            SourceElement sourceElement = SourceElement.forElement(producesMethod, contributedBy);
            Key key = this.keyFactory.forProducesMethod(sourceElement);
            ExecutableType resolvedMethod = MoreTypes.asExecutable(sourceElement.asMemberOfContributingType(this.types));
            ImmutableSet<DependencyRequest> dependencies = this.dependencyRequestFactory.forRequiredResolvedVariables(MoreTypes.asDeclared(contributedBy.asType()), producesMethod.getParameters(), resolvedMethod.getParameterTypes());
            DependencyRequest executorRequest = this.dependencyRequestFactory.forProductionImplementationExecutor();
            DependencyRequest monitorRequest = this.dependencyRequestFactory.forProductionComponentMonitorProvider();
            ContributionBinding.Kind kind = MoreTypes.isTypeOf(ListenableFuture.class, producesMethod.getReturnType()) ? ContributionBinding.Kind.FUTURE_PRODUCTION : ContributionBinding.Kind.IMMEDIATE;
            return new AutoValue_ProductionBinding(ContributionType.fromBindingMethod(producesMethod), sourceElement, key, dependencies, Binding.findBindingPackage(key), (Optional<DeclaredType>)Optional.absent(), (Optional<DependencyRequest>)Optional.absent(), kind, (ImmutableList<? extends TypeMirror>)ImmutableList.copyOf(producesMethod.getThrownTypes()), (Optional<DependencyRequest>)Optional.of((Object)executorRequest), (Optional<DependencyRequest>)Optional.of((Object)monitorRequest));
        }

        ProductionBinding syntheticMapOfValuesOrProducedBinding(DependencyRequest requestForMapOfValuesOrProduced) {
            Preconditions.checkNotNull((Object)requestForMapOfValuesOrProduced);
            Optional<Key> mapOfProducersKey = this.keyFactory.implicitMapProducerKeyFrom(requestForMapOfValuesOrProduced.key());
            Preconditions.checkArgument((boolean)mapOfProducersKey.isPresent(), (String)"%s is not for a Map<K, V>", (Object[])new Object[]{requestForMapOfValuesOrProduced});
            DependencyRequest requestForMapOfProducers = this.dependencyRequestFactory.forImplicitMapBinding(requestForMapOfValuesOrProduced, (Key)mapOfProducersKey.get());
            return new AutoValue_ProductionBinding(ContributionType.UNIQUE, SourceElement.forElement(requestForMapOfProducers.requestElement()), requestForMapOfValuesOrProduced.key(), (ImmutableSet<DependencyRequest>)ImmutableSet.of((Object)requestForMapOfProducers), Binding.findBindingPackage(requestForMapOfValuesOrProduced.key()), (Optional<DeclaredType>)Optional.absent(), (Optional<DependencyRequest>)Optional.absent(), ContributionBinding.Kind.SYNTHETIC_MAP, (ImmutableList<? extends TypeMirror>)ImmutableList.of(), (Optional<DependencyRequest>)Optional.absent(), (Optional<DependencyRequest>)Optional.absent());
        }

        ProductionBinding syntheticMultibinding(DependencyRequest request, Iterable<ContributionBinding> multibindingContributions) {
            return new AutoValue_ProductionBinding(ContributionType.UNIQUE, SourceElement.forElement(request.requestElement()), request.key(), this.dependencyRequestFactory.forMultibindingContributions(request, multibindingContributions), Binding.findBindingPackage(request.key()), (Optional<DeclaredType>)Optional.absent(), (Optional<DependencyRequest>)Optional.absent(), ContributionBinding.Kind.forMultibindingRequest(request), (ImmutableList<? extends TypeMirror>)ImmutableList.of(), (Optional<DependencyRequest>)Optional.absent(), (Optional<DependencyRequest>)Optional.absent());
        }

        ProductionBinding forComponentMethod(ExecutableElement componentMethod) {
            Preconditions.checkNotNull((Object)componentMethod);
            Preconditions.checkArgument((boolean)componentMethod.getKind().equals((Object)ElementKind.METHOD));
            Preconditions.checkArgument((boolean)componentMethod.getParameters().isEmpty());
            Preconditions.checkArgument((boolean)MoreTypes.isTypeOf(ListenableFuture.class, componentMethod.getReturnType()));
            return new AutoValue_ProductionBinding(ContributionType.UNIQUE, SourceElement.forElement(componentMethod), this.keyFactory.forProductionComponentMethod(componentMethod), (ImmutableSet<DependencyRequest>)ImmutableSet.of(), (Optional<String>)Optional.absent(), (Optional<DeclaredType>)Optional.absent(), (Optional<DependencyRequest>)Optional.absent(), ContributionBinding.Kind.COMPONENT_PRODUCTION, (ImmutableList<? extends TypeMirror>)ImmutableList.copyOf(componentMethod.getThrownTypes()), (Optional<DependencyRequest>)Optional.absent(), (Optional<DependencyRequest>)Optional.absent());
        }

        ProductionBinding delegate(DelegateDeclaration delegateDeclaration, ProductionBinding delegateBinding) {
            return new AutoValue_ProductionBinding(delegateBinding.contributionType(), delegateDeclaration.sourceElement(), delegateDeclaration.key(), (ImmutableSet<DependencyRequest>)ImmutableSet.of((Object)delegateDeclaration.delegateRequest()), Binding.findBindingPackage(delegateDeclaration.key()), delegateBinding.nullableType(), (Optional<DependencyRequest>)Optional.absent(), ContributionBinding.Kind.SYNTHETIC_DELEGATE_BINDING, (ImmutableList<? extends TypeMirror>)ImmutableList.of(), (Optional<DependencyRequest>)Optional.absent(), (Optional<DependencyRequest>)Optional.absent());
        }
    }
}

