/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.FrameworkTypes;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MultibindingAnnotations;
import dagger.internal.codegen.Validation;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class ProvidesMethodValidator {
    private final Elements elements;
    private final Types types;

    ProvidesMethodValidator(Elements elements, Types types) {
        this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
        this.types = (Types)Preconditions.checkNotNull((Object)types);
    }

    private TypeElement getSetElement() {
        return this.elements.getTypeElement(Set.class.getCanonicalName());
    }

    ValidationReport<ExecutableElement> validate(ExecutableElement providesMethodElement) {
        TypeMirror returnType;
        TypeKind returnTypeKind;
        Set<Modifier> modifiers;
        ValidationReport.Builder<ExecutableElement> builder = ValidationReport.about(providesMethodElement);
        Element enclosingElement = providesMethodElement.getEnclosingElement();
        if (!MoreElements.isAnnotationPresent(enclosingElement, Module.class)) {
            builder.addError(ProvidesMethodValidator.formatModuleErrorMessage("@%s methods can only be present within a @%s"), providesMethodElement);
        }
        if (!providesMethodElement.getTypeParameters().isEmpty()) {
            builder.addError(this.formatErrorMessage("@%s methods may not have type parameters."), providesMethodElement);
        }
        if ((modifiers = providesMethodElement.getModifiers()).contains((Object)Modifier.PRIVATE)) {
            builder.addError(this.formatErrorMessage("@%s methods cannot be private"), providesMethodElement);
        }
        if (modifiers.contains((Object)Modifier.ABSTRACT)) {
            builder.addError(this.formatErrorMessage("@%s methods cannot be abstract"), providesMethodElement);
        }
        if ((returnTypeKind = (returnType = providesMethodElement.getReturnType()).getKind()).equals((Object)TypeKind.VOID)) {
            builder.addError(this.formatErrorMessage("@%s methods must return a value (not void)."), providesMethodElement);
        }
        Validation.validateUncheckedThrows(this.elements, this.types, providesMethodElement, Provides.class, builder);
        for (VariableElement variableElement : providesMethodElement.getParameters()) {
            if (!FrameworkTypes.isProducerType(variableElement.asType())) continue;
            builder.addError(ErrorMessages.provisionMayNotDependOnProducerType(variableElement.asType()), variableElement);
        }
        ContributionType contributionType = ContributionType.fromBindingMethod(providesMethodElement);
        ProvidesMethodValidator.validateMapKey(builder, providesMethodElement, contributionType, Provides.class);
        Validation.validateMethodQualifiers(builder, providesMethodElement);
        ProvidesMethodValidator.validateMultibindingSpecifiers(builder, providesMethodElement, Provides.class);
        block0 : switch (contributionType) {
            case UNIQUE: {
                if (FrameworkTypes.isFrameworkType(returnType)) {
                    builder.addError(this.formatErrorMessage("@%s methods must not return framework types."), providesMethodElement);
                }
            }
            case SET: {
                Validation.validateReturnType(Provides.class, builder, returnType);
                break;
            }
            case MAP: {
                Validation.validateReturnType(Provides.class, builder, returnType);
                ImmutableSet<? extends AnnotationMirror> immutableSet = MapKeys.getMapKeys(providesMethodElement);
                switch (immutableSet.size()) {
                    case 0: {
                        builder.addError(this.formatErrorMessage("@%s methods of type map must declare a map key"), providesMethodElement);
                        break block0;
                    }
                    case 1: {
                        break block0;
                    }
                }
                builder.addError(this.formatErrorMessage("@%s methods may not have more than one @MapKey-marked annotation"), providesMethodElement);
                break;
            }
            case SET_VALUES: {
                if (!returnTypeKind.equals((Object)TypeKind.DECLARED)) {
                    builder.addError("@Provides methods of type set values must return a Set", providesMethodElement);
                    break;
                }
                DeclaredType declaredReturnType = (DeclaredType)returnType;
                if (!declaredReturnType.asElement().equals(this.getSetElement())) {
                    builder.addError("@Provides methods of type set values must return a Set", providesMethodElement);
                    break;
                }
                if (declaredReturnType.getTypeArguments().isEmpty()) {
                    builder.addError(this.formatErrorMessage("@%s methods of type set values cannot return a raw Set"), providesMethodElement);
                    break;
                }
                Validation.validateReturnType(Provides.class, builder, (TypeMirror)Iterables.getOnlyElement(declaredReturnType.getTypeArguments()));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return builder.build();
    }

    static void validateMapKey(ValidationReport.Builder<ExecutableElement> builder, ExecutableElement method, ContributionType contributionType, Class<? extends Annotation> bindingAnnotation) {
        if (!contributionType.equals((Object)ContributionType.MAP) && !MapKeys.getMapKeys(method).isEmpty()) {
            builder.addError(String.format("@%s methods of non map type cannot declare a map key", bindingAnnotation.getSimpleName()), method);
        }
    }

    static void validateMultibindingSpecifiers(ValidationReport.Builder<ExecutableElement> builder, ExecutableElement method, Class<? extends Annotation> bindingAnnotation) {
        ImmutableSet<AnnotationMirror> multibindingAnnotations = MultibindingAnnotations.forMethod(method);
        if (multibindingAnnotations.size() > 1) {
            for (AnnotationMirror annotation : multibindingAnnotations) {
                builder.addError(String.format("Multiple multibinding annotations cannot be placed on the same %s method", bindingAnnotation.getSimpleName()), method, annotation);
            }
        }
        AnnotationMirror bindingAnnotationMirror = (AnnotationMirror)MoreElements.getAnnotationMirror(method, bindingAnnotation).get();
        boolean usesProvidesType = false;
        for (ExecutableElement member : bindingAnnotationMirror.getElementValues().keySet()) {
            usesProvidesType |= member.getSimpleName().contentEquals("type");
        }
        if (usesProvidesType && !multibindingAnnotations.isEmpty()) {
            builder.addError(String.format("@%s.type cannot be used with multibinding annotations", bindingAnnotation.getSimpleName()), method);
        }
    }

    private String formatErrorMessage(String msg) {
        return String.format(msg, Provides.class.getSimpleName());
    }

    private static String formatModuleErrorMessage(String msg) {
        return String.format(msg, Provides.class.getSimpleName(), Module.class.getSimpleName());
    }
}

