/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import dagger.internal.codegen.AutoValue_ResolvedBindings;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.MultibindingDeclaration;
import dagger.internal.codegen.SourceElement;
import java.util.Collection;

abstract class ResolvedBindings
implements BindingType.HasBindingType,
ContributionType.HasContributionType,
Key.HasKey {
    ResolvedBindings() {
    }

    abstract BindingKey bindingKey();

    abstract ComponentDescriptor owningComponent();

    abstract ImmutableSetMultimap<ComponentDescriptor, ContributionBinding> allContributionBindings();

    abstract ImmutableMap<ComponentDescriptor, MembersInjectionBinding> allMembersInjectionBindings();

    @Override
    public Key key() {
        return this.bindingKey().key();
    }

    abstract ImmutableSet<MultibindingDeclaration> multibindingDeclarations();

    ImmutableSet<? extends Binding> bindings() {
        switch (this.bindingKey().kind()) {
            case CONTRIBUTION: {
                return this.contributionBindings();
            }
            case MEMBERS_INJECTION: {
                return ImmutableSet.copyOf((Collection)this.membersInjectionBinding().asSet());
            }
        }
        throw new AssertionError(this.bindingKey());
    }

    ImmutableSetMultimap<ComponentDescriptor, Binding> bindingsByComponent() {
        return new ImmutableSetMultimap.Builder().putAll(this.allContributionBindings()).putAll((Iterable)this.allMembersInjectionBindings().entrySet()).build();
    }

    boolean isEmpty() {
        return this.bindings().isEmpty() && this.multibindingDeclarations().isEmpty();
    }

    ImmutableSet<? extends Binding> ownedBindings() {
        switch (this.bindingKey().kind()) {
            case CONTRIBUTION: {
                return this.ownedContributionBindings();
            }
            case MEMBERS_INJECTION: {
                return ImmutableSet.copyOf((Collection)this.ownedMembersInjectionBinding().asSet());
            }
        }
        throw new AssertionError(this.bindingKey());
    }

    ImmutableSet<ContributionBinding> contributionBindings() {
        return ImmutableSet.copyOf((Collection)this.allContributionBindings().values());
    }

    ImmutableSet<ContributionBinding> ownedContributionBindings() {
        return this.allContributionBindings().get((Object)this.owningComponent());
    }

    Optional<MembersInjectionBinding> membersInjectionBinding() {
        ImmutableSet membersInjectionBindings = FluentIterable.from((Iterable)this.allMembersInjectionBindings().values()).toSet();
        return membersInjectionBindings.isEmpty() ? Optional.absent() : Optional.of((Object)Iterables.getOnlyElement((Iterable)membersInjectionBindings));
    }

    Optional<MembersInjectionBinding> ownedMembersInjectionBinding() {
        return Optional.fromNullable((Object)this.allMembersInjectionBindings().get((Object)this.owningComponent()));
    }

    static ResolvedBindings forContributionBindings(BindingKey bindingKey, ComponentDescriptor owningComponent, Multimap<ComponentDescriptor, ? extends ContributionBinding> contributionBindings, Iterable<MultibindingDeclaration> multibindings) {
        Preconditions.checkArgument((boolean)bindingKey.kind().equals((Object)BindingKey.Kind.CONTRIBUTION));
        return new AutoValue_ResolvedBindings(bindingKey, owningComponent, (ImmutableSetMultimap<ComponentDescriptor, ContributionBinding>)ImmutableSetMultimap.copyOf(contributionBindings), (ImmutableMap<ComponentDescriptor, MembersInjectionBinding>)ImmutableMap.of(), (ImmutableSet<MultibindingDeclaration>)ImmutableSet.copyOf(multibindings));
    }

    static ResolvedBindings forMembersInjectionBinding(BindingKey bindingKey, ComponentDescriptor owningComponent, MembersInjectionBinding ownedMembersInjectionBinding) {
        Preconditions.checkArgument((boolean)bindingKey.kind().equals((Object)BindingKey.Kind.MEMBERS_INJECTION));
        return new AutoValue_ResolvedBindings(bindingKey, owningComponent, (ImmutableSetMultimap<ComponentDescriptor, ContributionBinding>)ImmutableSetMultimap.of(), (ImmutableMap<ComponentDescriptor, MembersInjectionBinding>)ImmutableMap.of((Object)owningComponent, (Object)ownedMembersInjectionBinding), (ImmutableSet<MultibindingDeclaration>)ImmutableSet.of());
    }

    static ResolvedBindings noBindings(BindingKey bindingKey, ComponentDescriptor owningComponent) {
        return new AutoValue_ResolvedBindings(bindingKey, owningComponent, (ImmutableSetMultimap<ComponentDescriptor, ContributionBinding>)ImmutableSetMultimap.of(), (ImmutableMap<ComponentDescriptor, MembersInjectionBinding>)ImmutableMap.of(), (ImmutableSet<MultibindingDeclaration>)ImmutableSet.of());
    }

    ResolvedBindings asInheritedIn(ComponentDescriptor owningComponent) {
        return new AutoValue_ResolvedBindings(this.bindingKey(), owningComponent, this.allContributionBindings(), this.allMembersInjectionBindings(), this.multibindingDeclarations());
    }

    boolean isMultibindingContribution() {
        return this.contributionBindings().size() == 1 && this.contributionBinding().contributionType().isMultibinding();
    }

    boolean isSyntheticContribution() {
        return this.contributionBindings().size() == 1 && this.contributionBinding().isSyntheticBinding();
    }

    ContributionBinding contributionBinding() {
        return (ContributionBinding)Iterables.getOnlyElement(this.contributionBindings());
    }

    @Override
    public BindingType bindingType() {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (String)"empty bindings for %s", (Object[])new Object[]{this.bindingKey()});
        ImmutableSet bindingTypes = FluentIterable.from((Iterable)Iterables.concat(this.bindings(), this.multibindingDeclarations())).transform(BindingType.BINDING_TYPE).toSet();
        Preconditions.checkState((bindingTypes.size() == 1 ? 1 : 0) != 0, (String)"conflicting binding types: %s", (Object[])new Object[]{this});
        return (BindingType)((Object)Iterables.getOnlyElement((Iterable)bindingTypes));
    }

    @Override
    public ContributionType contributionType() {
        ImmutableSet<ContributionType> types = this.contributionTypes();
        Preconditions.checkState((!types.isEmpty() ? 1 : 0) != 0, (String)"no bindings or declarations for %s", (Object[])new Object[]{this.bindingKey()});
        Preconditions.checkState((types.size() == 1 ? 1 : 0) != 0, (String)"More than one binding present of different types for %s: %s", (Object[])new Object[]{this.bindingKey(), this.bindingsAndDeclarationsByContributionType()});
        return (ContributionType)((Object)Iterables.getOnlyElement(types));
    }

    ImmutableSet<ContributionType> contributionTypes() {
        return this.bindingsAndDeclarationsByContributionType().keySet();
    }

    ImmutableListMultimap<ContributionType, SourceElement.HasSourceElement> bindingsAndDeclarationsByContributionType() {
        return new ImmutableListMultimap.Builder().putAll(ContributionType.indexByContributionType(this.contributionBindings())).putAll(ContributionType.indexByContributionType(this.multibindingDeclarations())).build();
    }

    Optional<String> bindingPackage() {
        ImmutableSet.Builder bindingPackagesBuilder = ImmutableSet.builder();
        for (Binding binding : this.bindings()) {
            bindingPackagesBuilder.addAll((Iterable)binding.bindingPackage().asSet());
        }
        ImmutableSet bindingPackages = bindingPackagesBuilder.build();
        switch (bindingPackages.size()) {
            case 0: {
                return Optional.absent();
            }
            case 1: {
                return Optional.of((Object)bindingPackages.iterator().next());
            }
        }
        throw new IllegalArgumentException();
    }

    Class<?> frameworkClass() {
        return this.bindingType().frameworkClass();
    }
}

