/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.ValidationReport;
import java.lang.annotation.Annotation;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class Validation {
    private Validation() {
    }

    static void validateUncheckedThrows(Elements elements, Types types, ExecutableElement methodElement, Class<? extends Annotation> methodAnnotation, ValidationReport.Builder<ExecutableElement> builder) {
        TypeMirror runtimeExceptionType = elements.getTypeElement(RuntimeException.class.getCanonicalName()).asType();
        TypeMirror errorType = elements.getTypeElement(Error.class.getCanonicalName()).asType();
        for (TypeMirror typeMirror : methodElement.getThrownTypes()) {
            if (types.isSubtype(typeMirror, runtimeExceptionType) || types.isSubtype(typeMirror, errorType)) continue;
            builder.addError(String.format("@%s methods may only throw unchecked exceptions", methodAnnotation.getSimpleName()), methodElement);
            break;
        }
    }

    static void validateReturnType(Class<? extends Annotation> methodAnnotation, ValidationReport.Builder<? extends Element> reportBuilder, TypeMirror returnType) {
        TypeKind kind = returnType.getKind();
        if (!(kind.isPrimitive() || kind.equals((Object)TypeKind.DECLARED) || kind.equals((Object)TypeKind.ARRAY) || kind.equals((Object)TypeKind.TYPEVAR))) {
            reportBuilder.addError(String.format("@%s methods must either return a primitive, an array, a type variable, or a declared type.", methodAnnotation.getSimpleName()), reportBuilder.getSubject());
        }
    }

    static void validateMethodQualifiers(ValidationReport.Builder<ExecutableElement> builder, ExecutableElement methodElement) {
        ImmutableSet<? extends AnnotationMirror> qualifiers = InjectionAnnotations.getQualifiers(methodElement);
        if (qualifiers.size() > 1) {
            for (AnnotationMirror qualifier : qualifiers) {
                builder.addError("Cannot use more than one @Qualifier", methodElement, qualifier);
            }
        }
    }
}

