/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.UnmodifiableIterator;
import com.squareup.javapoet.TypeName;
import dagger.MembersInjector;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.Keys;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.OptionalType;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingDeclaration;
import dagger.internal.codegen.binding.BindingFactory;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingGraphConverter;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.DelegateDeclaration;
import dagger.internal.codegen.binding.InjectBindingRegistry;
import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.binding.LegacyBindingGraph;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ModuleDescriptor;
import dagger.internal.codegen.binding.MultibindingDeclaration;
import dagger.internal.codegen.binding.OptionalBindingDeclaration;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.ResolvedBindings;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.model.BindingKind;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.Key;
import dagger.spi.model.RequestKind;
import dagger.spi.model.Scope;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.MoreTypes;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

@Singleton
public final class BindingGraphFactory
implements ClearableCache {
    private final XProcessingEnv processingEnv;
    private final DaggerElements elements;
    private final InjectBindingRegistry injectBindingRegistry;
    private final KeyFactory keyFactory;
    private final BindingFactory bindingFactory;
    private final ModuleDescriptor.Factory moduleDescriptorFactory;
    private final BindingGraphConverter bindingGraphConverter;
    private final Map<Key, ImmutableSet<Key>> keysMatchingRequestCache = new HashMap<Key, ImmutableSet<Key>>();
    private final CompilerOptions compilerOptions;

    @Inject
    BindingGraphFactory(XProcessingEnv processingEnv, DaggerElements elements, InjectBindingRegistry injectBindingRegistry, KeyFactory keyFactory, BindingFactory bindingFactory, ModuleDescriptor.Factory moduleDescriptorFactory, BindingGraphConverter bindingGraphConverter, CompilerOptions compilerOptions) {
        this.processingEnv = processingEnv;
        this.elements = elements;
        this.injectBindingRegistry = injectBindingRegistry;
        this.keyFactory = keyFactory;
        this.bindingFactory = bindingFactory;
        this.moduleDescriptorFactory = moduleDescriptorFactory;
        this.bindingGraphConverter = bindingGraphConverter;
        this.compilerOptions = compilerOptions;
    }

    public BindingGraph create(ComponentDescriptor componentDescriptor, boolean createFullBindingGraph) {
        return this.bindingGraphConverter.convert(this.createLegacyBindingGraph(Optional.empty(), componentDescriptor, createFullBindingGraph), createFullBindingGraph);
    }

    private LegacyBindingGraph createLegacyBindingGraph(Optional<Resolver> parentResolver, ComponentDescriptor componentDescriptor, boolean createFullBindingGraph) {
        ImmutableSet.Builder explicitBindingsBuilder = ImmutableSet.builder();
        ImmutableSet.Builder delegatesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder optionalsBuilder = ImmutableSet.builder();
        if (componentDescriptor.isRealComponent()) {
            explicitBindingsBuilder.add((Object)this.bindingFactory.componentBinding(componentDescriptor.typeElement()));
        }
        for (ComponentRequirement dependency : componentDescriptor.dependencies()) {
            explicitBindingsBuilder.add((Object)this.bindingFactory.componentDependencyBinding(dependency));
            UnmodifiableIterator dependencyMethods = ElementFilter.methodsIn(this.elements.getAllMembers(XConverters.toJavac((XTypeElement)dependency.typeElement())));
            HashMultimap dedupeBindings = HashMultimap.create();
            for (ExecutableElement method2 : dependencyMethods) {
                if (!ComponentDescriptor.isComponentContributionMethod(method2)) continue;
                ContributionBinding binding = this.bindingFactory.componentDependencyMethodBinding(componentDescriptor, XElements.asMethod((XElement)XConverters.toXProcessing((ExecutableElement)method2, (XProcessingEnv)this.processingEnv)));
                if (!dedupeBindings.put((Object)method2.getSimpleName().toString(), ((ContributionBinding.Builder)binding.toBuilder().clearBindingElement()).build())) continue;
                explicitBindingsBuilder.add((Object)binding);
            }
        }
        componentDescriptor.creatorDescriptor().ifPresent(creatorDescriptor -> creatorDescriptor.boundInstanceRequirements().stream().map(requirement -> this.bindingFactory.boundInstanceBinding((ComponentRequirement)requirement, creatorDescriptor.elementForRequirement((ComponentRequirement)requirement))).forEach(arg_0 -> ((ImmutableSet.Builder)explicitBindingsBuilder).add(arg_0)));
        componentDescriptor.childComponentsDeclaredByBuilderEntryPoints().forEach((builderEntryPoint, childComponent) -> {
            if (!componentDescriptor.childComponentsDeclaredByModules().contains(childComponent)) {
                explicitBindingsBuilder.add((Object)this.bindingFactory.subcomponentCreatorBinding(XElements.asMethod((XElement)XConverters.toXProcessing((ExecutableElement)builderEntryPoint.methodElement(), (XProcessingEnv)this.processingEnv)), componentDescriptor.typeElement()));
            }
        });
        ImmutableSet.Builder multibindingDeclarations = ImmutableSet.builder();
        ImmutableSet.Builder subcomponentDeclarations = ImmutableSet.builder();
        for (ModuleDescriptor moduleDescriptor : this.modules(componentDescriptor, parentResolver)) {
            explicitBindingsBuilder.addAll(moduleDescriptor.bindings());
            multibindingDeclarations.addAll(moduleDescriptor.multibindingDeclarations());
            subcomponentDeclarations.addAll(moduleDescriptor.subcomponentDeclarations());
            delegatesBuilder.addAll(moduleDescriptor.delegateDeclarations());
            optionalsBuilder.addAll(moduleDescriptor.optionalDeclarations());
        }
        Resolver requestResolver = new Resolver(parentResolver, componentDescriptor, BindingGraphFactory.indexBindingDeclarationsByKey(explicitBindingsBuilder.build()), BindingGraphFactory.indexBindingDeclarationsByKey(multibindingDeclarations.build()), BindingGraphFactory.indexBindingDeclarationsByKey(subcomponentDeclarations.build()), BindingGraphFactory.indexBindingDeclarationsByKey(delegatesBuilder.build()), BindingGraphFactory.indexBindingDeclarationsByKey(optionalsBuilder.build()));
        componentDescriptor.entryPointMethods().stream().map(method -> method.dependencyRequest().get()).forEach(entryPoint -> {
            if (entryPoint.kind().equals((Object)RequestKind.MEMBERS_INJECTION)) {
                requestResolver.resolveMembersInjection(entryPoint.key());
            } else {
                requestResolver.resolve(entryPoint.key());
            }
        });
        if (createFullBindingGraph) {
            this.modules(componentDescriptor, parentResolver).stream().flatMap(module -> module.allBindingKeys().stream()).map(key -> key.toBuilder().multibindingContributionIdentifier(Optional.empty()).build()).forEach(requestResolver::resolve);
        }
        HashSet<ComponentDescriptor> resolvedSubcomponents = new HashSet<ComponentDescriptor>();
        ImmutableList.Builder subgraphs = ImmutableList.builder();
        for (ComponentDescriptor subcomponent : Iterables.consumingIterable(requestResolver.subcomponentsToResolve)) {
            if (!resolvedSubcomponents.add(subcomponent)) continue;
            subgraphs.add((Object)this.createLegacyBindingGraph(Optional.of(requestResolver), subcomponent, createFullBindingGraph));
        }
        return new LegacyBindingGraph(componentDescriptor, (ImmutableMap<Key, ResolvedBindings>)ImmutableMap.copyOf(requestResolver.getResolvedContributionBindings()), (ImmutableMap<Key, ResolvedBindings>)ImmutableMap.copyOf(requestResolver.getResolvedMembersInjectionBindings()), (ImmutableList<LegacyBindingGraph>)ImmutableList.copyOf((Collection)subgraphs.build()));
    }

    private ImmutableSet<ModuleDescriptor> modules(ComponentDescriptor componentDescriptor, Optional<Resolver> parentResolver) {
        return this.shouldIncludeImplicitProductionModules(componentDescriptor, parentResolver) ? new ImmutableSet.Builder().addAll(componentDescriptor.modules()).add((Object)this.descriptorForMonitoringModule(componentDescriptor.typeElement())).add((Object)this.descriptorForProductionExecutorModule()).build() : componentDescriptor.modules();
    }

    private boolean shouldIncludeImplicitProductionModules(ComponentDescriptor component, Optional<Resolver> parentResolver) {
        return component.isProduction() && (!component.isSubcomponent() && component.isRealComponent() || parentResolver.isPresent() && !parentResolver.get().componentDescriptor.isProduction());
    }

    private ModuleDescriptor descriptorForMonitoringModule(XTypeElement componentDefinitionType) {
        return this.moduleDescriptorFactory.create(DaggerElements.checkTypePresent(this.processingEnv, SourceFiles.generatedMonitoringModuleName(componentDefinitionType)));
    }

    private ModuleDescriptor descriptorForProductionExecutorModule() {
        return this.moduleDescriptorFactory.create(this.processingEnv.findTypeElement((TypeName)TypeNames.PRODUCTION_EXECTUTOR_MODULE));
    }

    private static <T extends BindingDeclaration> ImmutableSetMultimap<Key, T> indexBindingDeclarationsByKey(Iterable<T> declarations) {
        return ImmutableSetMultimap.copyOf((Multimap)Multimaps.index(declarations, BindingDeclaration::key));
    }

    @Override
    public void clearCache() {
        this.keysMatchingRequestCache.clear();
    }

    static <T extends BindingDeclaration> ImmutableSetMultimap<Key, T> multibindingContributionsByMultibindingKey(Iterable<T> declarations) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (BindingDeclaration declaration : declarations) {
            if (!declaration.key().multibindingContributionIdentifier().isPresent()) continue;
            builder.put((Object)declaration.key().toBuilder().multibindingContributionIdentifier(Optional.empty()).build(), (Object)declaration);
        }
        return builder.build();
    }

    private final class Resolver {
        final Optional<Resolver> parentResolver;
        final ComponentDescriptor componentDescriptor;
        final ImmutableSetMultimap<Key, ContributionBinding> explicitBindings;
        final ImmutableSet<ContributionBinding> explicitBindingsSet;
        final ImmutableSetMultimap<Key, ContributionBinding> explicitMultibindings;
        final ImmutableSetMultimap<Key, MultibindingDeclaration> multibindingDeclarations;
        final ImmutableSetMultimap<Key, SubcomponentDeclaration> subcomponentDeclarations;
        final ImmutableSetMultimap<Key, DelegateDeclaration> delegateDeclarations;
        final ImmutableSetMultimap<Key, OptionalBindingDeclaration> optionalBindingDeclarations;
        final ImmutableSetMultimap<Key, DelegateDeclaration> delegateMultibindingDeclarations;
        final Map<Key, ResolvedBindings> resolvedContributionBindings = new LinkedHashMap<Key, ResolvedBindings>();
        final Map<Key, ResolvedBindings> resolvedMembersInjectionBindings = new LinkedHashMap<Key, ResolvedBindings>();
        final Deque<Key> cycleStack = new ArrayDeque<Key>();
        final Map<Key, Boolean> keyDependsOnLocalBindingsCache = new HashMap<Key, Boolean>();
        final Map<Binding, Boolean> bindingDependsOnLocalBindingsCache = new HashMap<Binding, Boolean>();
        final Queue<ComponentDescriptor> subcomponentsToResolve = new ArrayDeque<ComponentDescriptor>();

        Resolver(Optional<Resolver> parentResolver, ComponentDescriptor componentDescriptor, ImmutableSetMultimap<Key, ContributionBinding> explicitBindings, ImmutableSetMultimap<Key, MultibindingDeclaration> multibindingDeclarations, ImmutableSetMultimap<Key, SubcomponentDeclaration> subcomponentDeclarations, ImmutableSetMultimap<Key, DelegateDeclaration> delegateDeclarations, ImmutableSetMultimap<Key, OptionalBindingDeclaration> optionalBindingDeclarations) {
            this.parentResolver = parentResolver;
            this.componentDescriptor = (ComponentDescriptor)Preconditions.checkNotNull((Object)componentDescriptor);
            this.explicitBindings = (ImmutableSetMultimap)Preconditions.checkNotNull(explicitBindings);
            this.explicitBindingsSet = ImmutableSet.copyOf((Collection)explicitBindings.values());
            this.multibindingDeclarations = (ImmutableSetMultimap)Preconditions.checkNotNull(multibindingDeclarations);
            this.subcomponentDeclarations = (ImmutableSetMultimap)Preconditions.checkNotNull(subcomponentDeclarations);
            this.delegateDeclarations = (ImmutableSetMultimap)Preconditions.checkNotNull(delegateDeclarations);
            this.optionalBindingDeclarations = (ImmutableSetMultimap)Preconditions.checkNotNull(optionalBindingDeclarations);
            this.explicitMultibindings = BindingGraphFactory.multibindingContributionsByMultibindingKey(this.explicitBindingsSet);
            this.delegateMultibindingDeclarations = BindingGraphFactory.multibindingContributionsByMultibindingKey(delegateDeclarations.values());
            this.subcomponentsToResolve.addAll((Collection<ComponentDescriptor>)componentDescriptor.childComponentsDeclaredByFactoryMethods().values());
            this.subcomponentsToResolve.addAll((Collection<ComponentDescriptor>)componentDescriptor.childComponentsDeclaredByBuilderEntryPoints().values());
        }

        ResolvedBindings lookUpBindings(Key requestKey) {
            LinkedHashSet<ContributionBinding> bindings = new LinkedHashSet<ContributionBinding>();
            LinkedHashSet<ContributionBinding> multibindingContributions = new LinkedHashSet<ContributionBinding>();
            LinkedHashSet<MultibindingDeclaration> multibindingDeclarations = new LinkedHashSet<MultibindingDeclaration>();
            LinkedHashSet<OptionalBindingDeclaration> optionalBindingDeclarations = new LinkedHashSet<OptionalBindingDeclaration>();
            LinkedHashSet<SubcomponentDeclaration> subcomponentDeclarations = new LinkedHashSet<SubcomponentDeclaration>();
            ImmutableSet<Key> keysMatchingRequest = this.keysMatchingRequest(requestKey);
            for (Resolver resolver : this.getResolverLineage()) {
                bindings.addAll((Collection<ContributionBinding>)resolver.getLocalExplicitBindings(requestKey));
                for (Key key : keysMatchingRequest) {
                    multibindingContributions.addAll((Collection<ContributionBinding>)resolver.getLocalExplicitMultibindings(key));
                    multibindingDeclarations.addAll((Collection<MultibindingDeclaration>)resolver.multibindingDeclarations.get((Object)key));
                    subcomponentDeclarations.addAll((Collection<SubcomponentDeclaration>)resolver.subcomponentDeclarations.get((Object)key));
                    BindingGraphFactory.this.keyFactory.unwrapOptional(key).map(arg_0 -> resolver.optionalBindingDeclarations.get(arg_0)).ifPresent(optionalBindingDeclarations::addAll);
                }
            }
            if (!multibindingContributions.isEmpty() || !multibindingDeclarations.isEmpty()) {
                bindings.add(BindingGraphFactory.this.bindingFactory.syntheticMultibinding(requestKey, multibindingContributions));
            }
            if (!optionalBindingDeclarations.isEmpty()) {
                bindings.add(BindingGraphFactory.this.bindingFactory.syntheticOptionalBinding(requestKey, RequestKinds.getRequestKind(OptionalType.from(requestKey).valueType()), this.lookUpBindings(BindingGraphFactory.this.keyFactory.unwrapOptional(requestKey).get()).bindings()));
            }
            if (!subcomponentDeclarations.isEmpty()) {
                ProvisionBinding binding2 = BindingGraphFactory.this.bindingFactory.subcomponentCreatorBinding((ImmutableSet<SubcomponentDeclaration>)ImmutableSet.copyOf(subcomponentDeclarations));
                bindings.add(binding2);
                this.addSubcomponentToOwningResolver(binding2);
            }
            if (MoreTypes.isType((TypeMirror)requestKey.type().java()) && MoreTypes.isTypeOf(MembersInjector.class, (TypeMirror)requestKey.type().java())) {
                BindingGraphFactory.this.injectBindingRegistry.getOrFindMembersInjectorProvisionBinding(requestKey).ifPresent(bindings::add);
            }
            if (MoreTypes.isType((TypeMirror)requestKey.type().java()) && XTypes.isDeclared((XType)requestKey.type().xprocessing()) && AssistedInjectionAnnotations.isAssistedFactoryType((XElement)requestKey.type().xprocessing().getTypeElement())) {
                bindings.add(BindingGraphFactory.this.bindingFactory.assistedFactoryBinding(requestKey.type().xprocessing().getTypeElement(), Optional.of(requestKey.type().xprocessing())));
            }
            if (bindings.isEmpty()) {
                BindingGraphFactory.this.injectBindingRegistry.getOrFindProvisionBinding(requestKey).filter(this::isCorrectlyScopedInSubcomponent).ifPresent(bindings::add);
            }
            return ResolvedBindings.forContributionBindings(requestKey, (Multimap<TypeElement, ContributionBinding>)Multimaps.index(bindings, binding -> this.getOwningComponent(requestKey, (ContributionBinding)binding)), multibindingDeclarations, subcomponentDeclarations, optionalBindingDeclarations);
        }

        private boolean isCorrectlyScopedInSubcomponent(ProvisionBinding binding) {
            Preconditions.checkArgument((binding.kind() == BindingKind.INJECTION || binding.kind() == BindingKind.ASSISTED_INJECTION ? 1 : 0) != 0);
            if (!this.rootComponent().isSubcomponent() || !binding.scope().isPresent() || binding.scope().get().isReusable()) {
                return true;
            }
            Resolver owningResolver = this.getOwningResolver(binding).orElse(this);
            ComponentDescriptor owningComponent = owningResolver.componentDescriptor;
            return owningComponent.scopes().contains((Object)binding.scope().get());
        }

        private ComponentDescriptor rootComponent() {
            return this.parentResolver.map(Resolver::rootComponent).orElse(this.componentDescriptor);
        }

        ResolvedBindings lookUpMembersInjectionBinding(Key requestKey) {
            Optional<MembersInjectionBinding> binding = BindingGraphFactory.this.injectBindingRegistry.getOrFindMembersInjectionBinding(requestKey);
            return binding.isPresent() ? ResolvedBindings.forMembersInjectionBinding(requestKey, this.componentDescriptor, binding.get()) : ResolvedBindings.noBindings(requestKey);
        }

        private void addSubcomponentToOwningResolver(ProvisionBinding subcomponentCreatorBinding) {
            Preconditions.checkArgument((boolean)subcomponentCreatorBinding.kind().equals((Object)BindingKind.SUBCOMPONENT_CREATOR));
            Resolver owningResolver = this.getOwningResolver(subcomponentCreatorBinding).get();
            TypeElement builderType = MoreTypes.asTypeElement((TypeMirror)subcomponentCreatorBinding.key().type().java());
            owningResolver.subcomponentsToResolve.add(owningResolver.componentDescriptor.getChildComponentWithBuilderType(builderType));
        }

        private ImmutableSet<Key> keysMatchingRequest(Key requestKey) {
            return BindingGraphFactory.this.keysMatchingRequestCache.computeIfAbsent(requestKey, this::keysMatchingRequestUncached);
        }

        private ImmutableSet<Key> keysMatchingRequestUncached(Key requestKey) {
            ImmutableSet.Builder keys = ImmutableSet.builder();
            keys.add((Object)requestKey);
            BindingGraphFactory.this.keyFactory.unwrapSetKey(requestKey, TypeNames.PRODUCED).ifPresent(arg_0 -> ((ImmutableSet.Builder)keys).add(arg_0));
            BindingGraphFactory.this.keyFactory.rewrapMapKey(requestKey, TypeNames.PRODUCER, TypeNames.PROVIDER).ifPresent(arg_0 -> ((ImmutableSet.Builder)keys).add(arg_0));
            BindingGraphFactory.this.keyFactory.rewrapMapKey(requestKey, TypeNames.PROVIDER, TypeNames.PRODUCER).ifPresent(arg_0 -> ((ImmutableSet.Builder)keys).add(arg_0));
            keys.addAll(BindingGraphFactory.this.keyFactory.implicitFrameworkMapKeys(requestKey));
            return keys.build();
        }

        private ImmutableSet<ContributionBinding> createDelegateBindings(ImmutableSet<DelegateDeclaration> delegateDeclarations) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (DelegateDeclaration delegateDeclaration : delegateDeclarations) {
                builder.add((Object)this.createDelegateBinding(delegateDeclaration));
            }
            return builder.build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ContributionBinding createDelegateBinding(DelegateDeclaration delegateDeclaration) {
            ResolvedBindings resolvedDelegate;
            Key delegateKey = delegateDeclaration.delegateRequest().key();
            if (this.cycleStack.contains(delegateKey)) {
                return BindingGraphFactory.this.bindingFactory.unresolvedDelegateBinding(delegateDeclaration);
            }
            try {
                this.cycleStack.push(delegateKey);
                resolvedDelegate = this.lookUpBindings(delegateKey);
            }
            finally {
                this.cycleStack.pop();
            }
            if (resolvedDelegate.contributionBindings().isEmpty()) {
                return BindingGraphFactory.this.bindingFactory.unresolvedDelegateBinding(delegateDeclaration);
            }
            ContributionBinding explicitDelegate = (ContributionBinding)resolvedDelegate.contributionBindings().iterator().next();
            return BindingGraphFactory.this.bindingFactory.delegateBinding(delegateDeclaration, explicitDelegate);
        }

        private TypeElement getOwningComponent(Key requestKey, ContributionBinding binding) {
            if (this.isResolvedInParent(requestKey, binding) && !new LocalDependencyChecker().dependsOnLocalBindings(binding)) {
                ResolvedBindings parentResolvedBindings = this.parentResolver.get().resolvedContributionBindings.get(requestKey);
                return parentResolvedBindings.owningComponent(binding);
            }
            return XConverters.toJavac((XTypeElement)this.componentDescriptor.typeElement());
        }

        private boolean isResolvedInParent(Key requestKey, ContributionBinding binding) {
            Optional<Resolver> owningResolver = this.getOwningResolver(binding);
            if (owningResolver.isPresent() && !owningResolver.get().equals(this)) {
                this.parentResolver.get().resolve(requestKey);
                return true;
            }
            return false;
        }

        private Optional<Resolver> getOwningResolver(ContributionBinding binding) {
            if (binding.scope().isPresent() && binding.scope().get().isProductionScope() || binding.bindingType().equals((Object)BindingType.PRODUCTION)) {
                for (Resolver requestResolver : this.getResolverLineage()) {
                    if (binding.kind().equals((Object)BindingKind.INJECTION) && requestResolver.componentDescriptor.isProduction()) {
                        return Optional.of(requestResolver);
                    }
                    if (!requestResolver.containsExplicitBinding(binding)) continue;
                    return Optional.of(requestResolver);
                }
            }
            if (binding.scope().isPresent() && binding.scope().get().isReusable()) {
                for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                    ResolvedBindings resolvedBindings = requestResolver.resolvedContributionBindings.get(binding.key());
                    if (resolvedBindings == null || !resolvedBindings.contributionBindings().contains((Object)binding)) continue;
                    return Optional.of(requestResolver);
                }
                return Optional.empty();
            }
            for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                if (!requestResolver.containsExplicitBinding(binding)) continue;
                return Optional.of(requestResolver);
            }
            Optional<Scope> bindingScope = binding.scope();
            if (bindingScope.isPresent()) {
                for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                    if (!requestResolver.componentDescriptor.scopes().contains((Object)bindingScope.get())) continue;
                    return Optional.of(requestResolver);
                }
            }
            return Optional.empty();
        }

        private boolean containsExplicitBinding(ContributionBinding binding) {
            return this.explicitBindingsSet.contains((Object)binding) || this.resolverContainsDelegateDeclarationForBinding(binding) || this.subcomponentDeclarations.containsKey((Object)binding.key());
        }

        private boolean resolverContainsDelegateDeclarationForBinding(ContributionBinding binding) {
            if (!binding.kind().equals((Object)BindingKind.DELEGATE)) {
                return false;
            }
            Key bindingKey = binding.key();
            if (BindingGraphFactory.this.compilerOptions.strictMultibindingValidation() && binding.contributionType().equals((Object)ContributionType.MAP)) {
                bindingKey = BindingGraphFactory.this.keyFactory.unwrapMapValueType(bindingKey);
            }
            return this.delegateDeclarations.get((Object)bindingKey).stream().anyMatch(declaration -> declaration.contributingModule().equals(binding.contributingModule()) && declaration.bindingElement().equals(binding.bindingElement()));
        }

        private ImmutableList<Resolver> getResolverLineage() {
            ImmutableList.Builder resolverList = ImmutableList.builder();
            Optional<Resolver> currentResolver = Optional.of(this);
            while (currentResolver.isPresent()) {
                resolverList.add((Object)currentResolver.get());
                currentResolver = currentResolver.get().parentResolver;
            }
            return resolverList.build().reverse();
        }

        private ImmutableSet<ContributionBinding> getLocalExplicitBindings(Key key) {
            return new ImmutableSet.Builder().addAll((Iterable)this.explicitBindings.get((Object)key)).addAll(this.createDelegateBindings((ImmutableSet<DelegateDeclaration>)this.delegateDeclarations.get((Object)BindingGraphFactory.this.keyFactory.unwrapMapValueType(key)))).build();
        }

        private ImmutableSet<ContributionBinding> getLocalExplicitMultibindings(Key key) {
            ImmutableSet.Builder multibindings = ImmutableSet.builder();
            multibindings.addAll((Iterable)this.explicitMultibindings.get((Object)key));
            if (!MapType.isMap(key) || MapType.from(key).isRawType() || MapType.from(key).valuesAreFrameworkType()) {
                multibindings.addAll(this.createDelegateBindings((ImmutableSet<DelegateDeclaration>)this.delegateMultibindingDeclarations.get((Object)BindingGraphFactory.this.keyFactory.unwrapMapValueType(key))));
            }
            return multibindings.build();
        }

        private ImmutableSet<OptionalBindingDeclaration> getOptionalBindingDeclarations(Key key) {
            Optional<Key> unwrapped = BindingGraphFactory.this.keyFactory.unwrapOptional(key);
            if (!unwrapped.isPresent()) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder declarations = ImmutableSet.builder();
            for (Resolver resolver : this.getResolverLineage()) {
                declarations.addAll((Iterable)resolver.optionalBindingDeclarations.get((Object)unwrapped.get()));
            }
            return declarations.build();
        }

        private Optional<ResolvedBindings> getPreviouslyResolvedBindings(Key key) {
            Optional<ResolvedBindings> result = Optional.ofNullable(this.resolvedContributionBindings.get(key));
            if (result.isPresent()) {
                return result;
            }
            if (this.parentResolver.isPresent()) {
                return this.parentResolver.get().getPreviouslyResolvedBindings(key);
            }
            return Optional.empty();
        }

        private void resolveMembersInjection(Key key) {
            ResolvedBindings bindings = this.lookUpMembersInjectionBinding(key);
            this.resolveDependencies(bindings);
            this.resolvedMembersInjectionBindings.put(key, bindings);
        }

        void resolve(Key key) {
            if (this.cycleStack.contains(key)) {
                return;
            }
            if (this.resolvedContributionBindings.containsKey(key)) {
                return;
            }
            if (this.getPreviouslyResolvedBindings(key).isPresent() && !Keys.isComponentOrCreator(key)) {
                this.parentResolver.get().resolve(key);
                if (!new LocalDependencyChecker().dependsOnLocalBindings(key) && this.getLocalExplicitBindings(key).isEmpty()) {
                    this.resolvedContributionBindings.put(key, this.getPreviouslyResolvedBindings(key).get());
                    return;
                }
            }
            this.cycleStack.push(key);
            try {
                ResolvedBindings bindings = this.lookUpBindings(key);
                this.resolvedContributionBindings.put(key, bindings);
                this.resolveDependencies(bindings);
            }
            finally {
                this.cycleStack.pop();
            }
        }

        private void resolveDependencies(ResolvedBindings resolvedBindings) {
            for (Binding binding : resolvedBindings.bindingsOwnedBy(this.componentDescriptor)) {
                for (DependencyRequest dependency : binding.dependencies()) {
                    this.resolve(dependency.key());
                }
            }
        }

        Map<Key, ResolvedBindings> getResolvedContributionBindings() {
            LinkedHashMap<Key, ResolvedBindings> bindings = new LinkedHashMap<Key, ResolvedBindings>();
            this.parentResolver.ifPresent(parent -> bindings.putAll(parent.getResolvedContributionBindings()));
            bindings.putAll(this.resolvedContributionBindings);
            return bindings;
        }

        ImmutableMap<Key, ResolvedBindings> getResolvedMembersInjectionBindings() {
            return ImmutableMap.copyOf(this.resolvedMembersInjectionBindings);
        }

        private final class LocalDependencyChecker {
            private final Set<Object> cycleChecker = new HashSet<Object>();

            private LocalDependencyChecker() {
            }

            private boolean dependsOnLocalBindings(Key key) {
                if (!this.cycleChecker.add(key)) {
                    return false;
                }
                return Util.reentrantComputeIfAbsent(Resolver.this.keyDependsOnLocalBindingsCache, key, this::dependsOnLocalBindingsUncached);
            }

            private boolean dependsOnLocalBindings(Binding binding) {
                if (!this.cycleChecker.add(binding)) {
                    return false;
                }
                return Util.reentrantComputeIfAbsent(Resolver.this.bindingDependsOnLocalBindingsCache, binding, this::dependsOnLocalBindingsUncached);
            }

            private boolean dependsOnLocalBindingsUncached(Key key) {
                Preconditions.checkArgument((boolean)Resolver.this.getPreviouslyResolvedBindings(key).isPresent(), (String)"no previously resolved bindings in %s for %s", (Object)Resolver.this, (Object)key);
                ResolvedBindings previouslyResolvedBindings = (ResolvedBindings)Resolver.this.getPreviouslyResolvedBindings(key).get();
                if (this.hasLocalMultibindingContributions(key) || this.hasLocalOptionalBindingContribution(previouslyResolvedBindings)) {
                    return true;
                }
                for (Binding binding : previouslyResolvedBindings.bindings()) {
                    if (!this.dependsOnLocalBindings(binding)) continue;
                    return true;
                }
                return false;
            }

            private boolean dependsOnLocalBindingsUncached(Binding binding) {
                if (!(binding.scope().isPresent() && !binding.scope().get().isReusable() || binding.bindingType().equals((Object)BindingType.PRODUCTION))) {
                    for (DependencyRequest dependency : binding.dependencies()) {
                        if (!this.dependsOnLocalBindings(dependency.key())) continue;
                        return true;
                    }
                }
                return false;
            }

            private boolean hasLocalMultibindingContributions(Key requestKey) {
                return Resolver.this.keysMatchingRequest(requestKey).stream().anyMatch(key -> !Resolver.this.getLocalExplicitMultibindings(key).isEmpty());
            }

            private boolean hasLocalOptionalBindingContribution(ResolvedBindings resolvedBindings) {
                if (resolvedBindings.contributionBindings().stream().map(Binding::kind).anyMatch(Predicate.isEqual(BindingKind.OPTIONAL))) {
                    return !Resolver.this.getLocalExplicitBindings(BindingGraphFactory.this.keyFactory.unwrapOptional(resolvedBindings.key()).get()).isEmpty();
                }
                return !Resolver.this.getOptionalBindingDeclarations(resolvedBindings.key()).isEmpty();
            }
        }
    }
}

