/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import dagger.internal.codegen.validation.InjectValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.spi.model.Binding;
import dagger.spi.model.BindingGraph;
import dagger.spi.model.BindingGraphPlugin;
import dagger.spi.model.BindingKind;
import dagger.spi.model.DiagnosticReporter;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.MoreTypes;
import javax.inject.Inject;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class InjectBindingValidator
implements BindingGraphPlugin {
    private final XProcessingEnv processingEnv;
    private final InjectValidator injectValidator;

    @Inject
    InjectBindingValidator(XProcessingEnv processingEnv, InjectValidator injectValidator) {
        this.processingEnv = processingEnv;
        this.injectValidator = injectValidator.whenGeneratingCode();
    }

    public String pluginName() {
        return "Dagger/InjectBinding";
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        bindingGraph.bindings().stream().filter(binding -> binding.kind().equals((Object)BindingKind.INJECTION)).forEach(binding -> this.validateInjectionBinding((Binding)binding, diagnosticReporter));
    }

    private void validateInjectionBinding(Binding node, DiagnosticReporter diagnosticReporter) {
        ValidationReport typeReport = this.injectValidator.validate(XConverters.toXProcessing((TypeElement)MoreTypes.asTypeElement((TypeMirror)node.key().type().java()), (XProcessingEnv)this.processingEnv));
        for (ValidationReport.Item item : typeReport.allItems()) {
            diagnosticReporter.reportBinding(item.kind(), (BindingGraph.MaybeBinding)node, item.message());
        }
    }
}

