/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.FormatMethod;
import dagger.internal.codegen.base.ElementFormatter;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.validation.DiagnosticMessageGenerator;
import dagger.spi.model.BindingGraph;
import dagger.spi.model.DiagnosticReporter;
import dagger.spi.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class DiagnosticReporterFactory {
    private final XMessager messager;
    private final DiagnosticMessageGenerator.Factory diagnosticMessageGeneratorFactory;

    @Inject
    DiagnosticReporterFactory(XMessager messager, DiagnosticMessageGenerator.Factory diagnosticMessageGeneratorFactory) {
        this.messager = messager;
        this.diagnosticMessageGeneratorFactory = diagnosticMessageGeneratorFactory;
    }

    DiagnosticReporterImpl reporter(BindingGraph graph, String pluginName, boolean reportErrorsAsWarnings) {
        return new DiagnosticReporterImpl(graph, pluginName, reportErrorsAsWarnings);
    }

    final class DiagnosticReporterImpl
    implements DiagnosticReporter {
        private final String plugin;
        private final TypeElement rootComponent;
        private final boolean reportErrorsAsWarnings;
        private final ImmutableSet.Builder<Diagnostic.Kind> reportedDiagnosticKinds = ImmutableSet.builder();
        private final DiagnosticMessageGenerator diagnosticMessageGenerator;

        DiagnosticReporterImpl(BindingGraph graph, String plugin, boolean reportErrorsAsWarnings) {
            this.plugin = plugin;
            this.reportErrorsAsWarnings = reportErrorsAsWarnings;
            this.rootComponent = graph.rootComponentNode().componentPath().currentComponent().java();
            this.diagnosticMessageGenerator = DiagnosticReporterFactory.this.diagnosticMessageGeneratorFactory.create(graph);
        }

        ImmutableSet<Diagnostic.Kind> reportedDiagnosticKinds() {
            return this.reportedDiagnosticKinds.build();
        }

        public void reportComponent(Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode componentNode, String messageFormat) {
            StringBuilder message = new StringBuilder(messageFormat);
            this.diagnosticMessageGenerator.appendComponentPathUnlessAtRoot(message, (BindingGraph.Node)componentNode);
            this.printMessage(diagnosticKind, message, this.rootComponent);
        }

        @FormatMethod
        public void reportComponent(Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode componentNode, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.reportComponent(diagnosticKind, componentNode, this.formatMessage(messageFormat, firstArg, moreArgs));
        }

        public void reportBinding(Diagnostic.Kind diagnosticKind, BindingGraph.MaybeBinding binding, String message) {
            this.printMessage(diagnosticKind, message + this.diagnosticMessageGenerator.getMessage(binding), this.rootComponent);
        }

        public void reportBinding(Diagnostic.Kind diagnosticKind, BindingGraph.MaybeBinding binding, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.reportBinding(diagnosticKind, binding, this.formatMessage(messageFormat, firstArg, moreArgs));
        }

        public void reportDependency(Diagnostic.Kind diagnosticKind, BindingGraph.DependencyEdge dependencyEdge, String message) {
            this.printMessage(diagnosticKind, message + this.diagnosticMessageGenerator.getMessage(dependencyEdge), this.rootComponent);
        }

        public void reportDependency(Diagnostic.Kind diagnosticKind, BindingGraph.DependencyEdge dependencyEdge, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.reportDependency(diagnosticKind, dependencyEdge, this.formatMessage(messageFormat, firstArg, moreArgs));
        }

        public void reportSubcomponentFactoryMethod(Diagnostic.Kind diagnosticKind, BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge, String message) {
            this.printMessage(diagnosticKind, message, childFactoryMethodEdge.factoryMethod().java());
        }

        public void reportSubcomponentFactoryMethod(Diagnostic.Kind diagnosticKind, BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.reportSubcomponentFactoryMethod(diagnosticKind, childFactoryMethodEdge, this.formatMessage(messageFormat, firstArg, moreArgs));
        }

        private String formatMessage(String messageFormat, Object firstArg, Object[] moreArgs) {
            return String.format(messageFormat, Lists.asList((Object)firstArg, (Object[])moreArgs).toArray());
        }

        void printMessage(Diagnostic.Kind diagnosticKind, CharSequence message, @NullableDecl Element elementToReport) {
            if (diagnosticKind.equals((Object)Diagnostic.Kind.ERROR) && this.reportErrorsAsWarnings) {
                diagnosticKind = Diagnostic.Kind.WARNING;
            }
            this.reportedDiagnosticKinds.add((Object)diagnosticKind);
            StringBuilder fullMessage = new StringBuilder();
            this.appendBracketPrefix(fullMessage, this.plugin);
            if (elementToReport != null && !DaggerElements.transitivelyEncloses(this.rootComponent, elementToReport)) {
                this.appendBracketPrefix(fullMessage, ElementFormatter.elementToString(elementToReport));
                elementToReport = this.rootComponent;
            }
            XConverters.toJavac((XMessager)DiagnosticReporterFactory.this.messager).printMessage(diagnosticKind, fullMessage.append(message), elementToReport);
        }

        private void appendBracketPrefix(StringBuilder message, String prefix) {
            message.append(String.format("[%s] ", prefix));
        }
    }
}

