/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.Scopes;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.internal.codegen.validation.SuperficialValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XMethodElements;
import dagger.spi.model.Scope;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XVariableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.AnnotationMirror;
import javax.tools.Diagnostic;

@Singleton
public final class InjectValidator
implements ClearableCache {
    private final XProcessingEnv processingEnv;
    private final DaggerTypes types;
    private final DaggerElements elements;
    private final CompilerOptions compilerOptions;
    private final SuperficialValidator superficialValidator;
    private final DependencyRequestValidator dependencyRequestValidator;
    private final Optional<Diagnostic.Kind> privateAndStaticInjectionDiagnosticKind;
    private final InjectionAnnotations injectionAnnotations;
    private final KotlinMetadataUtil metadataUtil;
    private final Map<XTypeElement, ValidationReport> reports = new HashMap<XTypeElement, ValidationReport>();

    @Inject
    InjectValidator(XProcessingEnv processingEnv, DaggerTypes types, DaggerElements elements, SuperficialValidator superficialValidator, DependencyRequestValidator dependencyRequestValidator, CompilerOptions compilerOptions, InjectionAnnotations injectionAnnotations, KotlinMetadataUtil metadataUtil) {
        this(processingEnv, types, elements, compilerOptions, superficialValidator, dependencyRequestValidator, Optional.empty(), injectionAnnotations, metadataUtil);
    }

    private InjectValidator(XProcessingEnv processingEnv, DaggerTypes types, DaggerElements elements, CompilerOptions compilerOptions, SuperficialValidator superficialValidator, DependencyRequestValidator dependencyRequestValidator, Optional<Diagnostic.Kind> privateAndStaticInjectionDiagnosticKind, InjectionAnnotations injectionAnnotations, KotlinMetadataUtil metadataUtil) {
        this.processingEnv = processingEnv;
        this.types = types;
        this.elements = elements;
        this.compilerOptions = compilerOptions;
        this.superficialValidator = superficialValidator;
        this.dependencyRequestValidator = dependencyRequestValidator;
        this.privateAndStaticInjectionDiagnosticKind = privateAndStaticInjectionDiagnosticKind;
        this.injectionAnnotations = injectionAnnotations;
        this.metadataUtil = metadataUtil;
    }

    @Override
    public void clearCache() {
        this.reports.clear();
    }

    public InjectValidator whenGeneratingCode() {
        return this.compilerOptions.ignorePrivateAndStaticInjectionForComponent() ? this : new InjectValidator(this.processingEnv, this.types, this.elements, this.compilerOptions, this.superficialValidator, this.dependencyRequestValidator, Optional.of(Diagnostic.Kind.ERROR), this.injectionAnnotations, this.metadataUtil);
    }

    public ValidationReport validate(XTypeElement typeElement) {
        return Util.reentrantComputeIfAbsent(this.reports, typeElement, this::validateUncached);
    }

    private ValidationReport validateUncached(XTypeElement typeElement) {
        this.superficialValidator.throwIfNearestEnclosingTypeNotValid((XElement)typeElement);
        ValidationReport.Builder builder = ValidationReport.about((XElement)typeElement);
        builder.addSubreport(this.validateMembersInjectionType(typeElement));
        ImmutableSet injectConstructors = ImmutableSet.builder().addAll(InjectionAnnotations.injectedConstructors(typeElement)).addAll(AssistedInjectionAnnotations.assistedInjectedConstructors(typeElement)).build();
        switch (injectConstructors.size()) {
            case 0: {
                break;
            }
            case 1: {
                builder.addSubreport(this.validateConstructor((XConstructorElement)Iterables.getOnlyElement((Iterable)injectConstructors)));
                break;
            }
            default: {
                builder.addError("Types may only contain one injected constructor", (XElement)typeElement);
            }
        }
        return builder.build();
    }

    private ValidationReport validateConstructor(XConstructorElement constructorElement) {
        ValidationReport.Builder builder;
        block12: {
            ImmutableSet<Scope> scopes;
            XTypeElement enclosingElement;
            block11: {
                builder = ValidationReport.about((XElement)constructorElement.getEnclosingElement());
                if (constructorElement.hasAnnotation(TypeNames.INJECT) && constructorElement.hasAnnotation(TypeNames.ASSISTED_INJECT)) {
                    builder.addError("Constructors cannot be annotated with both @Inject and @AssistedInject");
                }
                ClassName injectAnnotation = XElements.getAnyAnnotation((XAnnotated)constructorElement, (ClassName[])new ClassName[]{TypeNames.INJECT, TypeNames.ASSISTED_INJECT}).map(XAnnotations::getClassName).get();
                if (constructorElement.isPrivate()) {
                    builder.addError("Dagger does not support injection into private constructors", (XElement)constructorElement);
                }
                for (Object qualifier : this.injectionAnnotations.getQualifiers((XElement)constructorElement)) {
                    builder.addError(String.format("@Qualifier annotations are not allowed on @%s constructors", injectAnnotation.simpleName()), (XElement)constructorElement, (XAnnotation)qualifier);
                }
                String scopeErrorMsg = String.format("@Scope annotations are not allowed on @%s constructors", injectAnnotation.simpleName());
                if (injectAnnotation.equals((Object)TypeNames.INJECT)) {
                    scopeErrorMsg = scopeErrorMsg + "; annotate the class instead";
                }
                for (Scope scope : Scopes.scopesOf((XElement)constructorElement)) {
                    builder.addError(scopeErrorMsg, (XElement)constructorElement, XConverters.toXProcessing((AnnotationMirror)scope.scopeAnnotation().java(), (XProcessingEnv)this.processingEnv));
                }
                for (XExecutableParameterElement parameter : constructorElement.getParameters()) {
                    this.validateDependencyRequest(builder, (XVariableElement)parameter);
                }
                if (this.throwsCheckedExceptions(constructorElement)) {
                    builder.addItem(String.format("Dagger does not support checked exceptions on @%s constructors", injectAnnotation.simpleName()), this.privateMemberDiagnosticKind(), (XElement)constructorElement);
                }
                this.checkInjectIntoPrivateClass((XElement)constructorElement, builder);
                enclosingElement = constructorElement.getEnclosingElement();
                if (enclosingElement.isAbstract()) {
                    builder.addError(String.format("@%s is nonsense on the constructor of an abstract class", injectAnnotation.simpleName()), (XElement)constructorElement);
                }
                if (XConverters.toJavac((XTypeElement)enclosingElement).getNestingKind().isNested() && !enclosingElement.isStatic()) {
                    builder.addError(String.format("@%s constructors are invalid on inner classes. Did you mean to make the class static?", injectAnnotation.simpleName()), (XElement)constructorElement);
                }
                scopes = Scopes.scopesOf((XElement)enclosingElement);
                if (!injectAnnotation.equals((Object)TypeNames.ASSISTED_INJECT)) break block11;
                for (Scope scope : scopes) {
                    builder.addError("A type with an @AssistedInject-annotated constructor cannot be scoped", (XElement)enclosingElement, XConverters.toXProcessing((AnnotationMirror)scope.scopeAnnotation().java(), (XProcessingEnv)this.processingEnv));
                }
                break block12;
            }
            if (scopes.size() <= 1) break block12;
            for (Scope scope : scopes) {
                builder.addError("A single binding may not declare more than one @Scope", (XElement)enclosingElement, XConverters.toXProcessing((AnnotationMirror)scope.scopeAnnotation().java(), (XProcessingEnv)this.processingEnv));
            }
        }
        return builder.build();
    }

    private ValidationReport validateField(XFieldElement fieldElement) {
        ValidationReport.Builder builder = ValidationReport.about((XElement)fieldElement);
        if (fieldElement.isFinal()) {
            builder.addError("@Inject fields may not be final", (XElement)fieldElement);
        }
        if (fieldElement.isPrivate()) {
            builder.addItem("Dagger does not support injection into private fields", this.privateMemberDiagnosticKind(), (XElement)fieldElement);
        }
        if (fieldElement.isStatic()) {
            builder.addItem("Dagger does not support injection into static fields", this.staticMemberDiagnosticKind(), (XElement)fieldElement);
        }
        this.validateDependencyRequest(builder, (XVariableElement)fieldElement);
        return builder.build();
    }

    private ValidationReport validateMethod(XMethodElement methodElement) {
        ValidationReport.Builder builder = ValidationReport.about((XElement)methodElement);
        if (methodElement.isAbstract()) {
            builder.addError("Methods with @Inject may not be abstract", (XElement)methodElement);
        }
        if (methodElement.isPrivate()) {
            builder.addItem("Dagger does not support injection into private methods", this.privateMemberDiagnosticKind(), (XElement)methodElement);
        }
        if (methodElement.isStatic()) {
            builder.addItem("Dagger does not support injection into static methods", this.staticMemberDiagnosticKind(), (XElement)methodElement);
        }
        if (XMethodElements.hasTypeParameters((XMethodElement)methodElement)) {
            builder.addError("Methods with @Inject may not declare type parameters", (XElement)methodElement);
        }
        if (!methodElement.getThrownTypes().isEmpty()) {
            builder.addError("Methods with @Inject may not throw checked exceptions. Please wrap your exceptions in a RuntimeException instead.", (XElement)methodElement);
        }
        for (XExecutableParameterElement parameter : methodElement.getParameters()) {
            this.validateDependencyRequest(builder, (XVariableElement)parameter);
        }
        return builder.build();
    }

    private void validateDependencyRequest(ValidationReport.Builder builder, XVariableElement parameter) {
        this.dependencyRequestValidator.validateDependencyRequest(builder, (XElement)parameter, parameter.getType());
        this.dependencyRequestValidator.checkNotProducer(builder, parameter);
    }

    private ValidationReport validateMembersInjectionType(XTypeElement typeElement) {
        ValidationReport report;
        ValidationReport report2;
        ValidationReport.Builder builder = ValidationReport.about((XElement)typeElement);
        boolean hasInjectedMembers = false;
        for (XFieldElement field : typeElement.getDeclaredFields()) {
            if (!field.hasAnnotation(TypeNames.INJECT)) continue;
            hasInjectedMembers = true;
            report2 = this.validateField(field);
            if (report2.isClean()) continue;
            builder.addSubreport(report2);
        }
        for (XMethodElement method : typeElement.getDeclaredMethods()) {
            if (!method.hasAnnotation(TypeNames.INJECT)) continue;
            hasInjectedMembers = true;
            report2 = this.validateMethod(method);
            if (report2.isClean()) continue;
            builder.addSubreport(report2);
        }
        if (hasInjectedMembers) {
            this.checkInjectIntoPrivateClass((XElement)typeElement, builder);
            this.checkInjectIntoKotlinObject(typeElement, builder);
        }
        if (typeElement.getSuperType() != null && !(report = this.validate(typeElement.getSuperType().getTypeElement())).isClean()) {
            builder.addSubreport(report);
        }
        return builder.build();
    }

    private boolean throwsCheckedExceptions(XConstructorElement constructorElement) {
        XType runtimeException = this.processingEnv.findType((TypeName)TypeNames.RUNTIME_EXCEPTION);
        XType error = this.processingEnv.findType((TypeName)TypeNames.ERROR);
        return !constructorElement.getThrownTypes().stream().allMatch(type -> this.types.isSubtype((XType)type, runtimeException) || this.types.isSubtype((XType)type, error));
    }

    private void checkInjectIntoPrivateClass(XElement element, ValidationReport.Builder builder) {
        if (!Accessibility.isElementAccessibleFromOwnPackage(DaggerElements.closestEnclosingTypeElement(XConverters.toJavac((XElement)element)))) {
            builder.addItem("Dagger does not support injection into private classes", this.privateMemberDiagnosticKind(), element);
        }
    }

    private void checkInjectIntoKotlinObject(XTypeElement element, ValidationReport.Builder builder) {
        if (element.isKotlinObject() || element.isCompanionObject()) {
            builder.addError("Dagger does not support injection into Kotlin objects", (XElement)element);
        }
    }

    private Diagnostic.Kind privateMemberDiagnosticKind() {
        return this.privateAndStaticInjectionDiagnosticKind.orElse(this.compilerOptions.privateMemberValidationKind());
    }

    private Diagnostic.Kind staticMemberDiagnosticKind() {
        return this.privateAndStaticInjectionDiagnosticKind.orElse(this.compilerOptions.staticMemberValidationKind());
    }
}

