/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.ModuleKind;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.util.ElementFilter;

public final class ModuleProxies {
    private final DaggerElements elements;

    @Inject
    ModuleProxies(DaggerElements elements) {
        this.elements = elements;
    }

    private ClassName constructorProxyTypeName(XTypeElement moduleElement) {
        ModuleKind.checkIsModule(moduleElement);
        ClassName moduleClassName = moduleElement.getClassName();
        return moduleClassName.topLevelClassName().peerClass(SourceFiles.classFileName(moduleClassName) + "_Proxy");
    }

    private Optional<ExecutableElement> nonPublicNullaryConstructor(XTypeElement moduleElement) {
        ModuleKind.checkIsModule(moduleElement);
        if (moduleElement.isAbstract() || XTypeElements.isNested((XTypeElement)moduleElement) && !moduleElement.isStatic()) {
            return Optional.empty();
        }
        return ElementFilter.constructorsIn(this.elements.getAllMembers(XConverters.toJavac((XTypeElement)moduleElement))).stream().filter(constructor -> !Accessibility.isElementPubliclyAccessible(constructor)).filter(constructor -> !constructor.getModifiers().contains((Object)Modifier.PRIVATE)).filter(constructor -> constructor.getParameters().isEmpty()).findAny();
    }

    public CodeBlock newModuleInstance(XTypeElement moduleElement, ClassName requestingClass) {
        ModuleKind.checkIsModule(moduleElement);
        String packageName = requestingClass.packageName();
        return this.nonPublicNullaryConstructor(moduleElement).filter(constructor -> !Accessibility.isElementAccessibleFrom(constructor, packageName)).map(constructor -> CodeBlock.of((String)"$T.newInstance()", (Object[])new Object[]{this.constructorProxyTypeName(moduleElement)})).orElse(CodeBlock.of((String)"new $T()", (Object[])new Object[]{moduleElement.getClassName()}));
    }

    public static final class ModuleConstructorProxyGenerator
    extends SourceFileGenerator<XTypeElement> {
        private final ModuleProxies moduleProxies;

        @Inject
        ModuleConstructorProxyGenerator(XFiler filer, DaggerElements elements, SourceVersion sourceVersion, ModuleProxies moduleProxies) {
            super(filer, elements, sourceVersion);
            this.moduleProxies = moduleProxies;
        }

        @Override
        public XElement originatingElement(XTypeElement moduleElement) {
            return moduleElement;
        }

        @Override
        public ImmutableList<TypeSpec.Builder> topLevelTypes(XTypeElement moduleElement) {
            ModuleKind.checkIsModule(moduleElement);
            return this.moduleProxies.nonPublicNullaryConstructor(moduleElement).isPresent() ? ImmutableList.of((Object)this.buildProxy(moduleElement)) : ImmutableList.of();
        }

        private TypeSpec.Builder buildProxy(XTypeElement moduleElement) {
            return TypeSpec.classBuilder((ClassName)this.moduleProxies.constructorProxyTypeName(moduleElement)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build()).addMethod(MethodSpec.methodBuilder((String)"newInstance").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)moduleElement.getClassName()).addStatement("return new $T()", new Object[]{moduleElement.getClassName()}).build());
        }
    }
}

