/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.base.SourceFileGenerationException;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.BindingFactory;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.SuperficialValidator;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.MethodSpecs;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XMethodElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;

final class AssistedFactoryProcessingStep
extends TypeCheckingProcessingStep<XTypeElement> {
    private final XMessager messager;
    private final XFiler filer;
    private final SourceVersion sourceVersion;
    private final DaggerElements elements;
    private final DaggerTypes types;
    private final BindingFactory bindingFactory;
    private final SuperficialValidator superficialValidator;

    @Inject
    AssistedFactoryProcessingStep(XMessager messager, XFiler filer, SourceVersion sourceVersion, DaggerElements elements, DaggerTypes types, BindingFactory bindingFactory, SuperficialValidator superficialValidator) {
        this.messager = messager;
        this.filer = filer;
        this.sourceVersion = sourceVersion;
        this.elements = elements;
        this.types = types;
        this.bindingFactory = bindingFactory;
        this.superficialValidator = superficialValidator;
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return ImmutableSet.of((Object)TypeNames.ASSISTED_FACTORY);
    }

    @Override
    protected void process(XTypeElement factory, ImmutableSet<ClassName> annotations) {
        ValidationReport report = new AssistedFactoryValidator().validate(factory);
        report.printMessagesTo(this.messager);
        if (report.isClean()) {
            try {
                ProvisionBinding binding = this.bindingFactory.assistedFactoryBinding(factory, Optional.empty());
                new AssistedFactoryImplGenerator().generate(binding);
            }
            catch (SourceFileGenerationException e) {
                e.printMessageTo(this.messager);
            }
        }
    }

    private final class AssistedFactoryImplGenerator
    extends SourceFileGenerator<ProvisionBinding> {
        AssistedFactoryImplGenerator() {
            super(AssistedFactoryProcessingStep.this.filer, AssistedFactoryProcessingStep.this.elements, AssistedFactoryProcessingStep.this.sourceVersion);
        }

        @Override
        public XElement originatingElement(ProvisionBinding binding) {
            return binding.bindingElement().get();
        }

        @Override
        public ImmutableList<TypeSpec.Builder> topLevelTypes(ProvisionBinding binding) {
            XTypeElement factory = XElements.asTypeElement((XElement)binding.bindingElement().get());
            ClassName name = SourceFiles.generatedClassNameForBinding(binding);
            TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)name).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addTypeVariables((Iterable)XConverters.toJavac((XTypeElement)factory).getTypeParameters().stream().map(TypeVariableName::get).collect(DaggerStreams.toImmutableList()));
            if (factory.isInterface()) {
                builder.addSuperinterface(factory.getType().getTypeName());
            } else {
                builder.superclass(factory.getType().getTypeName());
            }
            AssistedInjectionAnnotations.AssistedFactoryMetadata metadata = AssistedInjectionAnnotations.AssistedFactoryMetadata.create(factory.getType());
            ParameterSpec delegateFactoryParam = ParameterSpec.builder((TypeName)this.delegateFactoryTypeName(metadata.assistedInjectType()), (String)"delegateFactory", (Modifier[])new Modifier[0]).build();
            Object[] objectArray = new Object[2];
            objectArray[0] = delegateFactoryParam;
            objectArray[1] = metadata.assistedInjectAssistedParameters().stream().map(arg_0 -> metadata.assistedFactoryAssistedParametersMap().get(arg_0)).map(param -> CodeBlock.of((String)"$L", (Object[])new Object[]{XElements.getSimpleName((XElement)param)})).collect(CodeBlocks.toParametersCodeBlock());
            builder.addField(FieldSpec.builder((TypeName)delegateFactoryParam.type, (String)delegateFactoryParam.name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build()).addMethod(MethodSpec.constructorBuilder().addParameter(delegateFactoryParam).addStatement("this.$1N = $1N", new Object[]{delegateFactoryParam}).build()).addMethod(MethodSpecs.overriding((XMethodElement)metadata.factoryMethod(), (XType)metadata.factoryType()).addStatement("return $N.get($L)", objectArray).build()).addMethod(MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(delegateFactoryParam).addTypeVariables((Iterable)XConverters.toJavac((XTypeElement)metadata.assistedInjectElement()).getTypeParameters().stream().map(TypeVariableName::get).collect(DaggerStreams.toImmutableList())).returns((TypeName)TypeNames.providerOf(factory.getType().getTypeName())).addStatement("return $T.$Lcreate(new $T($N))", new Object[]{TypeNames.INSTANCE_FACTORY, AssistedFactoryProcessingStep.this.sourceVersion.compareTo(SourceVersion.RELEASE_7) <= 0 ? CodeBlock.of((String)"<$T>", (Object[])new Object[]{AssistedFactoryProcessingStep.this.types.accessibleType(XConverters.toJavac((XType)metadata.factoryType()), name)}) : CodeBlock.of((String)"", (Object[])new Object[0]), name, delegateFactoryParam}).build());
            return ImmutableList.of((Object)builder);
        }

        private TypeName delegateFactoryTypeName(XType assistedInjectType) {
            ClassName generatedFactoryClassName = SourceFiles.generatedClassNameForBinding(AssistedFactoryProcessingStep.this.bindingFactory.injectionBinding((XConstructorElement)Iterables.getOnlyElement(AssistedInjectionAnnotations.assistedInjectedConstructors(assistedInjectType.getTypeElement())), Optional.empty()));
            return assistedInjectType.getTypeArguments().isEmpty() ? generatedFactoryClassName : ParameterizedTypeName.get((ClassName)generatedFactoryClassName, (TypeName[])((TypeName[])((ImmutableList)assistedInjectType.getTypeArguments().stream().map(XType::getTypeName).collect(DaggerStreams.toImmutableList())).toArray((Object[])new TypeName[0])));
        }
    }

    private final class AssistedFactoryValidator {
        private AssistedFactoryValidator() {
        }

        ValidationReport validate(XTypeElement factory) {
            ImmutableSet<XMethodElement> abstractFactoryMethods;
            ValidationReport.Builder report = ValidationReport.about((XElement)factory);
            if (!factory.isAbstract()) {
                return report.addError("The @AssistedFactory-annotated type must be either an abstract class or interface.", (XElement)factory).build();
            }
            if (XConverters.toJavac((XTypeElement)factory).getNestingKind().isNested() && !factory.isStatic()) {
                report.addError("Nested @AssistedFactory-annotated types must be static. ", (XElement)factory);
            }
            if ((abstractFactoryMethods = AssistedInjectionAnnotations.assistedFactoryMethods(factory)).isEmpty()) {
                report.addError("The @AssistedFactory-annotated type is missing an abstract, non-default method whose return type matches the assisted injection type.", (XElement)factory);
            }
            for (XMethodElement method : abstractFactoryMethods) {
                XType returnType = method.asMemberOf(factory.getType()).getReturnType();
                if (XTypes.isDeclared((XType)returnType)) {
                    AssistedFactoryProcessingStep.this.superficialValidator.throwIfNearestEnclosingTypeNotValid((XElement)returnType.getTypeElement());
                }
                if (!this.isAssistedInjectionType(returnType)) {
                    report.addError(String.format("Invalid return type: %s. An assisted factory's abstract method must return a type with an @AssistedInject-annotated constructor.", returnType), (XElement)method);
                }
                if (!XMethodElements.hasTypeParameters((XMethodElement)method)) continue;
                report.addError("@AssistedFactory does not currently support type parameters in the creator method. See https://github.com/google/dagger/issues/2279", (XElement)method);
            }
            if (abstractFactoryMethods.size() > 1) {
                report.addError("The @AssistedFactory-annotated type should contain a single abstract, non-default method but found multiple: " + abstractFactoryMethods, (XElement)factory);
            }
            if (!report.build().isClean()) {
                return report.build();
            }
            AssistedInjectionAnnotations.AssistedFactoryMetadata metadata = AssistedInjectionAnnotations.AssistedFactoryMetadata.create(factory.getType());
            HashSet<AssistedInjectionAnnotations.AssistedParameter> uniqueAssistedParameters = new HashSet<AssistedInjectionAnnotations.AssistedParameter>();
            for (AssistedInjectionAnnotations.AssistedParameter assistedParameter : metadata.assistedFactoryAssistedParameters()) {
                if (uniqueAssistedParameters.add(assistedParameter)) continue;
                report.addError("@AssistedFactory method has duplicate @Assisted types: " + assistedParameter, (XElement)assistedParameter.element());
            }
            if (!ImmutableSet.copyOf(metadata.assistedInjectAssistedParameters()).equals((Object)ImmutableSet.copyOf(metadata.assistedFactoryAssistedParameters()))) {
                report.addError(String.format("The parameters in the factory method must match the @Assisted parameters in %s.\n      Actual: %s#%s\n    Expected: %s#%s(%s)", metadata.assistedInjectType(), metadata.factory().getQualifiedName(), metadata.factoryMethod(), metadata.factory().getQualifiedName(), XElements.getSimpleName((XElement)metadata.factoryMethod()), metadata.assistedInjectAssistedParameters().stream().map(AssistedInjectionAnnotations.AssistedParameter::type).map(Object::toString).collect(Collectors.joining(", "))), (XElement)metadata.factoryMethod());
            }
            return report.build();
        }

        private boolean isAssistedInjectionType(XType type) {
            return XTypes.isDeclared((XType)type) && AssistedInjectionAnnotations.isAssistedInjectionType(type.getTypeElement());
        }
    }
}

