/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import dagger.spi.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractElementVisitor8;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import javax.lang.model.util.SimpleTypeVisitor8;

public final class DaggerSuperficialValidation {
    private static final ElementVisitor<Boolean, Void> ELEMENT_VALIDATING_VISITOR = new AbstractElementVisitor8<Boolean, Void>(){

        @Override
        public Boolean visitPackage(PackageElement e, Void p) {
            return DaggerSuperficialValidation.validateAnnotations(e.getAnnotationMirrors());
        }

        @Override
        public Boolean visitType(TypeElement e, Void p) {
            return DaggerSuperficialValidation.isValidBaseElement(e) && DaggerSuperficialValidation.validateElements(e.getTypeParameters()) && DaggerSuperficialValidation.validateTypes(e.getInterfaces()) && DaggerSuperficialValidation.validateType(e.getSuperclass());
        }

        @Override
        public Boolean visitVariable(VariableElement e, Void p) {
            return DaggerSuperficialValidation.isValidBaseElement(e);
        }

        @Override
        public Boolean visitExecutable(ExecutableElement e, Void p) {
            AnnotationValue defaultValue = e.getDefaultValue();
            return DaggerSuperficialValidation.isValidBaseElement(e) && (defaultValue == null || DaggerSuperficialValidation.validateAnnotationValue(defaultValue, e.getReturnType())) && DaggerSuperficialValidation.validateType(e.getReturnType()) && DaggerSuperficialValidation.validateTypes(e.getThrownTypes()) && DaggerSuperficialValidation.validateElements(e.getTypeParameters()) && DaggerSuperficialValidation.validateElements(e.getParameters());
        }

        @Override
        public Boolean visitTypeParameter(TypeParameterElement e, Void p) {
            return DaggerSuperficialValidation.isValidBaseElement(e) && DaggerSuperficialValidation.validateTypes(e.getBounds());
        }

        @Override
        public Boolean visitUnknown(Element e, Void p) {
            return true;
        }
    };
    private static final TypeVisitor<Boolean, Void> TYPE_VALIDATING_VISITOR = new SimpleTypeVisitor8<Boolean, Void>(){

        @Override
        protected Boolean defaultAction(TypeMirror t, Void p) {
            return true;
        }

        @Override
        public Boolean visitArray(ArrayType t, Void p) {
            return DaggerSuperficialValidation.validateType(t.getComponentType());
        }

        @Override
        public Boolean visitDeclared(DeclaredType t, Void p) {
            return DaggerSuperficialValidation.validateTypes(t.getTypeArguments());
        }

        @Override
        public Boolean visitError(ErrorType t, Void p) {
            return false;
        }

        @Override
        public Boolean visitUnknown(TypeMirror t, Void p) {
            return this.defaultAction(t, p);
        }

        @Override
        public Boolean visitWildcard(WildcardType t, Void p) {
            TypeMirror extendsBound = t.getExtendsBound();
            TypeMirror superBound = t.getSuperBound();
            return !(extendsBound != null && !DaggerSuperficialValidation.validateType(extendsBound) || superBound != null && !DaggerSuperficialValidation.validateType(superBound));
        }

        @Override
        public Boolean visitExecutable(ExecutableType t, Void p) {
            return DaggerSuperficialValidation.validateTypes(t.getParameterTypes()) && DaggerSuperficialValidation.validateType(t.getReturnType()) && DaggerSuperficialValidation.validateTypes(t.getThrownTypes()) && DaggerSuperficialValidation.validateTypes(t.getTypeVariables());
        }
    };
    private static final AnnotationValueVisitor<Boolean, TypeMirror> VALUE_VALIDATING_VISITOR = new SimpleAnnotationValueVisitor8<Boolean, TypeMirror>(){

        @Override
        protected Boolean defaultAction(Object o, TypeMirror expectedType) {
            return MoreTypes.isTypeOf(o.getClass(), (TypeMirror)expectedType);
        }

        @Override
        public Boolean visitUnknown(AnnotationValue av, TypeMirror expectedType) {
            return this.defaultAction((Object)av, expectedType);
        }

        @Override
        public Boolean visitAnnotation(AnnotationMirror a, TypeMirror expectedType) {
            return MoreTypes.equivalence().equivalent((Object)a.getAnnotationType(), (Object)expectedType) && DaggerSuperficialValidation.validateAnnotation(a);
        }

        @Override
        public Boolean visitArray(List<? extends AnnotationValue> values, TypeMirror expectedType) {
            if (!expectedType.getKind().equals((Object)TypeKind.ARRAY)) {
                return false;
            }
            TypeMirror componentType = MoreTypes.asArray((TypeMirror)expectedType).getComponentType();
            return values.stream().allMatch(value -> value.accept(this, componentType));
        }

        @Override
        public Boolean visitEnumConstant(VariableElement enumConstant, TypeMirror expectedType) {
            return MoreTypes.equivalence().equivalent((Object)enumConstant.asType(), (Object)expectedType) && DaggerSuperficialValidation.validateElement(enumConstant);
        }

        @Override
        public Boolean visitType(TypeMirror type, TypeMirror ignored) {
            return DaggerSuperficialValidation.validateType(type);
        }

        @Override
        public Boolean visitBoolean(boolean b, TypeMirror expectedType) {
            return MoreTypes.isTypeOf(Boolean.TYPE, (TypeMirror)expectedType);
        }

        @Override
        public Boolean visitByte(byte b, TypeMirror expectedType) {
            return MoreTypes.isTypeOf(Byte.TYPE, (TypeMirror)expectedType);
        }

        @Override
        public Boolean visitChar(char c, TypeMirror expectedType) {
            return MoreTypes.isTypeOf(Character.TYPE, (TypeMirror)expectedType);
        }

        @Override
        public Boolean visitDouble(double d, TypeMirror expectedType) {
            return MoreTypes.isTypeOf(Double.TYPE, (TypeMirror)expectedType);
        }

        @Override
        public Boolean visitFloat(float f, TypeMirror expectedType) {
            return MoreTypes.isTypeOf(Float.TYPE, (TypeMirror)expectedType);
        }

        @Override
        public Boolean visitInt(int i, TypeMirror expectedType) {
            return MoreTypes.isTypeOf(Integer.TYPE, (TypeMirror)expectedType);
        }

        @Override
        public Boolean visitLong(long l, TypeMirror expectedType) {
            return MoreTypes.isTypeOf(Long.TYPE, (TypeMirror)expectedType);
        }

        @Override
        public Boolean visitShort(short s, TypeMirror expectedType) {
            return MoreTypes.isTypeOf(Short.TYPE, (TypeMirror)expectedType);
        }
    };

    public static boolean validateElements(Iterable<? extends Element> elements) {
        return StreamSupport.stream(elements.spliterator(), false).allMatch(DaggerSuperficialValidation::validateElement);
    }

    public static boolean validateElement(Element element) {
        return element.accept(ELEMENT_VALIDATING_VISITOR, null);
    }

    private static boolean isValidBaseElement(Element e) {
        return DaggerSuperficialValidation.validateType(e.asType()) && DaggerSuperficialValidation.validateAnnotations(e.getAnnotationMirrors()) && DaggerSuperficialValidation.validateElements(e.getEnclosedElements());
    }

    public static boolean validateTypes(Iterable<? extends TypeMirror> types) {
        for (TypeMirror typeMirror : types) {
            if (DaggerSuperficialValidation.validateType(typeMirror)) continue;
            return false;
        }
        return true;
    }

    public static boolean validateType(TypeMirror type) {
        return type.accept(TYPE_VALIDATING_VISITOR, null);
    }

    public static boolean validateAnnotations(Iterable<? extends AnnotationMirror> annotationMirrors) {
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (DaggerSuperficialValidation.validateAnnotation(annotationMirror)) continue;
            return false;
        }
        return true;
    }

    public static boolean validateAnnotation(AnnotationMirror annotationMirror) {
        return DaggerSuperficialValidation.validateType(annotationMirror.getAnnotationType()) && DaggerSuperficialValidation.validateAnnotationValues(annotationMirror.getElementValues());
    }

    public static boolean validateAnnotationValues(Map<? extends ExecutableElement, ? extends AnnotationValue> valueMap) {
        return valueMap.entrySet().stream().allMatch(valueEntry -> {
            TypeMirror expectedType = ((ExecutableElement)valueEntry.getKey()).getReturnType();
            return DaggerSuperficialValidation.validateAnnotationValue((AnnotationValue)valueEntry.getValue(), expectedType);
        });
    }

    public static boolean validateAnnotationValue(AnnotationValue annotationValue, TypeMirror expectedType) {
        return annotationValue.accept(VALUE_VALIDATING_VISITOR, expectedType);
    }

    private DaggerSuperficialValidation() {
    }
}

