/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.model.BindingKind;
import dagger.spi.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XConstructorType;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XVariableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.List;
import javax.lang.model.element.Modifier;

final class AssistedInjectionParameters {
    public static ImmutableList<ParameterSpec> assistedFactoryParameterSpecs(Binding binding, ComponentImplementation.ShardImplementation shardImplementation) {
        Preconditions.checkArgument((binding.kind() == BindingKind.ASSISTED_FACTORY ? 1 : 0) != 0);
        XTypeElement factory = XElements.asTypeElement((XElement)binding.bindingElement().get());
        AssistedInjectionAnnotations.AssistedFactoryMetadata metadata = AssistedInjectionAnnotations.AssistedFactoryMetadata.create(factory.getType());
        XMethodType factoryMethodType = metadata.factoryMethod().asMemberOf(binding.key().type().xprocessing());
        return AssistedInjectionParameters.assistedParameterSpecs((List)metadata.assistedFactoryAssistedParameters().stream().map(arg_0 -> metadata.assistedInjectAssistedParametersMap().get(arg_0)).collect(DaggerStreams.toImmutableList()), factoryMethodType.getParameterTypes(), shardImplementation);
    }

    public static ImmutableList<ParameterSpec> assistedParameterSpecs(Binding binding, ComponentImplementation.ShardImplementation shardImplementation) {
        Preconditions.checkArgument((binding.kind() == BindingKind.ASSISTED_INJECTION ? 1 : 0) != 0);
        XConstructorElement constructor = XElements.asConstructor((XElement)binding.bindingElement().get());
        XConstructorType constructorType = constructor.asMemberOf(binding.key().type().xprocessing());
        return AssistedInjectionParameters.assistedParameterSpecs(constructor.getParameters(), constructorType.getParameterTypes(), shardImplementation);
    }

    private static ImmutableList<ParameterSpec> assistedParameterSpecs(List<? extends XVariableElement> paramElements, List<XType> paramTypes, ComponentImplementation.ShardImplementation shardImplementation) {
        ImmutableList.Builder assistedParameterSpecs = ImmutableList.builder();
        for (int i = 0; i < paramElements.size(); ++i) {
            XVariableElement paramElement = paramElements.get(i);
            XType paramType = paramTypes.get(i);
            if (!AssistedInjectionAnnotations.isAssistedParameter(paramElement)) continue;
            assistedParameterSpecs.add((Object)ParameterSpec.builder((TypeName)paramType.getTypeName(), (String)shardImplementation.getUniqueFieldNameForAssistedParam(XConverters.toJavac((XVariableElement)paramElement)), (Modifier[])new Modifier[0]).build());
        }
        return assistedParameterSpecs.build();
    }

    private AssistedInjectionParameters() {
    }
}

