/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.FrameworkField;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.javapoet.AnnotationSpecs;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.GwtCompatibility;
import dagger.internal.codegen.writing.InjectionMethods;
import dagger.spi.model.DependencyRequest;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Map;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

public final class MembersInjectorGenerator
extends SourceFileGenerator<MembersInjectionBinding> {
    private final DaggerTypes types;
    private final KotlinMetadataUtil metadataUtil;

    @Inject
    MembersInjectorGenerator(XFiler filer, DaggerElements elements, DaggerTypes types, SourceVersion sourceVersion, KotlinMetadataUtil metadataUtil) {
        super(filer, elements, sourceVersion);
        this.types = types;
        this.metadataUtil = metadataUtil;
    }

    @Override
    public XElement originatingElement(MembersInjectionBinding binding) {
        return binding.membersInjectedType();
    }

    @Override
    public ImmutableList<TypeSpec.Builder> topLevelTypes(MembersInjectionBinding binding) {
        if (binding.injectionSites().isEmpty()) {
            return ImmutableList.of();
        }
        if (!binding.hasLocalInjectionSites() && InjectionAnnotations.injectedConstructors(binding.membersInjectedType()).isEmpty() && AssistedInjectionAnnotations.assistedInjectedConstructors(binding.membersInjectedType()).isEmpty()) {
            return ImmutableList.of();
        }
        Preconditions.checkState((!binding.unresolved().isPresent() ? 1 : 0) != 0, (String)"tried to generate a MembersInjector for a binding of a resolved generic type: %s", (Object)binding);
        ClassName generatedTypeName = SourceFiles.membersInjectorNameForType(binding.membersInjectedType());
        ImmutableList<TypeVariableName> typeParameters = SourceFiles.bindingTypeElementTypeVariableNames(binding);
        TypeSpec.Builder injectorTypeBuilder = TypeSpec.classBuilder((ClassName)generatedTypeName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addTypeVariables(typeParameters);
        TypeName injectedTypeName = TypeName.get((TypeMirror)binding.key().type().java());
        ParameterizedTypeName implementedType = TypeNames.membersInjectorOf(injectedTypeName);
        injectorTypeBuilder.addSuperinterface((TypeName)implementedType);
        MethodSpec.Builder injectMembersBuilder = MethodSpec.methodBuilder((String)"injectMembers").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(injectedTypeName, "instance", new Modifier[0]);
        ImmutableMap<DependencyRequest, FrameworkField> fields = SourceFiles.generateBindingFieldsForDependencies(binding);
        ImmutableMap.Builder dependencyFieldsBuilder = ImmutableMap.builder();
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder createMethodBuilder = MethodSpec.methodBuilder((String)"create").returns((TypeName)implementedType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addTypeVariables(typeParameters);
        createMethodBuilder.addCode("return new $T(", new Object[]{SourceFiles.parameterizedGeneratedTypeNameForBinding(binding)});
        ImmutableList.Builder constructorInvocationParameters = ImmutableList.builder();
        boolean usesRawFrameworkTypes = false;
        UniqueNameSet fieldNames = new UniqueNameSet();
        for (Map.Entry fieldEntry : fields.entrySet()) {
            DependencyRequest dependency = (DependencyRequest)fieldEntry.getKey();
            FrameworkField bindingField = (FrameworkField)fieldEntry.getValue();
            boolean useRawFrameworkType = !Accessibility.isTypeAccessibleFrom(dependency.key().type().java(), generatedTypeName.packageName());
            String fieldName = fieldNames.getUniqueName(bindingField.name());
            ParameterizedTypeName fieldType = useRawFrameworkType ? bindingField.type().rawType : bindingField.type();
            FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            ParameterSpec.Builder parameterBuilder = ParameterSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[0]);
            if (useRawFrameworkType) {
                usesRawFrameworkTypes = true;
                fieldBuilder.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, new AnnotationSpecs.Suppression[0]));
                parameterBuilder.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, new AnnotationSpecs.Suppression[0]));
            }
            constructorBuilder.addParameter(parameterBuilder.build());
            createMethodBuilder.addParameter(parameterBuilder.build());
            FieldSpec field = fieldBuilder.build();
            injectorTypeBuilder.addField(field);
            constructorBuilder.addStatement("this.$1N = $1N", new Object[]{field});
            dependencyFieldsBuilder.put((Object)dependency, (Object)field);
            constructorInvocationParameters.add((Object)CodeBlock.of((String)"$N", (Object[])new Object[]{field}));
        }
        createMethodBuilder.addCode(constructorInvocationParameters.build().stream().collect(CodeBlocks.toParametersCodeBlock()));
        createMethodBuilder.addCode(");", new Object[0]);
        injectorTypeBuilder.addMethod(constructorBuilder.build());
        injectorTypeBuilder.addMethod(createMethodBuilder.build());
        ImmutableMap dependencyFields = dependencyFieldsBuilder.build();
        injectMembersBuilder.addCode(InjectionMethods.InjectionSiteMethod.invokeAll(binding.injectionSites(), generatedTypeName, CodeBlock.of((String)"instance", (Object[])new Object[0]), binding.key().type().java(), arg_0 -> SourceFiles.frameworkFieldUsages(binding.dependencies(), (ImmutableMap<DependencyRequest, FieldSpec>)dependencyFields).get(arg_0), this.types, this.metadataUtil));
        if (usesRawFrameworkTypes) {
            injectMembersBuilder.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0]));
        }
        injectorTypeBuilder.addMethod(injectMembersBuilder.build());
        for (MembersInjectionBinding.InjectionSite injectionSite : binding.injectionSites()) {
            if (!injectionSite.element().getEnclosingElement().equals(XConverters.toJavac((XTypeElement)binding.membersInjectedType()))) continue;
            injectorTypeBuilder.addMethod(InjectionMethods.InjectionSiteMethod.create(injectionSite, this.metadataUtil));
        }
        GwtCompatibility.gwtIncompatibleAnnotation(binding).ifPresent(arg_0 -> ((TypeSpec.Builder)injectorTypeBuilder).addAnnotation(arg_0));
        return ImmutableList.of((Object)injectorTypeBuilder);
    }
}

