/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.AutoValue_MapType;
import dagger.internal.codegen.base.FrameworkTypes;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.model.Key;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;

@AutoValue
public abstract class MapType {
    private XType type;

    abstract TypeName typeName();

    private XType type() {
        return this.type;
    }

    public boolean isRawType() {
        return this.type().getTypeArguments().isEmpty();
    }

    public XType keyType() {
        Preconditions.checkState((!this.isRawType() ? 1 : 0) != 0);
        return (XType)this.type().getTypeArguments().get(0);
    }

    public XType valueType() {
        Preconditions.checkState((!this.isRawType() ? 1 : 0) != 0);
        return (XType)this.type().getTypeArguments().get(1);
    }

    public boolean valuesAreTypeOf(ClassName className) {
        return !this.isRawType() && XTypes.isTypeOf((XType)this.valueType(), (ClassName)className);
    }

    public boolean valuesAreFrameworkType() {
        return FrameworkTypes.isFrameworkType(this.valueType());
    }

    public XType unwrappedFrameworkValueType() {
        Preconditions.checkState((boolean)this.valuesAreFrameworkType(), (String)"called unwrappedFrameworkValueType() on %s", (Object)this.type());
        return this.uncheckedUnwrappedValueType();
    }

    public XType unwrappedValueType(ClassName wrappingClass) {
        Preconditions.checkState((boolean)this.valuesAreTypeOf(wrappingClass), (String)"expected values to be %s: %s", (Object)wrappingClass, (Object)this);
        return this.uncheckedUnwrappedValueType();
    }

    private XType uncheckedUnwrappedValueType() {
        return XTypes.unwrapType((XType)this.valueType());
    }

    public static boolean isMap(XType type) {
        return XTypes.isTypeOf((XType)type, (ClassName)TypeNames.MAP);
    }

    public static boolean isMap(Key key) {
        return MapType.isMap(key.type().xprocessing());
    }

    public static MapType from(XType type) {
        Preconditions.checkArgument((boolean)MapType.isMap(type), (String)"%s is not a Map", (Object)type);
        AutoValue_MapType mapType = new AutoValue_MapType(type.getTypeName());
        mapType.type = type;
        return mapType;
    }

    public static MapType from(Key key) {
        return MapType.from(key.type().xprocessing());
    }
}

