/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.Preconditions;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequirementExpressions;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;

final class ComponentProvisionRequestRepresentation
extends RequestRepresentation {
    private final ProvisionBinding binding;
    private final BindingGraph bindingGraph;
    private final ComponentRequirementExpressions componentRequirementExpressions;
    private final CompilerOptions compilerOptions;
    private final boolean isExperimentalMergedMode;

    @AssistedInject
    ComponentProvisionRequestRepresentation(@Assisted ProvisionBinding binding, BindingGraph bindingGraph, ComponentImplementation componentImplementation, ComponentRequirementExpressions componentRequirementExpressions, CompilerOptions compilerOptions) {
        this.binding = binding;
        this.bindingGraph = bindingGraph;
        this.componentRequirementExpressions = componentRequirementExpressions;
        this.compilerOptions = compilerOptions;
        this.isExperimentalMergedMode = componentImplementation.compilerMode().isExperimentalMergedMode();
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        CodeBlock componentDependency = this.isExperimentalMergedMode ? CodeBlock.of((String)"(($T) dependencies[0])", (Object[])new Object[]{this.componentRequirement().type().getTypeName()}) : this.getComponentRequirementExpression(requestingClass);
        CodeBlock invocation = CodeBlock.of((String)"$L.$L()", (Object[])new Object[]{componentDependency, XElements.getSimpleName((XElement)this.binding.bindingElement().get())});
        return Expression.create(this.binding.contributedPrimitiveType().orElse(this.binding.key().type().xprocessing()), ComponentProvisionRequestRepresentation.maybeCheckForNull(this.binding, this.compilerOptions, invocation));
    }

    CodeBlock getComponentRequirementExpression(ClassName requestingClass) {
        return this.componentRequirementExpressions.getExpression(this.componentRequirement(), requestingClass);
    }

    private ComponentRequirement componentRequirement() {
        return this.bindingGraph.componentDescriptor().getDependencyThatDefinesMethod(this.binding.bindingElement().get());
    }

    static CodeBlock maybeCheckForNull(ProvisionBinding binding, CompilerOptions compilerOptions, CodeBlock invocation) {
        return binding.shouldCheckForNull(compilerOptions) ? CodeBlock.of((String)"$T.checkNotNullFromComponent($L)", (Object[])new Object[]{Preconditions.class, invocation}) : invocation;
    }

    @AssistedFactory
    static interface Factory {
        public ComponentProvisionRequestRepresentation create(ProvisionBinding var1);
    }
}

