/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.xprocessing.XAnnotationValues;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotationValue;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMemberContainer;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeKt;

public final class AnnotationExpression {
    private final XAnnotation annotation;
    private final ClassName creatorClass;

    AnnotationExpression(XAnnotation annotation) {
        this.annotation = annotation;
        this.creatorClass = AnnotationExpression.getAnnotationCreatorClassName(annotation.getType().getTypeElement());
    }

    CodeBlock getAnnotationInstanceExpression() {
        return this.getAnnotationInstanceExpression(this.annotation);
    }

    private CodeBlock getAnnotationInstanceExpression(XAnnotation annotation) {
        ImmutableMap valueTypesByName = (ImmutableMap)annotation.getType().getTypeElement().getDeclaredMethods().stream().filter(method -> method.getParameters().isEmpty()).collect(DaggerStreams.toImmutableMap(XElements::getSimpleName, XMethodElement::getReturnType));
        return CodeBlock.of((String)"$T.$L($L)", (Object[])new Object[]{this.creatorClass, AnnotationExpression.createMethodName(annotation.getType().getTypeElement()), CodeBlocks.makeParametersCodeBlock((Iterable)annotation.getAnnotationValues().stream().map(value -> {
            String name = value.getName();
            return this.getValueExpression((XAnnotationValue)value, (XType)valueTypesByName.get((Object)name));
        }).collect(DaggerStreams.toImmutableList()))});
    }

    public static ClassName getAnnotationCreatorClassName(XTypeElement annotationType) {
        ClassName annotationTypeName = annotationType.getClassName();
        return annotationTypeName.topLevelClassName().peerClass(SourceFiles.classFileName(annotationTypeName) + "Creator");
    }

    public static String createMethodName(XTypeElement annotationType) {
        return "create" + XElements.getSimpleName((XMemberContainer)annotationType);
    }

    CodeBlock getValueExpression(XAnnotationValue value, XType valueType) {
        return XTypeKt.isArray((XType)valueType) ? CodeBlock.of((String)"new $T[] $L", (Object[])new Object[]{XTypes.asArray((XType)valueType).getComponentType().getRawType().getTypeName(), this.visit(value)}) : this.visit(value);
    }

    private CodeBlock visit(XAnnotationValue value) {
        if (value.hasEnumValue()) {
            return CodeBlock.of((String)"$T.$L", (Object[])new Object[]{value.asEnum().getEnclosingElement().getClassName(), XElements.getSimpleName((XElement)value.asEnum())});
        }
        if (value.hasAnnotationValue()) {
            return this.getAnnotationInstanceExpression(value.asAnnotation());
        }
        if (value.hasTypeValue()) {
            return CodeBlock.of((String)"$T.class", (Object[])new Object[]{value.asType().getTypeName()});
        }
        if (value.hasStringValue()) {
            return CodeBlock.of((String)"$S", (Object[])new Object[]{value.asString()});
        }
        if (value.hasByteValue()) {
            return CodeBlock.of((String)"(byte) $L", (Object[])new Object[]{value.asByte()});
        }
        if (value.hasCharValue()) {
            return CodeBlock.of((String)"$L", (Object[])new Object[]{XAnnotationValues.characterLiteralWithSingleQuotes((char)value.asChar())});
        }
        if (value.hasDoubleValue()) {
            return CodeBlock.of((String)"$LD", (Object[])new Object[]{value.asDouble()});
        }
        if (value.hasFloatValue()) {
            return CodeBlock.of((String)"$LF", (Object[])new Object[]{Float.valueOf(value.asFloat())});
        }
        if (value.hasLongValue()) {
            return CodeBlock.of((String)"$LL", (Object[])new Object[]{value.asLong()});
        }
        if (value.hasShortValue()) {
            return CodeBlock.of((String)"(short) $L", (Object[])new Object[]{value.asShort()});
        }
        if (value.hasListValue()) {
            return CodeBlock.of((String)"{$L}", (Object[])new Object[]{value.asAnnotationValueList().stream().map(this::visit).collect(CodeBlocks.toParametersCodeBlock())});
        }
        return CodeBlock.of((String)"$L", (Object[])new Object[]{value.getValue()});
    }
}

