/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.binding.AutoValue_AssistedInjectionAnnotations_AssistedFactoryMetadata;
import dagger.internal.codegen.binding.AutoValue_AssistedInjectionAnnotations_AssistedParameter;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.model.BindingKind;
import dagger.spi.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XConstructorType;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XHasModifiers;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public final class AssistedInjectionAnnotations {
    public static XMethodElement assistedFactoryMethod(XTypeElement factory) {
        return (XMethodElement)Iterables.getOnlyElement(AssistedInjectionAnnotations.assistedFactoryMethods(factory));
    }

    public static ImmutableSet<XMethodElement> assistedFactoryMethods(XTypeElement factory) {
        return (ImmutableSet)XTypeElements.getAllNonPrivateInstanceMethods((XTypeElement)factory).stream().filter(XHasModifiers::isAbstract).filter(method -> !method.isJavaDefault()).collect(DaggerStreams.toImmutableSet());
    }

    public static boolean isAssistedInjectionType(XTypeElement typeElement) {
        return AssistedInjectionAnnotations.assistedInjectedConstructors(typeElement).stream().anyMatch(constructor -> constructor.hasAnnotation(TypeNames.ASSISTED_INJECT));
    }

    public static boolean isAssistedFactoryType(XElement element) {
        return element.hasAnnotation(TypeNames.ASSISTED_FACTORY);
    }

    public static ImmutableList<ParameterSpec> assistedParameterSpecs(Binding binding) {
        Preconditions.checkArgument((binding.kind() == BindingKind.ASSISTED_INJECTION ? 1 : 0) != 0);
        XConstructorElement constructor = XElements.asConstructor((XElement)binding.bindingElement().get());
        XConstructorType constructorType = constructor.asMemberOf(binding.key().type().xprocessing());
        return AssistedInjectionAnnotations.assistedParameterSpecs(constructor.getParameters(), constructorType.getParameterTypes());
    }

    private static ImmutableList<ParameterSpec> assistedParameterSpecs(List<? extends XVariableElement> paramElements, List<XType> paramTypes) {
        ImmutableList.Builder assistedParameterSpecs = ImmutableList.builder();
        for (int i = 0; i < paramElements.size(); ++i) {
            XVariableElement paramElement = paramElements.get(i);
            XType paramType = paramTypes.get(i);
            if (!AssistedInjectionAnnotations.isAssistedParameter(paramElement)) continue;
            assistedParameterSpecs.add((Object)ParameterSpec.builder((TypeName)paramType.getTypeName(), (String)XElements.getSimpleName((XElement)paramElement), (Modifier[])new Modifier[0]).build());
        }
        return assistedParameterSpecs.build();
    }

    public static ImmutableList<ParameterSpec> assistedFactoryParameterSpecs(Binding binding) {
        Preconditions.checkArgument((binding.kind() == BindingKind.ASSISTED_FACTORY ? 1 : 0) != 0);
        XTypeElement factory = XElements.asTypeElement((XElement)binding.bindingElement().get());
        AssistedFactoryMetadata metadata = AssistedFactoryMetadata.create(factory.getType());
        XMethodType factoryMethodType = metadata.factoryMethod().asMemberOf(binding.key().type().xprocessing());
        return AssistedInjectionAnnotations.assistedParameterSpecs((List)metadata.assistedFactoryAssistedParameters().stream().map(arg_0 -> metadata.assistedInjectAssistedParametersMap().get(arg_0)).collect(DaggerStreams.toImmutableList()), factoryMethodType.getParameterTypes());
    }

    public static ImmutableSet<XConstructorElement> assistedInjectedConstructors(XTypeElement type) {
        return (ImmutableSet)type.getConstructors().stream().filter(constructor -> constructor.hasAnnotation(TypeNames.ASSISTED_INJECT)).collect(DaggerStreams.toImmutableSet());
    }

    public static ImmutableList<XVariableElement> assistedParameters(Binding binding) {
        return binding.kind() == BindingKind.ASSISTED_INJECTION ? (ImmutableList)XElements.asConstructor((XElement)binding.bindingElement().get()).getParameters().stream().filter(AssistedInjectionAnnotations::isAssistedParameter).collect(DaggerStreams.toImmutableList()) : ImmutableList.of();
    }

    public static boolean isAssistedParameter(XVariableElement param) {
        return param.hasAnnotation(TypeNames.ASSISTED);
    }

    public static ImmutableList<AssistedParameter> assistedInjectAssistedParameters(XType assistedInjectType) {
        XConstructorElement assistedInjectConstructor = (XConstructorElement)Iterables.getOnlyElement(AssistedInjectionAnnotations.assistedInjectedConstructors(assistedInjectType.getTypeElement()));
        XConstructorType assistedInjectConstructorType = assistedInjectConstructor.asMemberOf(assistedInjectType);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < assistedInjectConstructor.getParameters().size(); ++i) {
            XVariableElement parameter = (XVariableElement)assistedInjectConstructor.getParameters().get(i);
            XType parameterType = (XType)assistedInjectConstructorType.getParameterTypes().get(i);
            if (!parameter.hasAnnotation(TypeNames.ASSISTED)) continue;
            builder.add((Object)AssistedParameter.create(parameter, parameterType));
        }
        return builder.build();
    }

    private static ImmutableList<AssistedParameter> assistedFactoryAssistedParameters(XMethodElement factoryMethod, XMethodType factoryMethodType) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < factoryMethod.getParameters().size(); ++i) {
            XVariableElement parameter = (XVariableElement)factoryMethod.getParameters().get(i);
            XType parameterType = (XType)factoryMethodType.getParameterTypes().get(i);
            builder.add((Object)AssistedParameter.create(parameter, parameterType));
        }
        return builder.build();
    }

    private AssistedInjectionAnnotations() {
    }

    @AutoValue
    public static abstract class AssistedParameter {
        private XVariableElement parameterElement;
        private XType parameterType;

        public static AssistedParameter create(XVariableElement parameter, XType parameterType) {
            AutoValue_AssistedInjectionAnnotations_AssistedParameter assistedParameter = new AutoValue_AssistedInjectionAnnotations_AssistedParameter(Optional.ofNullable(parameter.getAnnotation(TypeNames.ASSISTED)).map(assisted -> assisted.getAsString("value")).orElse(""), parameterType.getTypeName());
            assistedParameter.parameterElement = parameter;
            assistedParameter.parameterType = parameterType;
            return assistedParameter;
        }

        public abstract String qualifier();

        abstract TypeName typeName();

        public final XType type() {
            return this.parameterType;
        }

        public final XVariableElement element() {
            return this.parameterElement;
        }

        public final String toString() {
            return this.qualifier().isEmpty() ? String.format("@Assisted %s", XTypes.toStableString((XType)this.type())) : String.format("@Assisted(\"%s\") %s", this.qualifier(), XTypes.toStableString((XType)this.type()));
        }
    }

    @AutoValue
    public static abstract class AssistedFactoryMetadata {
        public static AssistedFactoryMetadata create(XType factoryType) {
            XTypeElement factoryElement = factoryType.getTypeElement();
            XMethodElement factoryMethod = AssistedInjectionAnnotations.assistedFactoryMethod(factoryElement);
            XMethodType factoryMethodType = factoryMethod.asMemberOf(factoryType);
            XType assistedInjectType = factoryMethodType.getReturnType();
            XTypeElement assistedInjectElement = assistedInjectType.getTypeElement();
            return new AutoValue_AssistedInjectionAnnotations_AssistedFactoryMetadata(factoryElement, factoryType, factoryMethod, factoryMethodType, assistedInjectElement, assistedInjectType, AssistedInjectionAnnotations.assistedInjectAssistedParameters(assistedInjectType), (ImmutableList<AssistedParameter>)AssistedInjectionAnnotations.assistedFactoryAssistedParameters(factoryMethod, factoryMethodType));
        }

        public abstract XTypeElement factory();

        public abstract XType factoryType();

        public abstract XMethodElement factoryMethod();

        public abstract XMethodType factoryMethodType();

        public abstract XTypeElement assistedInjectElement();

        public abstract XType assistedInjectType();

        public abstract ImmutableList<AssistedParameter> assistedInjectAssistedParameters();

        public abstract ImmutableList<AssistedParameter> assistedFactoryAssistedParameters();

        @Memoized
        public ImmutableMap<AssistedParameter, XVariableElement> assistedInjectAssistedParametersMap() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (AssistedParameter assistedParameter : this.assistedInjectAssistedParameters()) {
                builder.put((Object)assistedParameter, (Object)assistedParameter.element());
            }
            return builder.build();
        }

        @Memoized
        public ImmutableMap<AssistedParameter, XVariableElement> assistedFactoryAssistedParametersMap() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (AssistedParameter assistedParameter : this.assistedFactoryAssistedParameters()) {
                builder.put((Object)assistedParameter, (Object)assistedParameter.element());
            }
            return builder.build();
        }
    }
}

