/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.ComponentCreatorAnnotation;
import dagger.internal.codegen.base.ComponentKind;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.base.ModuleKind;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.ConfigurationAnnotations;
import dagger.internal.codegen.binding.DependencyRequestFactory;
import dagger.internal.codegen.binding.ErrorMessages;
import dagger.internal.codegen.binding.MethodSignatureFormatter;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.validation.ComponentCreatorValidator;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.internal.codegen.validation.MembersInjectionValidator;
import dagger.internal.codegen.validation.ModuleValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.Key;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeKt;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.SourceVersion;

@Singleton
public final class ComponentValidator
implements ClearableCache {
    private final ModuleValidator moduleValidator;
    private final ComponentCreatorValidator creatorValidator;
    private final DependencyRequestValidator dependencyRequestValidator;
    private final MembersInjectionValidator membersInjectionValidator;
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final DependencyRequestFactory dependencyRequestFactory;
    private final DaggerSuperficialValidation superficialValidation;
    private final Map<XTypeElement, ValidationReport> reports = new HashMap<XTypeElement, ValidationReport>();
    private final KotlinMetadataUtil metadataUtil;

    @Inject
    ComponentValidator(ModuleValidator moduleValidator, ComponentCreatorValidator creatorValidator, DependencyRequestValidator dependencyRequestValidator, MembersInjectionValidator membersInjectionValidator, MethodSignatureFormatter methodSignatureFormatter, DependencyRequestFactory dependencyRequestFactory, DaggerSuperficialValidation superficialValidation, KotlinMetadataUtil metadataUtil) {
        this.moduleValidator = moduleValidator;
        this.creatorValidator = creatorValidator;
        this.dependencyRequestValidator = dependencyRequestValidator;
        this.membersInjectionValidator = membersInjectionValidator;
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.dependencyRequestFactory = dependencyRequestFactory;
        this.superficialValidation = superficialValidation;
        this.metadataUtil = metadataUtil;
    }

    @Override
    public void clearCache() {
        this.reports.clear();
    }

    public ValidationReport validate(XTypeElement component) {
        return Util.reentrantComputeIfAbsent(this.reports, component, this::validateUncached);
    }

    private ValidationReport validateUncached(XTypeElement component) {
        return new ElementValidator(component).validateElement();
    }

    private static boolean isEntryPoint(XMethodElement method, XMethodType methodType) {
        return method.isAbstract() && method.getParameters().isEmpty() && !XTypeKt.isVoid((XType)methodType.getReturnType()) && methodType.getTypeVariableNames().isEmpty();
    }

    private void addMethodUnlessOverridden(XMethodElement method, Set<XMethodElement> methods) {
        if (methods.stream().noneMatch(existingMethod -> this.overridesAsDeclared((XMethodElement)existingMethod, method))) {
            methods.removeIf(existingMethod -> this.overridesAsDeclared(method, (XMethodElement)existingMethod));
            methods.add(method);
        }
    }

    private boolean overridesAsDeclared(XMethodElement overrider, XMethodElement overridden) {
        return XProcessingEnvs.javacOverrides((XMethodElement)overrider, (XMethodElement)overridden, (XTypeElement)XElements.asTypeElement((XElement)overrider.getEnclosingElement()));
    }

    private static Optional<XAnnotation> checkForAnnotations(XType type, Set<ClassName> annotations) {
        return Optional.ofNullable(type.getTypeElement()).flatMap(typeElement -> XElements.getAnyAnnotation((XAnnotated)typeElement, (Collection)annotations));
    }

    private class ElementValidator {
        private final XTypeElement component;
        private final ValidationReport.Builder report;
        private final ImmutableSet<ComponentKind> componentKinds;
        private final SetMultimap<XTypeElement, XMethodElement> referencedSubcomponents = LinkedHashMultimap.create();

        ElementValidator(XTypeElement component) {
            this.component = component;
            this.report = ValidationReport.about((XElement)component);
            this.componentKinds = ComponentKind.getComponentKinds(component);
        }

        private ComponentKind componentKind() {
            return (ComponentKind)((Object)Iterables.getOnlyElement(this.componentKinds));
        }

        private ComponentAnnotation componentAnnotation() {
            return ComponentAnnotation.anyComponentAnnotation((XElement)this.component, ComponentValidator.this.superficialValidation).get();
        }

        ValidationReport validateElement() {
            if (this.componentKinds.size() > 1) {
                return this.report.addError(this.moreThanOneComponentAnnotationError(), (XElement)this.component).build();
            }
            if (!this.component.isInterface() && !this.component.isClass()) {
                return this.report.addError(this.invalidTypeError(), (XElement)this.component).build();
            }
            this.validateUseOfCancellationPolicy();
            this.validateIsAbstractType();
            this.validateCreators();
            this.validateNoReusableAnnotation();
            this.validateComponentMethods();
            this.validateNoConflictingEntryPoints();
            this.validateSubcomponentReferences();
            this.validateComponentDependencies();
            this.validateReferencedModules();
            this.validateSubcomponents();
            return this.report.build();
        }

        private String moreThanOneComponentAnnotationError() {
            return String.format("Components may not be annotated with more than one component annotation: found %s", ComponentKind.annotationsFor(this.componentKinds));
        }

        private void validateUseOfCancellationPolicy() {
            if (this.component.hasAnnotation(TypeNames.CANCELLATION_POLICY) && !this.componentKind().isProducer()) {
                this.report.addError("@CancellationPolicy may only be applied to production components and subcomponents", (XElement)this.component);
            }
        }

        private void validateIsAbstractType() {
            if (!this.component.isAbstract()) {
                this.report.addError(this.invalidTypeError(), (XElement)this.component);
            }
        }

        private String invalidTypeError() {
            return String.format("@%s may only be applied to an interface or abstract class", this.componentKind().annotation().simpleName());
        }

        private void validateCreators() {
            ImmutableSet<XTypeElement> creators = ConfigurationAnnotations.enclosedAnnotatedTypes(this.component, ComponentCreatorAnnotation.creatorAnnotationsFor(this.componentAnnotation()));
            creators.forEach(creator -> this.report.addSubreport(ComponentValidator.this.creatorValidator.validate((XTypeElement)creator)));
            if (creators.size() > 1) {
                this.report.addError(String.format(ErrorMessages.componentMessagesFor(this.componentKind()).moreThanOne(), creators.stream().map(XTypeElement::getQualifiedName).collect(DaggerStreams.toImmutableSet())), (XElement)this.component);
            }
        }

        private void validateNoReusableAnnotation() {
            if (this.component.hasAnnotation(TypeNames.REUSABLE)) {
                this.report.addError("@Reusable cannot be applied to components or subcomponents", (XElement)this.component, this.component.getAnnotation(TypeNames.REUSABLE));
            }
        }

        private void validateComponentMethods() {
            this.validateClassMethodName();
            XTypeElements.getAllUnimplementedMethods((XTypeElement)this.component).stream().map(x$0 -> new ComponentMethodValidator((XMethodElement)x$0)).forEachOrdered(ComponentMethodValidator::validateMethod);
        }

        private void validateClassMethodName() {
            if (ComponentValidator.this.metadataUtil.hasMetadata((XElement)this.component)) {
                ComponentValidator.this.metadataUtil.getAllMethodNamesBySignature(this.component).forEach((signature, name) -> {
                    if (SourceVersion.isKeyword(name)) {
                        this.report.addError("Can not use a Java keyword as method name: " + signature);
                    }
                });
            }
        }

        private void validateNoConflictingEntryPoints() {
            HashMultimap entryPoints = HashMultimap.create();
            XTypeElements.getAllMethods((XTypeElement)this.component).stream().filter(method -> ComponentValidator.isEntryPoint(method, method.asMemberOf(this.component.getType()))).forEach(arg_0 -> this.lambda$validateNoConflictingEntryPoints$4((SetMultimap)entryPoints, arg_0));
            Multimaps.asMap((SetMultimap)entryPoints).values().stream().filter(methods -> this.distinctKeys((Set<XMethodElement>)methods).size() > 1).forEach(this::reportConflictingEntryPoints);
        }

        private void reportConflictingEntryPoints(Collection<XMethodElement> methods) {
            Verify.verify((methods.stream().map(XExecutableElement::getEnclosingElement).distinct().count() == (long)methods.size() ? 1 : 0) != 0, (String)"expected each method to be declared on a different type: %s", methods);
            StringBuilder message = new StringBuilder("Found conflicting entry point declarations. Getter methods on the component with the same name and signature must be for the same binding key since the generated component can only implement the method once. Found:");
            ComponentValidator.this.methodSignatureFormatter.typedFormatter(this.component.getType()).formatIndentedList(message, (Iterable<XMethodElement>)ImmutableList.sortedCopyOf(Comparator.comparing(method -> method.getEnclosingElement().getClassName().canonicalName()), methods), 1);
            this.report.addError(message.toString());
        }

        private void validateSubcomponentReferences() {
            Maps.filterValues((Map)this.referencedSubcomponents.asMap(), methods -> methods.size() > 1).forEach((subcomponent, methods) -> {
                Object[] objectArray = new Object[2];
                objectArray[0] = subcomponent.getQualifiedName();
                objectArray[1] = methods.stream().map(ComponentValidator.this.methodSignatureFormatter::formatWithoutReturnType).collect(DaggerStreams.toImmutableSet());
                this.report.addError(String.format(ErrorMessages.ComponentCreatorMessages.moreThanOneRefToSubcomponent(), objectArray), (XElement)this.component);
            });
        }

        private void validateComponentDependencies() {
            for (XType type : this.componentAnnotation().dependencyTypes()) {
                if (!XTypes.isDeclared((XType)type)) {
                    this.report.addError(XTypes.toStableString((XType)type) + " is not a valid component dependency type");
                    continue;
                }
                if (!type.getTypeElement().hasAnyAnnotation(ModuleAnnotation.moduleAnnotations())) continue;
                this.report.addError(XTypes.toStableString((XType)type) + " is a module, which cannot be a component dependency");
            }
        }

        private void validateReferencedModules() {
            this.report.addSubreport(ComponentValidator.this.moduleValidator.validateReferencedModules(this.component, this.componentAnnotation().annotation(), this.componentKind().legalModuleKinds(), new HashSet<XTypeElement>()));
        }

        private void validateSubcomponents() {
            this.referencedSubcomponents.keySet().forEach(subcomponent -> this.report.addSubreport(ComponentValidator.this.validate((XTypeElement)subcomponent)));
        }

        private ImmutableSet<Key> distinctKeys(Set<XMethodElement> methods) {
            return (ImmutableSet)methods.stream().map(this::dependencyRequest).map(DependencyRequest::key).collect(DaggerStreams.toImmutableSet());
        }

        private DependencyRequest dependencyRequest(XMethodElement method) {
            XMethodType methodType = method.asMemberOf(this.component.getType());
            return this.componentKind().isProducer() ? ComponentValidator.this.dependencyRequestFactory.forComponentProductionMethod(method, methodType) : ComponentValidator.this.dependencyRequestFactory.forComponentProvisionMethod(method, methodType);
        }

        private /* synthetic */ void lambda$validateNoConflictingEntryPoints$4(SetMultimap entryPoints, XMethodElement method) {
            ComponentValidator.this.addMethodUnlessOverridden(method, entryPoints.get((Object)XElements.getSimpleName((XElement)method)));
        }

        private class ComponentMethodValidator {
            private final XMethodElement method;
            private final XMethodType resolvedMethod;
            private final List<XType> parameterTypes;
            private final List<XExecutableParameterElement> parameters;
            private final XType returnType;

            ComponentMethodValidator(XMethodElement method) {
                this.method = method;
                this.resolvedMethod = method.asMemberOf(ElementValidator.this.component.getType());
                this.parameterTypes = this.resolvedMethod.getParameterTypes();
                this.parameters = method.getParameters();
                this.returnType = this.resolvedMethod.getReturnType();
            }

            void validateMethod() {
                this.validateNoTypeVariables();
                Optional<ComponentAnnotation> subcomponentAnnotation = this.legalSubcomponentAnnotation();
                if (subcomponentAnnotation.isPresent()) {
                    this.validateSubcomponentFactoryMethod(subcomponentAnnotation.get());
                } else if (this.subcomponentCreatorAnnotation().isPresent()) {
                    this.validateSubcomponentCreatorMethod();
                } else {
                    switch (this.parameters.size()) {
                        case 0: {
                            this.validateProvisionMethod();
                            break;
                        }
                        case 1: {
                            this.validateMembersInjectionMethod();
                            break;
                        }
                        default: {
                            this.reportInvalidMethod();
                        }
                    }
                }
            }

            private void validateNoTypeVariables() {
                if (!this.resolvedMethod.getTypeVariableNames().isEmpty()) {
                    ElementValidator.this.report.addError("Component methods cannot have type variables", (XElement)this.method);
                }
            }

            private Optional<ComponentAnnotation> legalSubcomponentAnnotation() {
                return Optional.ofNullable(this.returnType.getTypeElement()).flatMap(element -> ComponentAnnotation.subcomponentAnnotation(element, ComponentValidator.this.superficialValidation)).filter(annotation -> this.legalSubcomponentAnnotations().contains((Object)annotation.className()));
            }

            private ImmutableSet<ClassName> legalSubcomponentAnnotations() {
                return (ImmutableSet)ElementValidator.this.componentKind().legalSubcomponentKinds().stream().map(ComponentKind::annotation).collect(DaggerStreams.toImmutableSet());
            }

            private Optional<XAnnotation> subcomponentCreatorAnnotation() {
                return ComponentValidator.checkForAnnotations(this.returnType, ElementValidator.this.componentAnnotation().isProduction() ? Sets.intersection(ComponentCreatorAnnotation.subcomponentCreatorAnnotations(), ComponentCreatorAnnotation.productionCreatorAnnotations()) : ComponentCreatorAnnotation.subcomponentCreatorAnnotations());
            }

            private void validateSubcomponentFactoryMethod(ComponentAnnotation subcomponentAnnotation) {
                ElementValidator.this.referencedSubcomponents.put((Object)this.returnType.getTypeElement(), (Object)this.method);
                ImmutableSet legalModuleAnnotations = (ImmutableSet)ComponentKind.forAnnotatedElement(this.returnType.getTypeElement()).get().legalModuleKinds().stream().map(ModuleKind::annotation).collect(DaggerStreams.toImmutableSet());
                ImmutableSet<XTypeElement> moduleTypes = subcomponentAnnotation.modules();
                ImmutableSet<XTypeElement> transitiveModules = this.getTransitiveModules((Collection<XTypeElement>)moduleTypes);
                HashSet referencedModules = Sets.newHashSet();
                for (int i = 0; i < this.parameterTypes.size(); ++i) {
                    XExecutableParameterElement parameter = this.parameters.get(i);
                    XType parameterType = this.parameterTypes.get(i);
                    if (ComponentValidator.checkForAnnotations(parameterType, (Set)legalModuleAnnotations).isPresent()) {
                        XTypeElement module = parameterType.getTypeElement();
                        if (referencedModules.contains(module)) {
                            ElementValidator.this.report.addError(String.format("A module may only occur once as an argument in a Subcomponent factory method, but %s was already passed.", module.getQualifiedName()), (XElement)parameter);
                        }
                        if (!transitiveModules.contains((Object)module)) {
                            ElementValidator.this.report.addError(String.format("%s is present as an argument to the %s factory method, but is not one of the modules used to implement the subcomponent.", module.getQualifiedName(), this.returnType.getTypeElement().getQualifiedName()), (XElement)this.method);
                        }
                        referencedModules.add(module);
                        continue;
                    }
                    ElementValidator.this.report.addError(String.format("Subcomponent factory methods may only accept modules, but %s is not.", XTypes.toStableString((XType)parameterType)), (XElement)parameter);
                }
            }

            private ImmutableSet<XTypeElement> getTransitiveModules(Collection<XTypeElement> seedModules) {
                LinkedHashSet processedElements = Sets.newLinkedHashSet();
                ArrayDeque<XTypeElement> moduleQueue = new ArrayDeque<XTypeElement>(seedModules);
                ImmutableSet.Builder moduleElements = ImmutableSet.builder();
                for (XTypeElement moduleElement : Iterables.consumingIterable(moduleQueue)) {
                    if (!processedElements.add(moduleElement)) continue;
                    ModuleAnnotation.moduleAnnotation((XElement)moduleElement, ComponentValidator.this.superficialValidation).ifPresent(moduleAnnotation -> {
                        moduleElements.add((Object)moduleElement);
                        moduleQueue.addAll((Collection<XTypeElement>)moduleAnnotation.includes());
                        moduleQueue.addAll((Collection<XTypeElement>)this.includesFromSuperclasses(moduleElement));
                    });
                }
                return moduleElements.build();
            }

            private ImmutableSet<XTypeElement> includesFromSuperclasses(XTypeElement element) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                XType superclass = element.getSuperType();
                while (superclass != null && !TypeName.OBJECT.equals((Object)superclass.getTypeName())) {
                    element = superclass.getTypeElement();
                    ModuleAnnotation.moduleAnnotation((XElement)element, ComponentValidator.this.superficialValidation).ifPresent(moduleAnnotation -> builder.addAll(moduleAnnotation.includes()));
                    superclass = element.getSuperType();
                }
                return builder.build();
            }

            private void validateSubcomponentCreatorMethod() {
                ElementValidator.this.referencedSubcomponents.put((Object)this.returnType.getTypeElement().getEnclosingTypeElement(), (Object)this.method);
                if (!this.parameters.isEmpty()) {
                    ElementValidator.this.report.addError(ErrorMessages.ComponentCreatorMessages.builderMethodRequiresNoArgs(), (XElement)this.method);
                }
                XTypeElement creatorElement = this.returnType.getTypeElement();
                ElementValidator.this.report.addSubreport(ComponentValidator.this.creatorValidator.validate(creatorElement));
            }

            private void validateProvisionMethod() {
                ComponentValidator.this.dependencyRequestValidator.validateDependencyRequest(ElementValidator.this.report, (XElement)this.method, this.returnType);
            }

            private void validateMembersInjectionMethod() {
                XType parameterType = (XType)Iterables.getOnlyElement(this.parameterTypes);
                ElementValidator.this.report.addSubreport(ComponentValidator.this.membersInjectionValidator.validateMembersInjectionMethod(this.method, parameterType));
                if (!XTypeKt.isVoid((XType)this.returnType) && !this.returnType.isSameType(parameterType)) {
                    ElementValidator.this.report.addError("Members injection methods may only return the injected type or void.", (XElement)this.method);
                }
            }

            private void reportInvalidMethod() {
                ElementValidator.this.report.addError("This method isn't a valid provision method, members injection method or subcomponent factory method. Dagger cannot implement this method", (XElement)this.method);
            }
        }
    }
}

