/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.SetBuilder;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.DelegateRequestRepresentation;
import dagger.internal.codegen.writing.DerivedFromFrameworkInstanceRequestRepresentation;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.model.DependencyRequest;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import java.util.Collections;

final class SetRequestRepresentation
extends RequestRepresentation {
    private final ProvisionBinding binding;
    private final BindingGraph graph;
    private final ComponentRequestRepresentations componentRequestRepresentations;
    private final XProcessingEnv processingEnv;
    private final boolean isExperimentalMergedMode;

    @AssistedInject
    SetRequestRepresentation(@Assisted ProvisionBinding binding, BindingGraph graph, ComponentImplementation componentImplementation, ComponentRequestRepresentations componentRequestRepresentations, XProcessingEnv processingEnv) {
        this.binding = binding;
        this.graph = graph;
        this.componentRequestRepresentations = componentRequestRepresentations;
        this.processingEnv = processingEnv;
        this.isExperimentalMergedMode = componentImplementation.compilerMode().isExperimentalMergedMode();
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        boolean isImmutableSetAvailable = this.isImmutableSetAvailable();
        if (isImmutableSetAvailable && this.binding.dependencies().stream().allMatch(this::isSingleValue)) {
            return Expression.create(this.immutableSetType(), CodeBlock.builder().add("$T.", new Object[]{ImmutableSet.class}).add(this.maybeTypeParameter(requestingClass)).add("of($L)", new Object[]{this.binding.dependencies().stream().map(dependency -> this.getContributionExpression((DependencyRequest)dependency, requestingClass)).collect(CodeBlocks.toParametersCodeBlock())}).build());
        }
        switch (this.binding.dependencies().size()) {
            case 0: {
                return this.collectionsStaticFactoryInvocation(requestingClass, CodeBlock.of((String)"emptySet()", (Object[])new Object[0]));
            }
            case 1: {
                DependencyRequest dependency2 = (DependencyRequest)Iterables.getOnlyElement(this.binding.dependencies());
                CodeBlock contributionExpression = this.getContributionExpression(dependency2, requestingClass);
                if (this.isSingleValue(dependency2)) {
                    return this.collectionsStaticFactoryInvocation(requestingClass, CodeBlock.of((String)"singleton($L)", (Object[])new Object[]{contributionExpression}));
                }
                if (!isImmutableSetAvailable) break;
                return Expression.create(this.immutableSetType(), CodeBlock.builder().add("$T.", new Object[]{ImmutableSet.class}).add(this.maybeTypeParameter(requestingClass)).add("copyOf($L)", new Object[]{contributionExpression}).build());
            }
        }
        CodeBlock.Builder instantiation = CodeBlock.builder();
        instantiation.add("$T.", new Object[]{isImmutableSetAvailable ? ImmutableSet.class : SetBuilder.class}).add(this.maybeTypeParameter(requestingClass));
        if (this.isImmutableSetBuilderWithExpectedSizeAvailable()) {
            instantiation.add("builderWithExpectedSize($L)", new Object[]{this.binding.dependencies().size()});
        } else if (isImmutableSetAvailable) {
            instantiation.add("builder()", new Object[0]);
        } else {
            instantiation.add("newSetBuilder($L)", new Object[]{this.binding.dependencies().size()});
        }
        for (DependencyRequest dependency3 : this.binding.dependencies()) {
            String builderMethod = this.isSingleValue(dependency3) ? "add" : "addAll";
            instantiation.add(".$L($L)", new Object[]{builderMethod, this.getContributionExpression(dependency3, requestingClass)});
        }
        instantiation.add(".build()", new Object[0]);
        return Expression.create(isImmutableSetAvailable ? this.immutableSetType() : this.binding.key().type().xprocessing(), instantiation.build());
    }

    private XType immutableSetType() {
        return this.processingEnv.getDeclaredType(this.processingEnv.requireTypeElement((TypeName)TypeNames.IMMUTABLE_SET), new XType[]{SetType.from(this.binding.key()).elementType()});
    }

    private CodeBlock getContributionExpression(DependencyRequest dependency, ClassName requestingClass) {
        RequestRepresentation bindingExpression = this.componentRequestRepresentations.getRequestRepresentation(BindingRequest.bindingRequest(dependency));
        CodeBlock expression = this.isExperimentalMergedMode ? this.componentRequestRepresentations.getExperimentalSwitchingProviderDependencyRepresentation(BindingRequest.bindingRequest(dependency)).getDependencyExpression(dependency.kind(), this.binding).codeBlock() : bindingExpression.getDependencyExpression(requestingClass).codeBlock();
        return !this.isSingleValue(dependency) && !Accessibility.isTypeAccessibleFrom(this.binding.key().type().xprocessing(), requestingClass.packageName()) && (bindingExpression instanceof DerivedFromFrameworkInstanceRequestRepresentation || bindingExpression instanceof DelegateRequestRepresentation) ? CodeBlocks.cast(expression, TypeNames.COLLECTION) : expression;
    }

    private Expression collectionsStaticFactoryInvocation(ClassName requestingClass, CodeBlock methodInvocation) {
        return Expression.create(this.binding.key().type().xprocessing(), CodeBlock.builder().add("$T.", new Object[]{Collections.class}).add(this.maybeTypeParameter(requestingClass)).add(methodInvocation).build());
    }

    private CodeBlock maybeTypeParameter(ClassName requestingClass) {
        XType elementType = SetType.from(this.binding.key()).elementType();
        return Accessibility.isTypeAccessibleFrom(elementType, requestingClass.packageName()) ? CodeBlock.of((String)"<$T>", (Object[])new Object[]{elementType.getTypeName()}) : CodeBlock.of((String)"", (Object[])new Object[0]);
    }

    private boolean isSingleValue(DependencyRequest dependency) {
        return this.graph.contributionBinding(dependency.key()).contributionType().equals((Object)ContributionType.SET);
    }

    private boolean isImmutableSetBuilderWithExpectedSizeAvailable() {
        return this.isImmutableSetAvailable() && this.processingEnv.requireTypeElement((TypeName)TypeNames.IMMUTABLE_SET).getDeclaredMethods().stream().anyMatch(method -> XElements.getSimpleName((XElement)method).contentEquals("builderWithExpectedSize"));
    }

    private boolean isImmutableSetAvailable() {
        return this.processingEnv.findTypeElement((TypeName)TypeNames.IMMUTABLE_SET) != null;
    }

    @AssistedFactory
    static interface Factory {
        public SetRequestRepresentation create(ProvisionBinding var1);
    }
}

