/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.AutoValue_OptionalType;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.model.Key;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;

@AutoValue
public abstract class OptionalType {
    private XType type;

    abstract TypeName typeName();

    private XType type() {
        return this.type;
    }

    public OptionalKind kind() {
        return OptionalKind.of(this.type().getTypeElement());
    }

    public XType valueType() {
        return (XType)this.type().getTypeArguments().get(0);
    }

    private static boolean isOptional(XType type) {
        return XTypes.isDeclared((XType)type) && OptionalKind.isOptionalKind(type.getTypeElement());
    }

    public static boolean isOptional(Key key) {
        return OptionalType.isOptional(key.type().xprocessing());
    }

    public static OptionalType from(XType type) {
        Preconditions.checkArgument((boolean)OptionalType.isOptional(type), (String)"%s must be an Optional", (Object)type);
        AutoValue_OptionalType optionalType = new AutoValue_OptionalType(type.getTypeName());
        optionalType.type = type;
        return optionalType;
    }

    public static OptionalType from(Key key) {
        return OptionalType.from(key.type().xprocessing());
    }

    public static enum OptionalKind {
        GUAVA_OPTIONAL(TypeNames.GUAVA_OPTIONAL, "absent"),
        JDK_OPTIONAL(TypeNames.JDK_OPTIONAL, "empty");

        private static final ImmutableMap<ClassName, OptionalKind> OPTIONAL_KIND_BY_CLASS_NAME;
        private final ClassName className;
        private final String absentMethodName;

        private OptionalKind(ClassName className, String absentMethodName) {
            this.className = className;
            this.absentMethodName = absentMethodName;
        }

        private static boolean isOptionalKind(XTypeElement type) {
            return OPTIONAL_KIND_BY_CLASS_NAME.containsKey((Object)type.getClassName());
        }

        private static OptionalKind of(XTypeElement type) {
            return (OptionalKind)((Object)OPTIONAL_KIND_BY_CLASS_NAME.get((Object)type.getClassName()));
        }

        public ParameterizedTypeName of(TypeName valueType) {
            return ParameterizedTypeName.get((ClassName)this.className, (TypeName[])new TypeName[]{valueType});
        }

        public CodeBlock absentValueExpression() {
            return CodeBlock.of((String)"$T.$L()", (Object[])new Object[]{this.className, this.absentMethodName});
        }

        public CodeBlock parameterizedAbsentValueExpression(OptionalType optionalType) {
            return CodeBlock.of((String)"$T.<$T>$L()", (Object[])new Object[]{this.className, optionalType.valueType().getTypeName(), this.absentMethodName});
        }

        public CodeBlock presentExpression(CodeBlock value) {
            return CodeBlock.of((String)"$T.of($L)", (Object[])new Object[]{this.className, value});
        }

        public CodeBlock presentObjectExpression(CodeBlock value) {
            return CodeBlock.of((String)"$T.<$T>of($L)", (Object[])new Object[]{this.className, TypeName.OBJECT, value});
        }

        static {
            OPTIONAL_KIND_BY_CLASS_NAME = (ImmutableMap)DaggerStreams.valuesOf(OptionalKind.class).collect(DaggerStreams.toImmutableMap(value -> value.className, value -> value));
        }
    }
}

