/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XConstructorType;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableType;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.stream.Collectors;

public final class XExecutableTypes {
    public static boolean isSubsignature(XMethodElement method1, XMethodElement method2) {
        return XExecutableTypes.isSubsignature((XExecutableType)method1.getExecutableType(), (XExecutableType)method2.getExecutableType(), XConverters.getProcessingEnv((XElement)method1));
    }

    public static boolean isSubsignature(XExecutableType type1, XExecutableType type2, XProcessingEnv processingEnv) {
        return XConverters.toJavac((XProcessingEnv)processingEnv).getTypeUtils().isSubsignature(XConverters.toJavac((XExecutableType)type1), XConverters.toJavac((XExecutableType)type2));
    }

    public static boolean isConstructorType(XExecutableType executableType) {
        return executableType instanceof XConstructorType;
    }

    public static boolean isMethodType(XExecutableType executableType) {
        return executableType instanceof XMethodType;
    }

    public static XMethodType asMethodType(XExecutableType executableType) {
        return (XMethodType)executableType;
    }

    public static String getKindName(XExecutableType executableType) {
        if (XExecutableTypes.isMethodType(executableType)) {
            return "METHOD";
        }
        if (XExecutableTypes.isConstructorType(executableType)) {
            return "CONSTRUCTOR";
        }
        return "UNKNOWN";
    }

    public static String toStableString(XExecutableType executableType) {
        try {
            return String.format("(%s)%s", executableType.getParameterTypes().stream().map(XTypes::toStableString).collect(Collectors.joining(",")), XExecutableTypes.isMethodType(executableType) ? XTypes.toStableString(XExecutableTypes.asMethodType(executableType).getReturnType()) : TypeName.VOID);
        }
        catch (TypeNotPresentException e) {
            return e.typeName();
        }
    }

    private XExecutableTypes() {
    }
}

