/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.kotlin;

import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.KotlinMetadata;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class KotlinMetadataFactory
implements ClearableCache {
    private final Map<XTypeElement, KotlinMetadata> metadataCache = new HashMap<XTypeElement, KotlinMetadata>();

    @Inject
    KotlinMetadataFactory() {
    }

    public KotlinMetadata create(XElement element) {
        XTypeElement enclosingElement = XElements.closestEnclosingTypeElement(element);
        if (!enclosingElement.hasAnnotation(TypeNames.KOTLIN_METADATA)) {
            throw new IllegalStateException("Missing @Metadata for: " + enclosingElement);
        }
        return this.metadataCache.computeIfAbsent(enclosingElement, KotlinMetadata::from);
    }

    @Override
    public void clearCache() {
        this.metadataCache.clear();
    }
}

